/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.illidan.services.http;

import com.taobao.illidan.common.utils.logging.InternalLogger;
import com.taobao.illidan.common.utils.logging.InternalLoggerFactory;
import com.taobao.illidan.core.Function;
import com.taobao.illidan.core.Predicate;
import com.taobao.illidan.services.core.Invokable;
import com.taobao.illidan.services.core.Record;
import com.taobao.illidan.services.core.ServiceDiscovery;
import com.taobao.illidan.services.http.HttpMappingManager;
import com.taobao.illidan.services.http.IllidanHttpHandler;
import com.taobao.illidan.services.http.constants.HttpCode;
import com.taobao.illidan.services.http.constants.HttpMethod;
import com.taobao.illidan.services.http.domain.PathInfo;
import com.taobao.illidan.services.http.extender.ExtendedHandler;
import com.taobao.illidan.services.http.extender.PathMappingExtender;
import com.taobao.illidan.services.http.jsonrpc.JsonRpcHttpHandler;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.RoutingHandler;
import io.undertow.util.AttachmentKey;
import java.util.HashMap;
import java.util.Map;

public class UndertowHandler {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(UndertowHandler.class);
    private ServiceDiscovery serviceDiscovery;
    private final RoutingHandler routingHandler;
    private AttachmentKey<Object> refreshedKey = AttachmentKey.create(Object.class);
    private HttpMappingManager mappings = HttpMappingManager.getInstance();

    UndertowHandler(ServiceDiscovery serviceDiscovery) {
        this(serviceDiscovery, Handlers.routing());
    }

    UndertowHandler(ServiceDiscovery serviceDiscovery, RoutingHandler routingHandler) {
        this.serviceDiscovery = serviceDiscovery;
        this.routingHandler = routingHandler;
        this.initExtendedHandler();
        routingHandler.setFallbackHandler((HttpHandler)new FallbackHandler());
    }

    RoutingHandler routingHandler() {
        return this.routingHandler;
    }

    public void add(String path, Record record) {
        Invokable invokable = (Invokable)this.serviceDiscovery.getReference(record).get();
        Map locations = record.getLocations().getLocations();
        JsonRpcHttpHandler handler = new JsonRpcHttpHandler(path, invokable, locations);
        this.routingHandler.add(HttpMethod.POST.name(), path, (HttpHandler)handler);
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("name", record.getName());
        this.mappings.add(path, HttpMethod.POST.name(), "application/json", info);
        LOGGER.info("Mapped \"{}\" onto {}, service record is {}.", new Object[]{path, handler, record.getName()});
    }

    public void add(HttpMethod httpMethod, String path, PathInfo pathInfo, Record record) {
        Invokable invokable = (Invokable)this.serviceDiscovery.getReference(record).get();
        String[] paramInfos = record.getLocations().getLocation(pathInfo.getLocation());
        IllidanHttpHandler illidanHttpHandler = new IllidanHttpHandler(httpMethod, path, pathInfo, invokable, paramInfos);
        this.routingHandler.add(httpMethod.name(), path, (HttpHandler)illidanHttpHandler);
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("name", record.getName());
        info.put("method", pathInfo.getLocation());
        info.put("params", paramInfos);
        this.mappings.add(path, httpMethod.name(), pathInfo.getProduceType(), info);
        LOGGER.info("Mapped \"{}\" onto {}, service record is {}.", new Object[]{path, illidanHttpHandler, record.getName()});
    }

    private void initExtendedHandler() {
        ExtendedHandler.Helper.runAll(new Predicate<ExtendedHandler>(){

            public boolean test(ExtendedHandler t) {
                return t.getClass().isAnnotationPresent(PathMappingExtender.class);
            }
        }, new Function<ExtendedHandler, Object>(){

            public Object apply(ExtendedHandler t) {
                UndertowHandler.this.initPathMappingExtendedHandler(t);
                return null;
            }
        });
    }

    private void initPathMappingExtendedHandler(final ExtendedHandler extendHandler) {
        final PathMappingExtender pathTemplateMappingExtender = extendHandler.getClass().getAnnotation(PathMappingExtender.class);
        this.routingHandler.add(pathTemplateMappingExtender.httpMethod().name(), pathTemplateMappingExtender.path(), new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                if (pathTemplateMappingExtender.runOnBlocking()) {
                    if (exchange.isInIoThread()) {
                        exchange.dispatch((HttpHandler)this);
                        return;
                    }
                    exchange.startBlocking();
                }
                extendHandler.handleRequest(exchange);
            }
        });
    }

    private class FallbackHandler
    implements HttpHandler {
        private FallbackHandler() {
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            Boolean refreshed = Boolean.valueOf(String.valueOf(exchange.getAttachment(UndertowHandler.this.refreshedKey)));
            if (refreshed.booleanValue()) {
                String relativePath = exchange.getRelativePath();
                LOGGER.warn("Could not find path to mapping request. request path is {}.", (Object)relativePath);
                exchange.setStatusCode(HttpCode.Notfound.getCode()).getResponseSender().send("Could not find handler with path " + relativePath);
                return;
            }
            UndertowHandler.this.serviceDiscovery.refresh();
            exchange.putAttachment(UndertowHandler.this.refreshedKey, (Object)"true");
            UndertowHandler.this.routingHandler.handleRequest(exchange);
        }
    }
}

