/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.illidan.services.http;

import com.taobao.illidan.common.utils.StandardCharsets;
import com.taobao.illidan.common.utils.io.IOUtils;
import com.taobao.illidan.common.utils.json.DecodeException;
import com.taobao.illidan.common.utils.json.EncodeException;
import com.taobao.illidan.common.utils.json.JsonMarshaller;
import com.taobao.illidan.common.utils.json.JsonMarshallerFactory;
import com.taobao.illidan.common.utils.logging.InternalLogger;
import com.taobao.illidan.common.utils.logging.InternalLoggerFactory;
import com.taobao.illidan.core.Function;
import com.taobao.illidan.core.Predicate;
import com.taobao.illidan.services.core.Invokable;
import com.taobao.illidan.services.http.Error;
import com.taobao.illidan.services.http.Result;
import com.taobao.illidan.services.http.constants.HttpCode;
import com.taobao.illidan.services.http.constants.HttpMethod;
import com.taobao.illidan.services.http.domain.ParamInfo;
import com.taobao.illidan.services.http.domain.PathInfo;
import com.taobao.illidan.services.http.domain.ServiceParamType;
import com.taobao.illidan.services.http.extender.EmbeddedExtender;
import com.taobao.illidan.services.http.extender.ExtendedHandler;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderValues;
import io.undertow.util.HttpString;
import io.undertow.util.PathTemplateMatch;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.List;
import java.util.Map;

class IllidanHttpHandler
implements HttpHandler {
    private static final HttpString CONTENT_TYPE_HEADER_NAME = new HttpString("Content-Type");
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(IllidanHttpHandler.class);
    private JsonMarshaller marshaller = JsonMarshallerFactory.factory.getInstance();
    private final PathInfo pathInfo;
    protected final String path;
    private final String location;
    private final String[] paramInfos;
    private final Invokable invokable;
    private final HttpMethod httpMethod;
    private final List<ExtendedHandler> embeddedExtenders = new ArrayList<ExtendedHandler>();

    IllidanHttpHandler(HttpMethod httpMethod, String path, PathInfo pathInfo, Invokable invokable, String[] paramInfos) {
        this.httpMethod = httpMethod;
        this.pathInfo = pathInfo;
        this.invokable = invokable;
        this.path = path;
        this.location = pathInfo.getLocation();
        this.paramInfos = paramInfos;
        this.initEmbeddedExtenders();
    }

    private void initEmbeddedExtenders() {
        ExtendedHandler.Helper.runAll(new Predicate<ExtendedHandler>(){

            public boolean test(ExtendedHandler t) {
                return t.getClass().isAnnotationPresent(EmbeddedExtender.class);
            }
        }, new Function<ExtendedHandler, Object>(){

            public Object apply(ExtendedHandler t) {
                IllidanHttpHandler.this.embeddedExtenders.add(t);
                return null;
            }
        });
        Collections.sort(this.embeddedExtenders, new Comparator<ExtendedHandler>(){

            @Override
            public int compare(ExtendedHandler o1, ExtendedHandler o2) {
                int o1Order = o1.getClass().getAnnotation(EmbeddedExtender.class).order();
                int o2Order = o2.getClass().getAnnotation(EmbeddedExtender.class).order();
                return o1Order - o2Order;
            }
        });
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        Object[] args = null;
        if (exchange.isInIoThread()) {
            exchange.dispatch((HttpHandler)this);
            return;
        }
        exchange.startBlocking();
        if (this.executeEmbeddedExtenders(exchange)) {
            return;
        }
        try {
            args = this.parseArguments(exchange);
        }
        catch (Exception e1) {
            LOGGER.error("parse argument failed. handler is " + this, (Throwable)e1);
            IllidanHttpHandler.send(exchange, HttpCode.BadRequest, "parse arguments failed.");
            return;
        }
        try {
            this.send(exchange, new Result(this.invoke(args), this.pathInfo.getProduceType()));
        }
        catch (IllegalArgumentException e1) {
            LOGGER.error("failed to invoke target, handler is " + this, (Throwable)e1);
            this.send(exchange, new Error(HttpCode.InternalServerError, "invoke target failed."));
        }
        catch (InvocationTargetException e) {
            LOGGER.error("failed to invoke target, handler is " + this, (Throwable)e);
            this.send(exchange, new Error(HttpCode.InternalServerError, "invoke target failed."));
        }
        catch (Exception e) {
            LOGGER.error("failed to invoke target with unknown reason, handler is " + this, (Throwable)e);
            this.send(exchange, new Error(HttpCode.InternalServerError, "invoke target failed."));
        }
    }

    private boolean executeEmbeddedExtenders(HttpServerExchange exchange) {
        for (ExtendedHandler handler : this.embeddedExtenders) {
            handler.handleRequest(exchange);
            Boolean interruptFlag = (Boolean)exchange.getAttachment(EmbeddedExtender.INTERRUPT_FLAG);
            if (null == interruptFlag || !interruptFlag.booleanValue()) continue;
            return true;
        }
        return false;
    }

    private Object[] parseArguments(HttpServerExchange exchange) throws Exception {
        Object[] args = new Object[this.pathInfo.getParamCount()];
        int index = 0;
        for (Map.Entry<String, ParamInfo> paramInfoEntry : this.pathInfo.getParamInfos().entrySet()) {
            ParamInfo p = paramInfoEntry.getValue();
            ServiceParamType type = p.getType();
            String className = this.paramInfos[index];
            Object value = null;
            switch (type) {
                case Path: {
                    value = this.valueFromPath(exchange, className, p.getName());
                    break;
                }
                case Query: {
                    value = this.valueFromQuery(exchange, className, p.getName());
                    break;
                }
                case Body: {
                    value = this.valueFromPost(exchange, className);
                    break;
                }
            }
            args[index] = null == value ? IllidanHttpHandler.valueFromString(className, p.getDefaultValue()) : value;
            ++index;
        }
        return args;
    }

    private Object valueFromPath(HttpServerExchange exchange, String className, String paramName) {
        PathTemplateMatch pathMatch = (PathTemplateMatch)exchange.getAttachment(PathTemplateMatch.ATTACHMENT_KEY);
        Map parameters = pathMatch.getParameters();
        if (null != parameters && !parameters.isEmpty()) {
            return IllidanHttpHandler.valueFromString(className, (String)parameters.get(paramName));
        }
        return null;
    }

    private Object valueFromQuery(HttpServerExchange exchange, String className, String paramName) {
        Map query = exchange.getQueryParameters();
        Deque deque = (Deque)query.get(paramName);
        if (null != deque && !deque.isEmpty()) {
            return IllidanHttpHandler.valueFromString(className, (String)deque.getFirst());
        }
        return null;
    }

    private Object valueFromPost(HttpServerExchange exchange, String className) throws Exception {
        InputStream i = exchange.getInputStream();
        HeaderValues contentType = exchange.getRequestHeaders().get("Content-Encoding");
        try {
            String input = IOUtils.toString((InputStream)i, (String)(null == contentType || contentType.isEmpty() ? StandardCharsets.UTF_8.name() : contentType.getFirst()));
            return null == input ? null : this.marshaller.decodeValue(input, Class.forName(className));
        }
        catch (IOException e) {
            LOGGER.error("fail to receive value from POST body", (Throwable)e);
            throw e;
        }
        catch (DecodeException e) {
            LOGGER.error("fail to decode value from POST body", (Throwable)e);
            throw e;
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("fail to deserialize value from POST body to class " + className, (Throwable)e);
            throw e;
        }
    }

    private Object invoke(Object[] args) throws Exception {
        return this.invokable.call(this.pathInfo.getLocation(), args);
    }

    private void send(HttpServerExchange exchange, Object r) {
        try {
            Object resultObj;
            if (r instanceof Error) {
                String resultString = this.marshaller.encode((Object)((Error)r).getErrorInfo());
                IllidanHttpHandler.send(exchange, ((Error)r).getCode(), resultString);
            } else if (r instanceof Result && null != (resultObj = ((Result)r).result)) {
                String type = ((Result)r).type;
                if ("application/json".equals(type)) {
                    String resultString = this.marshaller.encode(resultObj);
                    exchange.getResponseHeaders().add(CONTENT_TYPE_HEADER_NAME, "application/json");
                    IllidanHttpHandler.send(exchange, HttpCode.OK, resultString);
                    return;
                }
                if ("text/plain".equals(type)) {
                    String resultString = resultObj.toString();
                    exchange.getResponseHeaders().add(CONTENT_TYPE_HEADER_NAME, "text/plain");
                    IllidanHttpHandler.send(exchange, HttpCode.OK, resultString);
                    return;
                }
                LOGGER.error("fail to send result, handler is " + this);
                IllidanHttpHandler.send(exchange, HttpCode.UnsupportedMediaType, Error.PRODUCE_TYPE_ERROR.getErrorInfo());
            }
        }
        catch (EncodeException e) {
            LOGGER.error("fail to marshall result, handler is " + this, (Throwable)e);
            IllidanHttpHandler.send(exchange, HttpCode.InternalServerError, "marshall result failed.");
        }
        catch (Exception e) {
            LOGGER.error("fail to invoke target, handler is " + this, (Throwable)e);
            IllidanHttpHandler.send(exchange, HttpCode.InternalServerError, "fail to invoke service with internal error.");
        }
    }

    private static void send(HttpServerExchange exchange, HttpCode code, String result) {
        exchange.setStatusCode(code.getCode()).getResponseSender().send(result);
    }

    private static Object valueFromString(String classString, String value) {
        if (null == value) {
            return null;
        }
        if ("int".equals(classString) || "java.lang.Integer".equals(classString)) {
            return Integer.valueOf(value);
        }
        if ("long".equals(classString) || "java.lang.Long".equals(classString)) {
            return Long.valueOf(value);
        }
        if ("double".equals(classString) || "java.lang.Double".equals(classString)) {
            return Double.valueOf(value);
        }
        if ("float".equals(classString) || "java.lang.Float".equals(classString)) {
            return Float.valueOf(value);
        }
        if ("short".equals(classString) || "java.lang.Short".equals(classString)) {
            return Short.valueOf(value);
        }
        if ("boolean".equals(classString) || "java.lang.Boolean".equals(classString)) {
            return Boolean.valueOf(value);
        }
        return value;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("IllidanHttpHandler [httpMethod=");
        builder.append((Object)this.httpMethod);
        builder.append(", path=");
        builder.append(this.path);
        builder.append(", pathInfo=");
        builder.append(this.pathInfo);
        builder.append(", location=");
        builder.append(this.location);
        builder.append(", paramInfos=");
        builder.append(Arrays.toString(this.paramInfos));
        builder.append("]");
        return builder.toString();
    }
}

