/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.illidan.services.http;

import com.taobao.illidan.common.utils.config.Configuration;
import com.taobao.illidan.common.utils.identify.Identifiable;
import com.taobao.illidan.core.Future;
import com.taobao.illidan.services.core.Record;
import com.taobao.illidan.services.core.ServiceDiscovery;
import com.taobao.illidan.services.core.impl.ServiceExporterAdapter;
import com.taobao.illidan.services.http.JsonRpcServiceExporter;
import com.taobao.illidan.services.http.UndertowHandler;
import com.taobao.illidan.services.http.UndertowHttpServer;
import com.taobao.illidan.services.http.constants.HttpMethod;
import com.taobao.illidan.services.http.domain.HttpMetadata;
import com.taobao.illidan.services.http.domain.PathInfo;
import java.util.Map;

@Identifiable(value="http")
public class HttpServiceExporter
extends ServiceExporterAdapter {
    private UndertowHandler undertowHandler;
    private UndertowHttpServer server;
    private JsonRpcServiceExporter jsonRpcExporter;

    public void init(ServiceDiscovery discovery, Future<Void> future) {
        this.server = new UndertowHttpServer(discovery);
        this.undertowHandler = this.server.getHandler();
        String localIP = Configuration.getConfig((String)"illidan.http.host");
        Integer port = Integer.valueOf(Configuration.getConfig((String)"illidan.http.port"));
        this.server.start(localIP, port);
        this.jsonRpcExporter = new JsonRpcServiceExporter(this.server);
        future.complete();
    }

    public void onPublish(Record record) {
        this.jsonRpcExporter.onPublish(record);
        if (this.noNeedPublish(record)) {
            return;
        }
        HttpMetadata httpMetadata = (HttpMetadata)record.getMetadata("http");
        for (Map.Entry<HttpMethod, Map<String, PathInfo>> entry : httpMetadata.getPathInfos()) {
            HttpMethod httpMethod = entry.getKey();
            Map<String, PathInfo> pathInfos = entry.getValue();
            for (Map.Entry<String, PathInfo> pathInfo : pathInfos.entrySet()) {
                String path = pathInfo.getKey();
                if (HttpMethod.UNDEFINE.equals((Object)httpMethod)) continue;
                if (HttpMethod.ALL.equals((Object)httpMethod)) {
                    this.undertowHandler.add(HttpMethod.DELETE, path, pathInfo.getValue(), record);
                    this.undertowHandler.add(HttpMethod.GET, path, pathInfo.getValue(), record);
                    this.undertowHandler.add(HttpMethod.POST, path, pathInfo.getValue(), record);
                    this.undertowHandler.add(HttpMethod.PUT, path, pathInfo.getValue(), record);
                    continue;
                }
                this.undertowHandler.add(httpMethod, path, pathInfo.getValue(), record);
            }
        }
    }

    private boolean noNeedPublish(Record record) {
        return "http".equals(record.getType());
    }

    public void close() {
        if (null != this.server) {
            this.server.stop();
            this.server = null;
        }
    }
}

