/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.illidan.services.http;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class HttpMappingManager {
    private static HttpMappingManager instance = new HttpMappingManager();
    private Map<HttpMappingKey, Map<String, Object>> mappingInfos = new ConcurrentHashMap<HttpMappingKey, Map<String, Object>>();

    private HttpMappingManager() {
    }

    public static HttpMappingManager getInstance() {
        return instance;
    }

    public Map<HttpMappingKey, Map<String, Object>> getAll() {
        return Collections.unmodifiableMap(this.mappingInfos);
    }

    public void add(String path, String httpMethod, String produceType, Map<String, Object> info) {
        HttpMappingKey key = new HttpMappingKey();
        key.setPaths(new String[]{path});
        key.setHttpMethods(new String[]{httpMethod});
        key.setProduceTypes(new String[]{produceType});
        this.mappingInfos.put(key, info);
    }

    public static class HttpMappingKey {
        String[] paths;
        String[] httpMethods;
        String[] produceTypes;

        public String[] getPaths() {
            return this.paths;
        }

        public void setPaths(String[] paths) {
            this.paths = paths;
        }

        public String[] getHttpMethods() {
            return this.httpMethods;
        }

        public void setHttpMethods(String[] httpMethods) {
            this.httpMethods = httpMethods;
        }

        public String[] getProduceTypes() {
            return this.produceTypes;
        }

        public void setProduceTypes(String[] produceTypes) {
            this.produceTypes = produceTypes;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.httpMethods);
            result = 31 * result + Arrays.hashCode(this.paths);
            result = 31 * result + Arrays.hashCode(this.produceTypes);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HttpMappingKey other = (HttpMappingKey)obj;
            if (!Arrays.equals(this.httpMethods, other.httpMethods)) {
                return false;
            }
            if (!Arrays.equals(this.paths, other.paths)) {
                return false;
            }
            return Arrays.equals(this.produceTypes, other.produceTypes);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("{");
            builder.append(Arrays.toString(this.paths));
            builder.append(", httpMethods=");
            builder.append(Arrays.toString(this.httpMethods));
            builder.append(", produceTypes=");
            builder.append(Arrays.toString(this.produceTypes));
            builder.append("}");
            return builder.toString();
        }
    }
}

