/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.illidan.services.http;

import com.taobao.illidan.services.http.constants.HttpCode;

class Error {
    private HttpCode code;
    private String errorInfo;
    static Error SERVICE_NOT_FOUND = new Error(HttpCode.Notfound){

        @Override
        public String getErrorInfo() {
            return "service not found.";
        }
    };
    static Error INVOKER_ERROR = new Error(HttpCode.InternalServerError){

        @Override
        public String getErrorInfo() {
            return "invoker error with internal error.";
        }
    };
    static Error PRODUCE_TYPE_ERROR = new Error(HttpCode.UnsupportedMediaType){

        @Override
        public String getErrorInfo() {
            return "produce type is not support yet.";
        }
    };

    private Error(HttpCode code) {
        this.code = code;
    }

    public HttpCode getCode() {
        return this.code;
    }

    Error(HttpCode code, String errorInfo) {
        this.code = code;
        this.errorInfo = errorInfo;
    }

    public String getErrorInfo() {
        return this.errorInfo;
    }
}

