/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.illidan.services.hsf;

import com.taobao.illidan.common.utils.identify.Identifiable;
import com.taobao.illidan.services.core.Metadata;
import com.taobao.illidan.services.core.Record;
import com.taobao.illidan.services.core.ServiceAdditionInfoInjector;
import com.taobao.illidan.services.hsf.HSFMetadata;
import java.util.Collection;

@Identifiable(value="hsf:simple")
public class SimpleHSFInfoInjector
implements ServiceAdditionInfoInjector {
    public void injectServiceInfo(Record record, Class<?> service) {
        Class<?> intf;
        HSFMetadata hsfMetadata = (HSFMetadata)record.getMetadata(this.getAdditionalInfoType());
        if (null == hsfMetadata) {
            hsfMetadata = new HSFMetadata();
            record.setMetadata("hsf", (Metadata)hsfMetadata);
        }
        if (null == (intf = this.findFirstInterface(service))) {
            throw new IllegalArgumentException("can not inject hsf info without interface. service object is " + service);
        }
        Class<?> defaultIntf = intf;
        hsfMetadata.setGroup("HSF");
        hsfMetadata.setVersion("1.0.0");
        hsfMetadata.setInterfaceName(defaultIntf.getName());
    }

    private Class<?> findFirstInterface(Class<?> service) {
        if (Object.class.equals(service)) {
            return null;
        }
        Class<?>[] interfaces = service.getInterfaces();
        if (null != interfaces && 0 != interfaces.length) {
            return interfaces[0];
        }
        return this.findFirstInterface(service.getSuperclass());
    }

    public void injectLocationInfo(Record record, Collection locationObjects) {
    }

    public String getAdditionalInfoType() {
        return "hsf";
    }
}

