/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.illidan.services.hsf;

import com.taobao.hsf.model.ProviderServiceModel;
import com.taobao.illidan.common.utils.identify.Identifiable;
import com.taobao.illidan.common.utils.logging.InternalLogger;
import com.taobao.illidan.common.utils.logging.InternalLoggerFactory;
import com.taobao.illidan.services.core.Metadata;
import com.taobao.illidan.services.core.impl.AbstractServiceInfoExtractor;
import com.taobao.illidan.services.hsf.HSFMetadata;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;

@Identifiable(value="hsf")
public class HSFServiceInfoExtractor
extends AbstractServiceInfoExtractor {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(HSFServiceInfoExtractor.class);

    protected Collection getLocationObjects(Object service) {
        ProviderServiceModel inputService = (ProviderServiceModel)service;
        Class ifClazz = inputService.getMetadata().getIfClazz();
        Method[] methods = ifClazz.getMethods();
        Class<?> targetClass = inputService.getMetadata().getTarget().getClass();
        ArrayList<Method> dstMethods = new ArrayList<Method>();
        if (null != methods) {
            for (Method m : methods) {
                try {
                    dstMethods.add(targetClass.getMethod(m.getName(), m.getParameterTypes()));
                }
                catch (Exception e) {
                    LOGGER.error("this shouldn't happen", (Throwable)e);
                }
            }
        }
        return dstMethods;
    }

    protected String getServiceName(Object service) {
        ProviderServiceModel inputService = (ProviderServiceModel)service;
        return inputService.getServiceName();
    }

    protected String getServiceType(Object service) {
        return "hsf";
    }

    protected Class getServiceClass(Object service) {
        ProviderServiceModel inputService = (ProviderServiceModel)service;
        return inputService.getMetadata().getTarget().getClass();
    }

    protected Metadata createMetadata() {
        return new HSFMetadata();
    }
}

