/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.illidan.services.hsf;

import com.taobao.hsf.model.ApplicationModel;
import com.taobao.hsf.model.ProviderServiceModel;
import com.taobao.illidan.common.utils.StringUtil;
import com.taobao.illidan.common.utils.config.Configuration;
import com.taobao.illidan.common.utils.identify.Identifiable;
import com.taobao.illidan.common.utils.identify.Identifier;
import com.taobao.illidan.common.utils.logging.InternalLogger;
import com.taobao.illidan.common.utils.logging.InternalLoggerFactory;
import com.taobao.illidan.core.Future;
import com.taobao.illidan.services.core.Record;
import com.taobao.illidan.services.core.Refreshable;
import com.taobao.illidan.services.core.ServiceAcceptor;
import com.taobao.illidan.services.core.ServiceAcceptorAware;
import com.taobao.illidan.services.core.ServiceAdditionInfoInjector;
import com.taobao.illidan.services.core.ServiceAdditionInfoInjectorAware;
import com.taobao.illidan.services.core.ServiceImporter;
import com.taobao.illidan.services.core.ServiceInfoExtractor;
import com.taobao.illidan.services.core.ServicePublisher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

@Identifiable(value="hsf")
public class HSFServiceImporter
implements ServiceImporter,
ServiceAcceptorAware,
ServiceAdditionInfoInjectorAware,
Refreshable {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(HSFServiceImporter.class);
    private ServiceInfoExtractor serviceInfoExtractor = (ServiceInfoExtractor)Identifier.get((String)"hsf", ServiceInfoExtractor.class);
    private Collection<ServiceAcceptor> acceptors = Collections.emptyList();
    private List<ServiceAdditionInfoInjector> infoInjectors = Collections.emptyList();
    private Collection<ProviderServiceModel> loadedProviders = new ArrayList<ProviderServiceModel>();
    private AtomicBoolean started = new AtomicBoolean(false);
    private ServicePublisher publisher;

    public void start(ServicePublisher publisher, Future<Void> future) {
        if (!HSFServiceImporter.shouldImportHsf()) {
            return;
        }
        if (!this.started.compareAndSet(false, true)) {
            return;
        }
        this.publisher = publisher;
        this.refreshProviders();
        future.complete();
    }

    public static boolean shouldImportHsf() {
        String p = Configuration.getConfig((String)"illidan.hsf.import.enable");
        return StringUtil.isNotNullOrEmpty((String)p) ? Boolean.valueOf(p) : true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshProviders() {
        Collection newProviders = ApplicationModel.instance().allProvidedServices();
        Collection<ProviderServiceModel> oldProviders = this.loadedProviders;
        LOGGER.info("refresh Providers newProviders are {} , oldProviders are {}.", (Object)newProviders, oldProviders);
        if (!oldProviders.containsAll(newProviders)) {
            Collection<ProviderServiceModel> collection = this.loadedProviders;
            synchronized (collection) {
                LOGGER.info("refresh providers, providers are {}.", (Object)newProviders);
                this.importHsfProviders(oldProviders, newProviders);
                this.loadedProviders = newProviders;
            }
        }
    }

    private void importHsfProviders(Collection<ProviderServiceModel> loadedProviders, Collection<ProviderServiceModel> providers) {
        if (providers == null || providers.isEmpty()) {
            return;
        }
        for (ProviderServiceModel provider : providers) {
            if (loadedProviders.contains(provider)) continue;
            boolean accepted = true;
            for (ServiceAcceptor acceptor : this.acceptors) {
                if (acceptor.accept(provider.getServiceInstance())) continue;
                accepted = false;
                break;
            }
            LOGGER.info("providers acceptor result is {}, provider is {}.", (Object)accepted, provider.getServiceInstance());
            if (!accepted) continue;
            Record record = this.serviceInfoExtractor.extract((Object)provider, this.infoInjectors.toArray(new ServiceAdditionInfoInjector[this.infoInjectors.size()]));
            this.publisher.publish(record);
        }
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServiceAdditionInfoInjectors(List<ServiceAdditionInfoInjector> serviceAdditionInfoInjectors) {
        HSFServiceImporter hSFServiceImporter = this;
        synchronized (hSFServiceImporter) {
            this.infoInjectors = serviceAdditionInfoInjectors;
        }
    }

    public void setServiceAcceptors(Collection<ServiceAcceptor> serviceAcceptors) {
        this.acceptors = serviceAcceptors;
    }

    public void refresh() {
        if (!this.started.get()) {
            throw new IllegalStateException("Refresh must invoked after start.");
        }
        this.refreshProviders();
    }
}

