/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.illidan.services.hsf;

import com.taobao.hsf.app.api.util.HSFApiConsumerBean;
import com.taobao.illidan.common.utils.StringUtil;
import com.taobao.illidan.common.utils.cache.Cache;
import com.taobao.illidan.common.utils.cache.ICacheLoader;
import com.taobao.illidan.services.core.Invokable;
import com.taobao.illidan.services.core.Record;
import com.taobao.illidan.services.hsf.HSFMetadata;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;

public class HSFInvokable
implements Invokable {
    private static Cache<String, HSFApiConsumerBean> consumerBeans = new Cache((ICacheLoader)new HSFApiConsumerBeanCacheLoader());
    private static Cache<Cache.CombinedKey, Method> targetMethods = new Cache((ICacheLoader)new TargetMethodCacheLoader());
    private Record record;

    HSFInvokable(Record record) {
        this.record = record;
    }

    public Object call(String location, Object ... args) throws Exception {
        HSFApiConsumerBean consumerBean = this.findHsfConsumerBean();
        String[] parameterTypes = this.record.getLocations().getLocation(location);
        return this.invoke(consumerBean, location, parameterTypes, args);
    }

    public Object getServiceObject() {
        HSFApiConsumerBean consumerBean = this.findHsfConsumerBean();
        if (consumerBean != null) {
            try {
                return consumerBean.getObject();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private HSFApiConsumerBean findHsfConsumerBean() {
        String interfaceName = HSFInvokable.getInterfaceName(this.record);
        String version = HSFInvokable.getVersion(this.record);
        HSFMetadata metadata = (HSFMetadata)this.record.getMetadata("hsf");
        String group = metadata.getGroup();
        HSFApiConsumerBean consumerBean = null;
        try {
            consumerBean = (HSFApiConsumerBean)consumerBeans.get((Object)interfaceName, new Object[]{version, group});
            if (null == consumerBean) {
                throw new IllegalArgumentException("could not get invoker by arguments: interfaceName is " + interfaceName + ", version is " + version + ", group is " + group);
            }
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("get invoker failed: interfaceName is " + interfaceName + ", version is " + version + ", group is " + group, e);
        }
        return consumerBean;
    }

    private static String getInterfaceName(Record record) {
        String serviceName = record.getName();
        String[] split = StringUtil.split((String)serviceName, (char)':');
        return split[0];
    }

    private static String getVersion(Record record) {
        String serviceName = record.getName();
        String[] split = StringUtil.split((String)serviceName, (char)':');
        return split[1];
    }

    private Object invoke(HSFApiConsumerBean consumerBean, String methodName, String[] parameterTypes, Object ... args) throws Exception {
        Object targetObject = consumerBean.getObject();
        Method method = (Method)targetMethods.get((Object)new Cache.CombinedKey((Object)HSFInvokable.getInterfaceName(this.record), (Object)methodName, (Object)parameterTypes), new Object[0]);
        return method.invoke(targetObject, args);
    }

    private static Class<?> getClassFromString(String classString) throws ClassNotFoundException {
        if ("byte".equals(classString)) {
            return Byte.TYPE;
        }
        if ("int".equals(classString)) {
            return Integer.TYPE;
        }
        if ("long".equals(classString)) {
            return Long.TYPE;
        }
        if ("double".equals(classString)) {
            return Double.TYPE;
        }
        if ("float".equals(classString)) {
            return Float.TYPE;
        }
        if ("short".equals(classString)) {
            return Short.TYPE;
        }
        if ("boolean".equals(classString)) {
            return Boolean.TYPE;
        }
        return Class.forName(classString);
    }

    private static class TargetMethodCacheLoader
    implements ICacheLoader<Cache.CombinedKey, Method> {
        private TargetMethodCacheLoader() {
        }

        public Method loadObject(Cache.CombinedKey key, Object ... context) {
            String interfaceName = String.valueOf(key.get(0));
            String methodName = String.valueOf(key.get(1));
            String[] parameterTypes = (String[])key.get(2);
            try {
                Class[] parameterTypeClasses = null;
                if (null != parameterTypes) {
                    parameterTypeClasses = new Class[parameterTypes.length];
                    for (int i = 0; i < parameterTypes.length; ++i) {
                        parameterTypeClasses[i] = HSFInvokable.getClassFromString(parameterTypes[i]);
                    }
                }
                return Class.forName(interfaceName).getMethod(methodName, parameterTypeClasses);
            }
            catch (Exception e) {
                throw new IllegalStateException("load object failed: key is " + key + ", context is " + Arrays.toString(context), e);
            }
        }
    }

    private static class HSFApiConsumerBeanCacheLoader
    implements ICacheLoader<String, HSFApiConsumerBean> {
        private HSFApiConsumerBeanCacheLoader() {
        }

        public HSFApiConsumerBean loadObject(String interfaceName, Object ... context) {
            HSFApiConsumerBean consumerBean = new HSFApiConsumerBean();
            consumerBean.setInterfaceName(interfaceName);
            consumerBean.setVersion(String.valueOf(context[0]));
            consumerBean.setGroup(String.valueOf(context[1]));
            try {
                consumerBean.init(true);
            }
            catch (Exception e) {
                throw new IllegalStateException("load object failed: interfaceName is " + interfaceName + ", context is " + Arrays.toString(context), e);
            }
            return consumerBean;
        }
    }
}

