/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.illidan.services.core.local;

import com.taobao.illidan.services.core.ServiceAcceptor;
import java.util.Collections;
import java.util.List;

public class ServiceClassInfoAcceptor
implements ServiceAcceptor {
    private final List<String> packageNames;
    private final List<Class<?>> classes;

    public ServiceClassInfoAcceptor(List<String> packageNames, List<Class<?>> classes) {
        this.packageNames = null == packageNames ? Collections.emptyList() : packageNames;
        this.classes = null == classes ? Collections.emptyList() : classes;
    }

    @Override
    public boolean accept(Object obj) {
        if (this.acceptAll()) {
            return true;
        }
        Class<?> t = obj.getClass();
        for (Class<?> clazz : this.classes) {
            Object annotation;
            if (clazz.isAnnotation() && null != (annotation = obj.getClass().getAnnotation(clazz))) {
                return true;
            }
            if (!clazz.isAssignableFrom(t)) continue;
            return true;
        }
        Package tPackage = t.getPackage();
        if (null != tPackage) {
            String dstPackageName = tPackage.getName();
            for (String packageName : this.packageNames) {
                if (!dstPackageName.startsWith(packageName)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean acceptAll() {
        return this.classes.isEmpty() && this.packageNames.isEmpty();
    }
}

