/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.illidan.services.core.local;

import com.taobao.illidan.common.utils.Objects;
import com.taobao.illidan.services.core.Record;
import com.taobao.illidan.services.core.local.ClassPath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LocalServiceRegistry {
    private Set<Object> services = new HashSet<Object>();
    private Map<Record, Object> records = new HashMap<Record, Object>();
    private static LocalServiceRegistry instance = new LocalServiceRegistry();

    private LocalServiceRegistry() {
    }

    public static LocalServiceRegistry getInstance() {
        return instance;
    }

    public LocalServiceRegistry classes(Class<?> ... classes) {
        Objects.requireNonNull(classes, (String)"objects should not be null.");
        ArrayList<Object> objs = new ArrayList<Object>();
        for (Class<?> clazz : classes) {
            if (clazz.isInterface() || clazz.isEnum()) continue;
            try {
                Object obj = clazz.newInstance();
                objs.add(obj);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("could not create instance for class " + clazz, e);
            }
        }
        this.objects(objs);
        return this;
    }

    public LocalServiceRegistry objects(Object ... objs) {
        Objects.requireNonNull((Object)objs, (String)"objects should not be null.");
        return this.objects(Arrays.asList(objs));
    }

    public LocalServiceRegistry packages(String ... packages) {
        Objects.requireNonNull((Object)packages, (String)"packages should not be null.");
        List<Class<?>> classes = this.findClass(packages);
        return this.classes(classes.toArray(new Class[classes.size()]));
    }

    private List<Class<?>> findClass(String[] packages) {
        LinkedList classes = new LinkedList();
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Set<ClassPath.ClassInfo> classInfos = ClassPath.from(loader).getTopLevelClasses();
            block3: for (ClassPath.ClassInfo classInfo : classInfos) {
                for (String packageName : packages) {
                    if (!classInfo.getPackageName().equals(packageName)) continue;
                    classes.add(loader.loadClass(classInfo.getName()));
                    continue block3;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return classes;
    }

    private LocalServiceRegistry objects(List<Object> objs) {
        this.services.addAll(objs);
        return this;
    }

    public Set<Object> services() {
        return this.services;
    }

    public Object find(Record record) {
        return this.records.get(record);
    }

    public LocalServiceRegistry register(Record record, Object service) {
        if (this.services.contains(service)) {
            this.records.put(record, service);
        }
        return this;
    }

    public void refresh() {
        this.records.clear();
        this.services.clear();
    }
}

