/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.illidan.services.core.local;

import com.taobao.illidan.common.utils.identify.Identifiable;
import com.taobao.illidan.services.core.Metadata;
import com.taobao.illidan.services.core.impl.AbstractServiceInfoExtractor;
import com.taobao.illidan.services.core.local.LocalMetadata;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;

@Identifiable(value="local")
public class LocalServiceInfoExtractor
extends AbstractServiceInfoExtractor {
    @Override
    protected Collection getLocationObjects(Object service) {
        Method[] methods = service.getClass().getMethods();
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method method : methods) {
            if (method.getDeclaringClass().equals(Object.class)) continue;
            result.add(method);
        }
        return result;
    }

    @Override
    protected String getServiceName(Object service) {
        return service.getClass().getName();
    }

    @Override
    protected String getServiceType(Object service) {
        return "local";
    }

    @Override
    protected Class getServiceClass(Object service) {
        return service.getClass();
    }

    @Override
    protected Metadata createMetadata() {
        return new LocalMetadata();
    }
}

