/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.illidan.services.core.local;

import com.taobao.illidan.common.utils.identify.Identifiable;
import com.taobao.illidan.common.utils.identify.Identifier;
import com.taobao.illidan.core.Future;
import com.taobao.illidan.services.core.Record;
import com.taobao.illidan.services.core.ServiceAcceptor;
import com.taobao.illidan.services.core.ServiceAcceptorAware;
import com.taobao.illidan.services.core.ServiceAdditionInfoInjector;
import com.taobao.illidan.services.core.ServiceAdditionInfoInjectorAware;
import com.taobao.illidan.services.core.ServiceImporter;
import com.taobao.illidan.services.core.ServiceInfoExtractor;
import com.taobao.illidan.services.core.ServicePublisher;
import com.taobao.illidan.services.core.local.LocalServiceRegistry;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@Identifiable(value="local")
public class LocalServiceImporter
implements ServiceImporter,
ServiceAcceptorAware,
ServiceAdditionInfoInjectorAware {
    private ServiceInfoExtractor serviceInfoExtractor = (ServiceInfoExtractor)Identifier.get((String)"local", ServiceInfoExtractor.class);
    private LocalServiceRegistry serviceRegistry = LocalServiceRegistry.getInstance();
    private Collection<ServiceAcceptor> acceptors = Collections.emptyList();
    private List<ServiceAdditionInfoInjector> infoInjectors = Collections.emptyList();

    @Override
    public void start(ServicePublisher publisher, Future<Void> future) {
        for (Object service : this.serviceRegistry.services()) {
            boolean acceptService = false;
            for (ServiceAcceptor acceptor : this.acceptors) {
                if (!acceptor.accept(service)) continue;
                acceptService = true;
                break;
            }
            if (!acceptService && !this.acceptors.isEmpty()) continue;
            Record record = this.serviceInfoExtractor.extract(service, this.infoInjectors.toArray(new ServiceAdditionInfoInjector[this.infoInjectors.size()]));
            this.serviceRegistry.register(record, service);
            publisher.publish(record);
        }
        future.complete();
    }

    @Override
    public void close() {
        this.serviceRegistry.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setServiceAdditionInfoInjectors(List<ServiceAdditionInfoInjector> serviceAdditionInfoInjectors) {
        LocalServiceImporter localServiceImporter = this;
        synchronized (localServiceImporter) {
            this.infoInjectors = serviceAdditionInfoInjectors;
        }
    }

    @Override
    public void setServiceAcceptors(Collection<ServiceAcceptor> serviceAcceptors) {
        this.acceptors = serviceAcceptors;
    }
}

