/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.illidan.services.core.local;

import com.taobao.illidan.services.core.Invokable;
import com.taobao.illidan.services.core.Record;
import com.taobao.illidan.services.core.local.LocalServiceRegistry;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class LocalInvokable
implements Invokable {
    private Object serviceObject;
    private Map<String, Method> methods = new HashMap<String, Method>();

    LocalInvokable(Record record) {
        Method[] allMethods;
        this.serviceObject = LocalServiceRegistry.getInstance().find(record);
        for (Method method : allMethods = this.serviceObject.getClass().getMethods()) {
            if (method.getDeclaringClass().equals(Object.class)) continue;
            this.methods.put(method.getName(), method);
        }
    }

    @Override
    public Object getServiceObject() {
        return this.serviceObject;
    }

    @Override
    public Object call(String location, Object ... args) throws Exception {
        Method method = this.methods.get(location);
        if (null == method) {
            throw new IllegalArgumentException("could not find appropriate method mapped to " + location + " to invoke");
        }
        try {
            return method.invoke(this.serviceObject, args);
        }
        catch (Exception e) {
            throw new InvocationTargetException(e, "fail to execute method " + method + "with the args " + (null == args ? "null" : Arrays.toString(args)));
        }
    }
}

