/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.illidan.services.core.local;

import com.taobao.illidan.common.utils.StringUtil;
import com.taobao.illidan.common.utils.logging.InternalLogger;
import com.taobao.illidan.common.utils.logging.InternalLoggerFactory;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public final class ClassPath {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ClassPath.class);
    private static final String CLASS_FILE_NAME_EXTENSION = ".class";
    private final Set<ResourceInfo> resources;

    private ClassPath(Set<ResourceInfo> resources) {
        this.resources = resources;
    }

    public static ClassPath from(ClassLoader classloader) throws IOException {
        DefaultScanner scanner = new DefaultScanner();
        scanner.scan(classloader);
        return new ClassPath(scanner.getResources());
    }

    public Set<ResourceInfo> getResources() {
        return this.resources;
    }

    public Set<ClassInfo> getAllClasses() {
        HashSet<ClassInfo> classInfos = new HashSet<ClassInfo>();
        for (ResourceInfo resource : this.resources) {
            if (!(resource instanceof ClassInfo)) continue;
            classInfos.add((ClassInfo)resource);
        }
        return classInfos;
    }

    public Set<ClassInfo> getTopLevelClasses() {
        HashSet<ClassInfo> classInfos = new HashSet<ClassInfo>();
        for (ResourceInfo resource : this.resources) {
            if (!(resource instanceof ClassInfo) || ((ClassInfo)resource).className.indexOf(36) != -1) continue;
            classInfos.add((ClassInfo)resource);
        }
        return classInfos;
    }

    public Set<ClassInfo> getTopLevelClasses(String packageName) {
        HashSet<ClassInfo> classInfos = new HashSet<ClassInfo>();
        for (ClassInfo classInfo : this.getTopLevelClasses()) {
            if (!classInfo.getPackageName().equals(packageName)) continue;
            classInfos.add(classInfo);
        }
        return classInfos;
    }

    public Set<ClassInfo> getTopLevelClassesRecursive(String packageName) {
        HashSet<ClassInfo> classInfos = new HashSet<ClassInfo>();
        String packagePrefix = packageName + '.';
        for (ClassInfo classInfo : this.getTopLevelClasses()) {
            if (!classInfo.getName().startsWith(packagePrefix)) continue;
            classInfos.add(classInfo);
        }
        return classInfos;
    }

    static String getClassName(String filename) {
        int classNameEnd = filename.length() - CLASS_FILE_NAME_EXTENSION.length();
        return filename.substring(0, classNameEnd).replace('/', '.');
    }

    static final class DefaultScanner
    extends Scanner {
        private final Map<ClassLoader, List<String>> resources = new HashMap<ClassLoader, List<String>>();

        DefaultScanner() {
        }

        Set<ResourceInfo> getResources() {
            HashSet<ResourceInfo> resourceInfos = new HashSet<ResourceInfo>();
            for (Map.Entry<ClassLoader, List<String>> entry : this.resources.entrySet()) {
                ClassLoader classLoader = entry.getKey();
                List<String> paths = entry.getValue();
                for (String path : paths) {
                    resourceInfos.add(ResourceInfo.of(path, classLoader));
                }
            }
            return resourceInfos;
        }

        @Override
        protected void scanJarFile(ClassLoader classloader, JarFile file) {
            Enumeration<JarEntry> entries = file.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (entry.isDirectory() || entry.getName().equals("META-INF/MANIFEST.MF")) continue;
                this.ensureKeyExists(classloader);
                this.resources.get(classloader).add(entry.getName());
            }
        }

        @Override
        protected void scanDirectory(ClassLoader classloader, File directory) throws IOException {
            this.scanDirectory(directory, classloader, "");
        }

        private void scanDirectory(File directory, ClassLoader classloader, String packagePrefix) throws IOException {
            File[] files = directory.listFiles();
            if (files == null) {
                logger.warn("Cannot read directory " + directory);
                return;
            }
            for (File f : files) {
                String name = f.getName();
                if (f.isDirectory()) {
                    this.scanDirectory(f, classloader, packagePrefix + name + "/");
                    continue;
                }
                String resourceName = packagePrefix + name;
                if (resourceName.equals("META-INF/MANIFEST.MF")) continue;
                this.ensureKeyExists(classloader);
                this.resources.get(classloader).add(resourceName);
            }
        }

        private void ensureKeyExists(ClassLoader classloader) {
            if (!this.resources.containsKey(classloader)) {
                this.resources.put(classloader, new ArrayList());
            }
        }
    }

    static abstract class Scanner {
        private final Set<File> scannedUris = new HashSet<File>();

        Scanner() {
        }

        public final void scan(ClassLoader classloader) throws IOException {
            for (Map.Entry<File, ClassLoader> entry : Scanner.getClassPathEntries(classloader).entrySet()) {
                this.scan(entry.getKey(), entry.getValue());
            }
        }

        protected abstract void scanDirectory(ClassLoader var1, File var2) throws IOException;

        protected abstract void scanJarFile(ClassLoader var1, JarFile var2) throws IOException;

        final void scan(File file, ClassLoader classloader) throws IOException {
            if (this.scannedUris.add(file.getCanonicalFile())) {
                this.scanFrom(file, classloader);
            }
        }

        private void scanFrom(File file, ClassLoader classloader) throws IOException {
            try {
                if (!file.exists()) {
                    return;
                }
            }
            catch (SecurityException e) {
                logger.warn("Cannot access " + file + ": " + e);
                return;
            }
            if (file.isDirectory()) {
                this.scanDirectory(classloader, file);
            } else {
                this.scanJar(file, classloader);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scanJar(File file, ClassLoader classloader) throws IOException {
            JarFile jarFile;
            try {
                jarFile = new JarFile(file);
            }
            catch (IOException e) {
                return;
            }
            try {
                for (File path : Scanner.getClassPathFromManifest(file, jarFile.getManifest())) {
                    this.scan(path, classloader);
                }
                this.scanJarFile(classloader, jarFile);
            }
            finally {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
        }

        static Set<File> getClassPathFromManifest(File jarFile, Manifest manifest) {
            if (manifest == null) {
                return Collections.emptySet();
            }
            HashSet<File> paths = new HashSet<File>();
            String classpathAttribute = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH.toString());
            if (StringUtil.isNotNullOrEmpty((String)classpathAttribute)) {
                for (String path : classpathAttribute.split(" ")) {
                    URL url;
                    try {
                        url = Scanner.getClassPathEntry(jarFile, path);
                    }
                    catch (MalformedURLException e) {
                        logger.warn("Invalid Class-Path entry: " + path);
                        continue;
                    }
                    if (!url.getProtocol().equals("file")) continue;
                    paths.add(new File(url.getFile()));
                }
            }
            return paths;
        }

        static Map<File, ClassLoader> getClassPathEntries(ClassLoader classloader) {
            LinkedHashMap<File, ClassLoader> entries = new LinkedHashMap<File, ClassLoader>();
            ClassLoader parent = classloader.getParent();
            if (parent != null) {
                entries.putAll(Scanner.getClassPathEntries(parent));
            }
            if (classloader instanceof URLClassLoader) {
                URLClassLoader urlClassLoader = (URLClassLoader)classloader;
                for (URL entry : urlClassLoader.getURLs()) {
                    File file;
                    if (!entry.getProtocol().equals("file") || entries.containsKey(file = new File(entry.getFile()))) continue;
                    entries.put(file, classloader);
                }
            }
            return entries;
        }

        static URL getClassPathEntry(File jarFile, String path) throws MalformedURLException {
            return new URL(jarFile.toURI().toURL(), path);
        }
    }

    public static final class ClassInfo
    extends ResourceInfo {
        private final String className;

        ClassInfo(String resourceName, ClassLoader loader) {
            super(resourceName, loader);
            this.className = ClassPath.getClassName(resourceName);
        }

        public String getPackageName() {
            int lastDot = this.className.lastIndexOf(46);
            return lastDot < 0 ? "" : this.className.substring(0, lastDot);
        }

        public String getSimpleName() {
            int lastDollarSign = this.className.lastIndexOf(36);
            if (lastDollarSign != -1) {
                String innerClassName = this.className.substring(lastDollarSign + 1);
                for (int first = 0; first < innerClassName.length(); ++first) {
                    char c = innerClassName.charAt(first);
                    if (c >= '0' && c <= '9') continue;
                    return innerClassName.substring(first);
                }
                return "";
            }
            String packageName = this.getPackageName();
            if (packageName.isEmpty()) {
                return this.className;
            }
            return this.className.substring(packageName.length() + 1);
        }

        public String getName() {
            return this.className;
        }

        public Class<?> load() {
            try {
                return this.loader.loadClass(this.className);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public String toString() {
            return this.className;
        }
    }

    public static class ResourceInfo {
        private final String resourceName;
        final ClassLoader loader;

        static ResourceInfo of(String resourceName, ClassLoader loader) {
            if (resourceName.endsWith(ClassPath.CLASS_FILE_NAME_EXTENSION)) {
                return new ClassInfo(resourceName, loader);
            }
            return new ResourceInfo(resourceName, loader);
        }

        ResourceInfo(String resourceName, ClassLoader loader) {
            this.resourceName = resourceName;
            this.loader = loader;
        }

        public final URL url() {
            URL url = this.loader.getResource(this.resourceName);
            if (url == null) {
                throw new NoSuchElementException(this.resourceName);
            }
            return url;
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        public int hashCode() {
            return this.resourceName.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ResourceInfo) {
                ResourceInfo that = (ResourceInfo)obj;
                return this.resourceName.equals(that.resourceName) && this.loader == that.loader;
            }
            return false;
        }

        public String toString() {
            return this.resourceName;
        }
    }
}

