/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.illidan.services.core.impl;

import com.taobao.illidan.common.utils.Objects;
import com.taobao.illidan.common.utils.json.JsonObject;
import com.taobao.illidan.core.AsyncResult;
import com.taobao.illidan.core.Future;
import com.taobao.illidan.core.Handler;
import com.taobao.illidan.services.core.Record;
import com.taobao.illidan.services.core.ServiceDiscoveryBackend;
import com.taobao.illidan.services.core.impl.AsyncMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class DefaultServiceDiscoveryBackend
implements ServiceDiscoveryBackend {
    private AsyncMap<String, Record> registry = new AsyncMap();

    @Override
    public void init(JsonObject config) {
    }

    @Override
    public void store(final Record record, final Handler<AsyncResult<Record>> resultHandler) {
        if (record.getRegistration() != null) {
            throw new IllegalArgumentException("The record has already been registered");
        }
        String uuid = UUID.randomUUID().toString();
        record.setRegistration(uuid);
        this.registry.put(uuid, record, new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.factory.succeededFuture((Object)record));
                } else {
                    resultHandler.handle((Object)Future.factory.failedFuture(ar.cause(), Record.class));
                }
            }
        });
    }

    @Override
    public void remove(Record record, Handler<AsyncResult<Record>> resultHandler) {
        Objects.requireNonNull((Object)record.getRegistration(), (String)"No registration id in the record");
        this.remove(record.getRegistration(), resultHandler);
    }

    @Override
    public void remove(final String uuid, final Handler<AsyncResult<Record>> resultHandler) {
        Objects.requireNonNull((Object)uuid, (String)"No registration id in the record");
        this.registry.remove(uuid, new Handler<AsyncResult<Record>>(){

            public void handle(AsyncResult<Record> ar) {
                if (ar.succeeded()) {
                    if (ar.result() == null) {
                        resultHandler.handle((Object)Future.factory.failedFuture("Record '" + uuid + "' not found", Record.class));
                    } else {
                        resultHandler.handle((Object)Future.factory.succeededFuture(ar.result()));
                    }
                } else {
                    resultHandler.handle((Object)Future.factory.failedFuture(ar.cause(), Record.class));
                }
            }
        });
    }

    @Override
    public void update(Record record, final Handler<AsyncResult<Void>> resultHandler) {
        Objects.requireNonNull((Object)record.getRegistration(), (String)"No registration id in the record");
        this.registry.put(record.getRegistration(), record, new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.factory.succeededFuture(Void.class));
                } else {
                    resultHandler.handle((Object)Future.factory.failedFuture(ar.cause(), Void.class));
                }
            }
        });
    }

    @Override
    public void getRecords(final Handler<AsyncResult<List<Record>>> resultHandler) {
        this.registry.getAll(new Handler<AsyncResult<Map<String, Record>>>(){

            public void handle(AsyncResult<Map<String, Record>> ar) {
                ArrayList dst = new ArrayList();
                if (ar.succeeded()) {
                    Map result = (Map)ar.result();
                    for (Map.Entry entry : result.entrySet()) {
                        dst.add(entry.getValue());
                    }
                    resultHandler.handle((Object)Future.factory.succeededFuture(dst));
                } else {
                    resultHandler.handle((Object)Future.factory.failedFuture(ar.cause(), dst));
                }
            }
        });
    }

    @Override
    public void getRecord(String uuid, final Handler<AsyncResult<Record>> resultHandler) {
        this.registry.get(uuid, new Handler<AsyncResult<Record>>(){

            public void handle(AsyncResult<Record> ar) {
                if (ar.succeeded()) {
                    if (ar.result() != null) {
                        resultHandler.handle((Object)Future.factory.succeededFuture(ar.result()));
                    } else {
                        resultHandler.handle((Object)Future.factory.succeededFuture(Record.class));
                    }
                } else {
                    resultHandler.handle((Object)Future.factory.failedFuture(ar.cause(), Record.class));
                }
            }
        });
    }
}

