/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.illidan.services.core.impl;

import com.taobao.illidan.common.utils.Objects;
import com.taobao.illidan.common.utils.json.JsonMarshallerFactory;
import com.taobao.illidan.common.utils.logging.InternalLogger;
import com.taobao.illidan.common.utils.logging.InternalLoggerFactory;
import com.taobao.illidan.core.AsyncResult;
import com.taobao.illidan.core.Function;
import com.taobao.illidan.core.Future;
import com.taobao.illidan.core.Handler;
import com.taobao.illidan.services.core.Record;
import com.taobao.illidan.services.core.Refreshable;
import com.taobao.illidan.services.core.ServiceDiscovery;
import com.taobao.illidan.services.core.ServiceDiscoveryBackend;
import com.taobao.illidan.services.core.ServiceDiscoveryOptions;
import com.taobao.illidan.services.core.ServiceExporter;
import com.taobao.illidan.services.core.ServiceImporter;
import com.taobao.illidan.services.core.ServicePublisher;
import com.taobao.illidan.services.core.ServiceReference;
import com.taobao.illidan.services.core.ServiceTypes;
import com.taobao.illidan.services.core.Status;
import com.taobao.illidan.services.core.impl.DefaultServiceDiscoveryBackend;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class DefaultServiceDiscovery
implements ServiceDiscovery,
ServicePublisher {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(DefaultServiceDiscovery.class);
    private ServiceDiscoveryBackend backend;
    private ServiceDiscoveryOptions options;
    private final Set<ServiceImporter> importers = new CopyOnWriteArraySet<ServiceImporter>();
    private final Set<ServiceExporter> exporters = new CopyOnWriteArraySet<ServiceExporter>();
    private final Set<ServiceReference> bindings = new CopyOnWriteArraySet<ServiceReference>();

    public DefaultServiceDiscovery(ServiceDiscoveryOptions options) {
        this.options = options;
        this.backend = new DefaultServiceDiscoveryBackend();
    }

    @Override
    public ServiceReference getReference(Record record) {
        Objects.requireNonNull((Object)record, (String)"record could not be null.");
        Objects.requireNonNull((Object)record.getType(), (String)"record's type could not be null.");
        ServiceReference reference = ServiceTypes.get(record.getType()).get(record);
        this.bind(reference);
        return reference;
    }

    @Override
    public ServiceDiscovery register(ServiceImporter importer) {
        return this.register(importer, (Handler<AsyncResult<Void>>)Handler.LAZY);
    }

    @Override
    public ServiceDiscovery register(final ServiceImporter importer, final Handler<AsyncResult<Void>> completionHandler) {
        Future completed = Future.factory.future();
        completed.setHandler((Handler)new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> ar) {
                if (ar.failed()) {
                    LOGGER.error("Cannot start the service importer " + importer, ar.cause());
                    if (completionHandler != null) {
                        completionHandler.handle((Object)Future.factory.failedFuture(ar.cause(), Void.class));
                    }
                } else {
                    DefaultServiceDiscovery.this.importers.add(importer);
                    LOGGER.info("Service importer " + importer + " started");
                    if (completionHandler != null) {
                        completionHandler.handle((Object)Future.factory.succeededFuture(Void.class));
                    }
                }
            }
        });
        importer.start(this, (Future<Void>)completed);
        return this;
    }

    @Override
    public ServiceDiscovery register(ServiceExporter exporter) {
        return this.register(exporter, (Handler<AsyncResult<Void>>)Handler.LAZY);
    }

    @Override
    public ServiceDiscovery register(final ServiceExporter exporter, final Handler<AsyncResult<Void>> completionHandler) {
        Future completed = Future.factory.future();
        completed.setHandler((Handler)new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> ar) {
                if (ar.failed()) {
                    LOGGER.error("Cannot start the service exporter " + exporter, ar.cause());
                    if (completionHandler != null) {
                        completionHandler.handle((Object)Future.factory.failedFuture(ar.cause(), Void.class));
                    }
                } else {
                    DefaultServiceDiscovery.this.exporters.add(exporter);
                    LOGGER.info("Service exporter " + exporter + " started");
                    if (completionHandler != null) {
                        completionHandler.handle((Object)Future.factory.succeededFuture(Void.class));
                    }
                }
            }
        });
        exporter.init(this, (Future<Void>)completed);
        return this;
    }

    @Override
    public void close() {
        LOGGER.info("Stopping service discovery");
        for (ServiceImporter importer : this.importers) {
            importer.close();
        }
        for (ServiceExporter exporter : this.exporters) {
            exporter.close();
        }
        for (ServiceReference r : this.bindings) {
            this.release(r);
        }
    }

    @Override
    public void publish(Record record, Handler<AsyncResult<Record>> resultHandler) {
        Status status = record.getStatus() != null && record.getStatus() != Status.UNKNOWN && record.getStatus() != Status.DOWN ? record.getStatus() : Status.UP;
        this.backend.store(record.setStatus(status), resultHandler);
        for (ServiceExporter exporter : this.exporters) {
            exporter.onPublish(record);
            LOGGER.info("Publish record ,exporter is {} , record is {}.", (Object)exporter, (Object)JsonMarshallerFactory.factory.getInstance().encode((Object)record));
        }
    }

    @Override
    public void unpublish(final String id, final Handler<AsyncResult<Void>> resultHandler) {
        this.backend.remove(id, new Handler<AsyncResult<Record>>(){

            public void handle(AsyncResult<Record> record) {
                if (record.failed()) {
                    resultHandler.handle((Object)Future.factory.failedFuture(record.cause(), Void.class));
                    LOGGER.error("unpublish failed.", record.cause());
                    return;
                }
                for (ServiceExporter exporter : DefaultServiceDiscovery.this.exporters) {
                    LOGGER.info("unpublish record ,exporter is {} , record is {}.", (Object)exporter, record.result());
                    exporter.onUnpublish(id);
                }
            }
        });
    }

    @Override
    public void getRecord(Function<Record, Boolean> filter, Handler<AsyncResult<Record>> resultHandler) {
        this.getRecord(filter, false, resultHandler);
    }

    @Override
    public void getRecord(final Function<Record, Boolean> filter, final boolean includeOutOfService, final Handler<AsyncResult<Record>> resultHandler) {
        this.getRecords(filter, includeOutOfService, new Handler<AsyncResult<List<Record>>>(){

            public void handle(AsyncResult<List<Record>> event) {
                if (event.failed()) {
                    resultHandler.handle((Object)Future.factory.failedFuture(event.cause(), Record.class));
                } else {
                    List records = (List)event.result();
                    for (Record r : records) {
                        if (!((Boolean)filter.apply((Object)r)).booleanValue() || !includeOutOfService && !Status.UP.equals((Object)r.getStatus())) continue;
                        resultHandler.handle((Object)Future.factory.succeededFuture((Object)r));
                        return;
                    }
                }
            }
        });
    }

    @Override
    public void getRecords(Function<Record, Boolean> filter, Handler<AsyncResult<List<Record>>> resultHandler) {
        this.getRecords(filter, false, resultHandler);
    }

    @Override
    public void getRecords(final Function<Record, Boolean> filter, final boolean includeOutOfService, final Handler<AsyncResult<List<Record>>> resultHandler) {
        Objects.requireNonNull(filter);
        this.backend.getRecords(new Handler<AsyncResult<List<Record>>>(){

            public void handle(AsyncResult<List<Record>> list) {
                if (list.failed()) {
                    resultHandler.handle((Object)Future.factory.failedFuture(list.cause(), list.result()));
                } else {
                    List result = (List)list.result();
                    ArrayList<Record> filterResult = new ArrayList<Record>();
                    for (Record r : result) {
                        if (!((Boolean)filter.apply((Object)r)).booleanValue() || !includeOutOfService && r.getStatus() != Status.UP) continue;
                        filterResult.add(r);
                    }
                    resultHandler.handle((Object)Future.factory.succeededFuture(filterResult));
                }
            }
        });
    }

    @Override
    public void update(final Record record, final Handler<AsyncResult<Record>> resultHandler) {
        this.backend.update(record, new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> ar) {
                if (ar.failed()) {
                    resultHandler.handle((Object)Future.factory.failedFuture(ar.cause(), (Object)record));
                } else {
                    resultHandler.handle((Object)Future.factory.succeededFuture((Object)record));
                }
            }
        });
        for (ServiceExporter exporter : this.exporters) {
            exporter.onUpdate(record);
        }
    }

    @Override
    public Set<ServiceReference> bindings() {
        return Collections.unmodifiableSet(this.bindings);
    }

    @Override
    public ServiceDiscoveryOptions options() {
        return this.options;
    }

    @Override
    public void release(Object serviceObject) {
        Objects.requireNonNull((Object)serviceObject);
        for (ServiceReference r : this.bindings) {
            if (!r.cached().equals(serviceObject)) continue;
            this.release(r);
        }
    }

    @Override
    public void publish(Record record) {
        this.publish(record, (Handler<AsyncResult<Record>>)Handler.LAZY);
    }

    @Override
    public void unpublish(String id) {
        this.unpublish(id, (Handler<AsyncResult<Void>>)Handler.LAZY);
    }

    private void bind(ServiceReference reference) {
        this.bindings.add(reference);
        this.sendBindEvent(reference);
    }

    public void unbind(ServiceReference reference) {
        if (this.bindings.remove(reference)) {
            this.sendUnbindEvent(reference);
        }
    }

    private void sendUnbindEvent(ServiceReference reference) {
    }

    private void sendBindEvent(ServiceReference reference) {
    }

    @Override
    public boolean release(ServiceReference reference) {
        boolean removed = this.bindings.remove(reference);
        reference.release();
        this.sendUnbindEvent(reference);
        return removed;
    }

    @Override
    public void start() {
    }

    @Override
    public void refresh() {
        for (ServiceImporter importer : this.importers) {
            if (!(importer instanceof Refreshable)) continue;
            ((Refreshable)((Object)importer)).refresh();
        }
        for (ServiceExporter exporter : this.exporters) {
            if (!(exporter instanceof Refreshable)) continue;
            ((Refreshable)((Object)exporter)).refresh();
        }
    }
}

