/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.illidan.services.core.impl;

import com.taobao.illidan.core.AsyncResult;
import com.taobao.illidan.core.Future;
import com.taobao.illidan.core.Handler;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class AsyncMap<K, V> {
    private final Map<K, V> syncMap = new ConcurrentHashMap();

    public void getAll(Handler<AsyncResult<Map<K, V>>> handler) {
        Future t = Future.factory.future();
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(this.syncMap);
        t.setHandler(handler);
        t.complete(map);
    }

    public void keySet(Handler<AsyncResult<Set<K>>> handler) {
        Future t = Future.factory.future();
        t.setHandler(handler);
        t.complete(this.syncMap.keySet());
    }

    public void values(Handler<AsyncResult<List<V>>> handler) {
        Future t = Future.factory.future();
        t.setHandler(handler);
        t.complete(new ArrayList<V>(this.syncMap.values()));
    }

    public void get(K k, Handler<AsyncResult<V>> handler) {
        Future t = Future.factory.future();
        t.setHandler(handler);
        t.complete(this.syncMap.get(k));
    }

    public void put(K k, V v, Handler<AsyncResult<Void>> handler) {
        this.syncMap.put(k, v);
        Future t = Future.factory.future();
        t.setHandler(handler);
        t.complete();
    }

    public void remove(K k, Handler<AsyncResult<V>> handler) {
        Future t = Future.factory.future();
        t.setHandler(handler);
        t.complete(this.syncMap.remove(k));
    }

    public void size(Handler<AsyncResult<Integer>> handler) {
        Future t = Future.factory.future();
        t.setHandler(handler);
        t.complete((Object)this.syncMap.size());
    }
}

