/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.illidan.services.core.impl;

import com.taobao.illidan.services.core.Locations;
import com.taobao.illidan.services.core.Metadata;
import com.taobao.illidan.services.core.Record;
import com.taobao.illidan.services.core.ServiceAdditionInfoInjector;
import com.taobao.illidan.services.core.ServiceInfoExtractor;
import com.taobao.illidan.services.core.Status;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;

public abstract class AbstractServiceInfoExtractor
implements ServiceInfoExtractor {
    @Override
    public final Record extract(Object service, ServiceAdditionInfoInjector ... infoInjectors) {
        Record record = this.extractServiceInfo(service);
        for (ServiceAdditionInfoInjector infoInjector : infoInjectors) {
            infoInjector.injectServiceInfo(record, this.getServiceClass(service));
            infoInjector.injectLocationInfo(record, this.getLocationObjects(service));
        }
        return record;
    }

    private Locations collectLocationInfo(Object serviceObject) {
        Locations locations = new Locations();
        Collection locationObjects = this.getLocationObjects(serviceObject);
        for (Object locationObject : locationObjects) {
            Method method = (Method)locationObject;
            String methodLocation = method.getName();
            Class<?>[] parameterTypes = method.getParameterTypes();
            ArrayList<String> pts = new ArrayList<String>();
            for (Class<?> clazz : parameterTypes) {
                pts.add(clazz.getName());
            }
            locations.put(methodLocation, pts.toArray(new String[pts.size()]));
        }
        return locations;
    }

    private Record extractServiceInfo(Object service) {
        return new Record().setType(this.getServiceType(service)).setStatus(this.getServiceInitStatus(service)).setName(this.getServiceName(service)).setLocations(this.collectLocationInfo(service)).setMetadata(this.getServiceType(service), this.createMetadata());
    }

    protected Status getServiceInitStatus(Object service) {
        return Status.UP;
    }

    protected abstract Metadata createMetadata();

    protected abstract Class getServiceClass(Object var1);

    protected abstract Collection getLocationObjects(Object var1);

    protected abstract String getServiceName(Object var1);

    protected abstract String getServiceType(Object var1);
}

