/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.illidan.services.core.config;

import com.taobao.illidan.common.utils.config.Configuration;
import com.taobao.illidan.common.utils.config.ConfigurationProvider;
import com.taobao.illidan.common.utils.identify.Identifiable;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

@Identifiable(value="FileConfigurationProvider")
public class FileConfigurationProvider
implements ConfigurationProvider {
    private Map<String, String> configs = new HashMap<String, String>();

    public FileConfigurationProvider() {
        String fileName = "/illidan.properties";
        URL url = Configuration.class.getResource(fileName);
        if (null != url) {
            Properties properties = this.loadFromFile(fileName);
            for (Map.Entry<Object, Object> propertyEntry : properties.entrySet()) {
                String key = String.valueOf(propertyEntry.getKey());
                if (!key.startsWith("illidan")) continue;
                this.configs.put(key, String.valueOf(propertyEntry.getValue()));
            }
        }
    }

    private Properties loadFromFile(String fileName) {
        Properties p = new Properties();
        try {
            p.load(Configuration.class.getResourceAsStream(fileName));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("could not load properties from file, file name is " + fileName, e);
        }
        return p;
    }

    public Map<String, String> getConfiguration() {
        return this.configs;
    }

    public int getPriority() {
        return 5;
    }
}

