/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.illidan.services.core;

import com.taobao.illidan.common.utils.Objects;
import com.taobao.illidan.services.core.Locations;
import com.taobao.illidan.services.core.Metadata;
import com.taobao.illidan.services.core.Status;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Record {
    public static final String ENDPOINT = "endpoint";
    private String name;
    private String type;
    private Status status = Status.UNKNOWN;
    private String registration;
    private Locations locations = new Locations();
    private Map<String, Metadata> metadatas = Collections.emptyMap();

    public Record() {
    }

    public Record(Record record) {
        this.name = record.name;
        this.type = record.type;
        this.status = record.status;
        this.registration = record.registration;
        this.locations = new Locations(record.locations);
        if (!record.metadatas.isEmpty()) {
            this.metadatas = new HashMap<String, Metadata>(record.metadatas);
        }
    }

    public Locations getLocations() {
        return this.locations;
    }

    public Record setLocations(Locations locations) {
        this.locations = locations;
        return this;
    }

    public Map<String, Metadata> getMetadatas() {
        return this.metadatas;
    }

    public Metadata getMetadata(String key) {
        return this.metadatas.get(key);
    }

    public Record setMetadata(String key, Metadata data) {
        if (this.metadatas.isEmpty()) {
            this.metadatas = new HashMap<String, Metadata>();
        }
        this.metadatas.put(key, data);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Record setName(String name) {
        this.name = name;
        return this;
    }

    public Status getStatus() {
        return this.status;
    }

    public Record setStatus(Status status) {
        Objects.requireNonNull((Object)((Object)status));
        this.status = status;
        return this;
    }

    public Record setRegistration(String reg) {
        this.registration = reg;
        return this;
    }

    public String getRegistration() {
        return this.registration;
    }

    public String getType() {
        return this.type;
    }

    public Record setType(String type) {
        this.type = type;
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.locations == null ? 0 : this.locations.hashCode());
        result = 31 * result + (this.metadatas == null ? 0 : this.metadatas.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Record other = (Record)obj;
        if (this.locations == null ? other.locations != null : !this.locations.equals(other.locations)) {
            return false;
        }
        if (this.metadatas == null ? other.metadatas != null : !this.metadatas.equals(other.metadatas)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.status != other.status) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Record [name=");
        builder.append(this.name);
        builder.append(", type=");
        builder.append(this.type);
        builder.append(", registration=");
        builder.append(this.registration);
        builder.append(", status=");
        builder.append((Object)this.status);
        builder.append(", locations=");
        builder.append(this.locations);
        builder.append(", metadata=");
        builder.append(this.metadatas);
        builder.append("]");
        return builder.toString();
    }
}

