/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.illidan.services.integration.spring;

import com.taobao.illidan.common.utils.logging.InternalLogger;
import com.taobao.illidan.common.utils.logging.InternalLoggerFactory;
import com.taobao.illidan.services.integration.IllidanStarter;
import com.taobao.illidan.services.integration.annotation.IllidanServiceEnable;
import java.util.ArrayList;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

@Component
public class IllidanBeanPostProcessor
implements ApplicationListener<ApplicationEvent>,
ApplicationContextAware {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(IllidanBeanPostProcessor.class);
    private IllidanStarter starter = null;
    private ApplicationContext applicationContext;

    public void onApplicationEvent(ApplicationEvent event) {
        if (event.getSource().equals(this.applicationContext)) {
            if (event instanceof ContextRefreshedEvent) {
                String[] beanDefinitionNames;
                if (null == this.starter) {
                    String[] beanNames;
                    ArrayList<Object> beans = new ArrayList<Object>();
                    String[] stringArray = beanNames = this.applicationContext.getBeanDefinitionNames();
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String beanName = stringArray[i];
                        Object bean = this.applicationContext.getBean(beanName);
                        IllidanServiceEnable illidanServiceEnable = (IllidanServiceEnable)AnnotationUtils.findAnnotation(bean.getClass(), IllidanServiceEnable.class);
                        if (null == illidanServiceEnable) continue;
                        beans.add(bean);
                    }
                    if (beans.isEmpty()) {
                        LOGGER.warn("Could not find bean with IllidanServiceEnable annotation.Illidan will not start.");
                        return;
                    }
                    if (beans.size() > 1) {
                        String errorMsg = "multiple @IllidanServiceEnable annotations are not allowed , componets are ." + beans;
                        LOGGER.error(errorMsg);
                        throw new IllegalStateException(errorMsg);
                    }
                    this.starter = this.createStarter(beans.get(0));
                }
                for (String beanDefinitionName : beanDefinitionNames = this.applicationContext.getBeanDefinitionNames()) {
                    this.starter.instances(this.applicationContext.getBean(beanDefinitionName));
                }
                this.starter.start();
                LOGGER.info("Illidan server has been started .");
            } else if (null != this.starter && event instanceof ContextClosedEvent) {
                this.starter.stop();
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private IllidanStarter createStarter(Object bean) {
        IllidanStarter starter = null;
        Class<?> beanClass = bean.getClass();
        LOGGER.info("found @IllidanServiceEnable annotation on {}, start to init illidan server.", bean);
        starter = IllidanStarter.createWith(beanClass);
        starter.toHttp();
        return starter;
    }
}

