/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.illidan.services.integration;

import com.taobao.illidan.common.utils.config.Configuration;
import com.taobao.illidan.common.utils.identify.Identifier;
import com.taobao.illidan.common.utils.logging.InternalLogger;
import com.taobao.illidan.common.utils.logging.InternalLoggerFactory;
import com.taobao.illidan.services.core.ServiceAcceptorAware;
import com.taobao.illidan.services.core.ServiceAdditionInfoInjector;
import com.taobao.illidan.services.core.ServiceAdditionInfoInjectorAware;
import com.taobao.illidan.services.core.ServiceDiscovery;
import com.taobao.illidan.services.core.ServiceExporter;
import com.taobao.illidan.services.core.ServiceImporter;
import com.taobao.illidan.services.core.impl.ServiceDiscoveryFactory;
import com.taobao.illidan.services.core.local.LocalServiceRegistry;
import com.taobao.illidan.services.core.local.ServiceClassInfoAcceptor;
import com.taobao.illidan.services.integration.annotation.IllidanServiceEnable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IllidanStarter {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(IllidanStarter.class);
    private List<String> packages = Collections.emptyList();
    private List<Class<?>> classes = Collections.emptyList();
    private List<String> packageFilters = Collections.emptyList();
    private List<Class<?>> classFilters = Collections.emptyList();
    private List<Object> objects = Collections.emptyList();
    private Set<String> importNames = new HashSet<String>();
    private Set<String> exporterNames = new HashSet<String>();
    private LocalServiceRegistry localRegistry = LocalServiceRegistry.getInstance();
    private ServiceDiscovery serviceDiscovery;
    private boolean started = false;

    private IllidanStarter() {
    }

    public static IllidanStarter createWith(Class<?> clazz) {
        IllidanServiceEnable annotation = clazz.getAnnotation(IllidanServiceEnable.class);
        if (annotation == null) {
            LOGGER.error("could not start illidan server since there's no @IllidanServiceEnable annotation found on class: {}", clazz);
            throw new IllegalArgumentException("could not start illidan server since there's no @IllidanServiceEnable annotation found on class: " + clazz);
        }
        return IllidanStarter.createWithFilters(annotation.packages(), annotation.classes()).toHttp();
    }

    public static IllidanStarter create() {
        return new IllidanStarter();
    }

    public static IllidanStarter createWithFilters(String[] packageFilters, Class<?>[] classFilters) {
        IllidanStarter starter = new IllidanStarter();
        starter.packageFilters = Arrays.asList(packageFilters);
        starter.classFilters = Arrays.asList(classFilters);
        return starter;
    }

    public IllidanStarter packages(String ... packages) {
        this.packages = IllidanStarter.ensureInitialized(this.packages);
        ArrayList<String> dstPackages = new ArrayList<String>();
        String[] stringArray = packages;
        int n = packages.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            if (this.containsPackage(p)) {
                dstPackages.add(p);
            }
            ++n2;
        }
        this.packages.addAll(dstPackages);
        return this;
    }

    public IllidanStarter instances(Object object) {
        this.objects = IllidanStarter.ensureInitialized(this.objects);
        if (this.acceptObject(object)) {
            LOGGER.info("add instance , instance is {}.", object);
            this.objects.add(object);
        }
        return this;
    }

    public IllidanStarter instances(Object ... objects) {
        this.objects = IllidanStarter.ensureInitialized(this.objects);
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            this.instances(obj);
            ++n2;
        }
        return this;
    }

    public IllidanStarter classes(Class<?> ... classes) {
        this.classes = IllidanStarter.ensureInitialized(this.classes);
        ArrayList dstClasses = new ArrayList();
        Class<?>[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz = classArray[n2];
            if (this.filteByClass(clazz)) {
                dstClasses.add(clazz);
            }
            ++n2;
        }
        this.classes.addAll(dstClasses);
        return this;
    }

    public IllidanStarter option(String key, String value) {
        Configuration.getInstance().config(key, value);
        return this;
    }

    public IllidanStarter fromPojo() {
        this.importNames.add("local");
        return this;
    }

    public IllidanStarter fromHsf() {
        this.importNames.add("hsf");
        return this;
    }

    public IllidanStarter from(String ... imports) {
        this.importNames.addAll(Arrays.asList(imports));
        return this;
    }

    public IllidanStarter toHttp() {
        this.exporterNames.add("http");
        return this;
    }

    public IllidanStarter to(String ... exports) {
        this.exporterNames.addAll(Arrays.asList(exports));
        return this;
    }

    public synchronized void start() {
        if (this.started) {
            return;
        }
        LOGGER.info("Begin to start Illidan.");
        try {
            this.localRegistry.objects(this.objects.toArray());
            this.objects = null;
            this.localRegistry.classes(this.classes.toArray(new Class[this.classes.size()]));
            this.classes = null;
            this.localRegistry.packages(this.packages.toArray(new String[this.packages.size()]));
            this.packages = null;
            LOGGER.info("LocalRegistry Objects are {}.", (Object)this.localRegistry.services());
            this.serviceDiscovery = ServiceDiscoveryFactory.create();
            this.registerExports(this.serviceDiscovery);
            this.registerImports(this.serviceDiscovery);
        }
        catch (Exception e) {
            LOGGER.error("Start Illidan failed.", (Throwable)e);
            throw e;
        }
        LOGGER.info("Start Illidan Finished.");
        this.started = true;
    }

    public void stop() {
        if (this.serviceDiscovery != null) {
            LOGGER.info("Begin to stop Illidan.");
            this.serviceDiscovery.close();
            LOGGER.info("Stop Illidan Finished.");
        }
    }

    private boolean acceptObject(Object obj) {
        return obj != null && this.filteByClass(obj.getClass());
    }

    private boolean filteByClass(Class<?> clazz) {
        if (this.classFilters.isEmpty() && this.packageFilters.isEmpty()) {
            return true;
        }
        return !this.classFilters.isEmpty() && this.classFilters.contains(clazz) || this.containsPackage(clazz.getPackage().getName());
    }

    private boolean containsPackage(String packageName) {
        if (this.packageFilters.isEmpty()) {
            return true;
        }
        for (String filter : this.packageFilters) {
            if (!packageName.contains(filter)) continue;
            return true;
        }
        return false;
    }

    private void registerImports(ServiceDiscovery serviceDiscovery) {
        String[] importers;
        String[] stringArray;
        if (this.importNames.isEmpty()) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "hsf";
            stringArray = stringArray2;
            stringArray2[1] = "local";
        } else {
            stringArray = this.importNames.toArray(new String[this.importNames.size()]);
        }
        String[] stringArray3 = importers = stringArray;
        int n = importers.length;
        int n2 = 0;
        while (n2 < n) {
            String importerInfo = stringArray3[n2];
            ServiceImporter importer = (ServiceImporter)Identifier.get((String)importerInfo, ServiceImporter.class);
            if (importer == null) {
                LOGGER.warn("could not find importer with name {}.", (Object)importerInfo);
            } else {
                LOGGER.info("begin to register importer {}.", (Object)importer);
                this.injectAdditionalInfoIfNecessary(importer);
                this.injectServiceAcceptorIfNecessary(importer);
                serviceDiscovery.register(importer, null);
            }
            ++n2;
        }
    }

    private void injectServiceAcceptorIfNecessary(ServiceImporter importer) {
        if (importer instanceof ServiceAcceptorAware) {
            ArrayList<ServiceClassInfoAcceptor> serviceAcceptors = new ArrayList<ServiceClassInfoAcceptor>();
            serviceAcceptors.add(new ServiceClassInfoAcceptor(this.packageFilters, this.classFilters));
            LOGGER.info("set serviceAcceptors {} to importer {}.", serviceAcceptors, (Object)importer);
            ((ServiceAcceptorAware)importer).setServiceAcceptors(serviceAcceptors);
        }
    }

    private void injectAdditionalInfoIfNecessary(ServiceImporter importer) {
        if (importer instanceof ServiceAdditionInfoInjectorAware) {
            List<ServiceAdditionInfoInjector> infoInjectors = this.getInfoInjectors(this.exporterNames);
            LOGGER.info("set serviceAdditionInfoInjectors {} to importer {}.", (Object)importer, infoInjectors);
            ((ServiceAdditionInfoInjectorAware)importer).setServiceAdditionInfoInjectors(infoInjectors);
        }
    }

    private List<ServiceAdditionInfoInjector> getInfoInjectors(Set<String> exporterNames) {
        Map infoInjectors = Identifier.get(ServiceAdditionInfoInjector.class);
        ArrayList<ServiceAdditionInfoInjector> result = new ArrayList<ServiceAdditionInfoInjector>();
        for (String exportName : exporterNames) {
            String injectorName = this.injectorName(exportName);
            if (infoInjectors.containsKey(injectorName)) {
                result.add((ServiceAdditionInfoInjector)infoInjectors.get(injectorName));
                continue;
            }
            LOGGER.error("could not find injector {}", (Object)injectorName);
            throw new IllegalArgumentException("could not find injector " + injectorName);
        }
        return result;
    }

    private String injectorName(String exporterName) {
        String injectName = Configuration.getConfig((String)("illidan." + exporterName + ".injector"));
        return String.valueOf(exporterName) + ":" + injectName;
    }

    private void registerExports(ServiceDiscovery serviceDiscovery) {
        for (String exporterName : this.exporterNames) {
            ServiceExporter exporter = (ServiceExporter)Identifier.get((String)exporterName, ServiceExporter.class);
            if (exporter == null) {
                LOGGER.error("could not find exporter {}", (Object)exporterName);
                throw new IllegalArgumentException("could not find exporter " + exporterName);
            }
            LOGGER.info("register service exporter {}", (Object)exporter);
            serviceDiscovery.register(exporter);
        }
    }

    private static <T> List<T> ensureInitialized(List<T> list) {
        return list == null || list.isEmpty() ? new ArrayList() : list;
    }
}

