/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.illidan.core;

import com.taobao.illidan.core.AbstractFuture;
import com.taobao.illidan.core.AsyncResult;
import com.taobao.illidan.core.Future;
import com.taobao.illidan.core.Handler;

class FutureImpl<T>
extends AbstractFuture<T>
implements Future<T>,
Handler<AsyncResult<T>> {
    private boolean failed;
    private boolean succeeded;
    private Handler<AsyncResult<T>> handler;
    private T result;
    private Throwable throwable;

    FutureImpl() {
    }

    FutureImpl(Throwable t) {
        this.fail(t != null ? t : new RuntimeException());
    }

    FutureImpl(String failureMessage) {
        this(new RuntimeException(failureMessage));
    }

    FutureImpl(T result) {
        this.complete(result);
    }

    @Override
    public T result() {
        return this.result;
    }

    @Override
    public Throwable cause() {
        return this.throwable;
    }

    @Override
    public boolean succeeded() {
        return this.succeeded;
    }

    @Override
    public boolean failed() {
        return this.failed;
    }

    @Override
    public boolean isComplete() {
        return this.failed || this.succeeded;
    }

    @Override
    public Future<T> setHandler(Handler<AsyncResult<T>> handler) {
        this.handler = handler;
        this.checkCallHandler();
        return this;
    }

    @Override
    public void complete(T result) {
        this.checkComplete();
        this.result = result;
        this.succeeded = true;
        this.checkCallHandler();
    }

    @Override
    public void complete() {
        this.complete(null);
    }

    @Override
    public Handler<AsyncResult<T>> completer() {
        return this;
    }

    @Override
    public void handle(AsyncResult<T> ar) {
        if (ar.succeeded()) {
            this.complete(ar.result());
        } else {
            this.fail(ar.cause());
        }
    }

    @Override
    public void fail(Throwable throwable) {
        this.checkComplete();
        this.throwable = throwable != null ? throwable : new RuntimeException();
        this.failed = true;
        this.checkCallHandler();
    }

    @Override
    public void fail(String failureMessage) {
        this.fail(new RuntimeException(failureMessage));
    }

    private void checkCallHandler() {
        if (this.handler != null && this.isComplete()) {
            this.handler.handle(this);
        }
    }

    private void checkComplete() {
        if (this.succeeded || this.failed) {
            throw new IllegalStateException("Result is already complete: " + (this.succeeded ? "succeeded" : "failed"));
        }
    }
}

