/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.illidan.core;

import com.taobao.illidan.core.AsyncResult;
import com.taobao.illidan.core.Function;
import com.taobao.illidan.core.Future;
import com.taobao.illidan.core.Handler;

public abstract class AbstractFuture<T>
implements Future<T> {
    @Override
    public <U> Future<U> compose(final Handler<T> handler, final Future<U> next) {
        this.setHandler(new Handler<AsyncResult<T>>(){

            @Override
            public void handle(AsyncResult<T> ar) {
                if (ar.succeeded()) {
                    try {
                        handler.handle(ar.result());
                    }
                    catch (Throwable err) {
                        if (next.isComplete()) {
                            throw new RuntimeException(err);
                        }
                        next.fail(err);
                    }
                } else {
                    next.fail(ar.cause());
                }
            }
        });
        return next;
    }

    @Override
    public <U> Future<U> compose(final Function<T, Future<U>> mapper) {
        final Future ret = Future.factory.future();
        this.setHandler(new Handler<AsyncResult<T>>(){

            @Override
            public void handle(AsyncResult<T> ar) {
                if (ar.succeeded()) {
                    Future apply;
                    try {
                        apply = (Future)mapper.apply(ar.result());
                    }
                    catch (Throwable e) {
                        ret.fail(e);
                        return;
                    }
                    apply.setHandler(ret.completer());
                } else {
                    ret.fail(ar.cause());
                }
            }
        });
        return ret;
    }

    @Override
    public <U> Future<U> map(final Function<T, U> mapper) {
        final Future ret = Future.factory.future();
        this.setHandler(new Handler<AsyncResult<T>>(){

            @Override
            public void handle(AsyncResult<T> ar) {
                if (ar.succeeded()) {
                    Object mapped;
                    try {
                        mapped = mapper.apply(ar.result());
                    }
                    catch (Throwable e) {
                        ret.fail(e);
                        return;
                    }
                    ret.complete(mapped);
                } else {
                    ret.fail(ar.cause());
                }
            }
        });
        return ret;
    }

    @Override
    public Handler<AsyncResult<T>> completer() {
        return new Handler<AsyncResult<T>>(){

            @Override
            public void handle(AsyncResult<T> event) {
                if (event.succeeded()) {
                    AbstractFuture.this.complete(event.result());
                } else {
                    AbstractFuture.this.fail(event.cause());
                }
            }
        };
    }
}

