/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.diamond.client.impl;

import com.alibaba.middleware.tls.util.TlsUtil;
import com.taobao.diamond.client.impl.DiamondEnv;
import com.taobao.diamond.client.impl.HttpSimpleClient;
import com.taobao.diamond.client.impl.ServerListManager;
import com.taobao.diamond.utils.AppNameUtils;
import com.taobao.diamond.utils.StringUtils;
import com.taobao.middleware.logger.support.LoggerHelper;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.Iterator;
import java.util.List;

public class ServerHttpAgent {
    public static final String appKey = System.getProperty("diamond.client.appKey", "");
    public static final String appName = AppNameUtils.getAppName();
    public static String domainName;
    public static String addressPort;
    final ServerListManager serverListMgr;
    volatile String currentServerIp;

    static {
        String envDomainName = System.getenv("address_server_domain");
        domainName = StringUtils.isBlank((String)envDomainName) ? System.getProperty("address.server.domain", "jmenv.tbsite.net") : envDomainName;
        String envAddressPort = System.getenv("address_server_port");
        addressPort = StringUtils.isBlank((String)envAddressPort) ? System.getProperty("address.server.port", "8080") : envAddressPort;
        DiamondEnv.log.info("settings", "address-server domain:{} ,address-server port:{}", new Object[]{domainName, addressPort});
    }

    ServerHttpAgent(ServerListManager mgr) {
        this.serverListMgr = mgr;
    }

    public static void setDomainName(String domainName) {
        if (StringUtils.isNotEmpty((String)domainName)) {
            ServerHttpAgent.domainName = domainName;
            DiamondEnv.log.info("setDomainName", "address-server domain:{} ,address-server port:{}", new Object[]{domainName, addressPort});
        }
    }

    public HttpSimpleClient.HttpResult httpGet(String path, List<String> headers, List<String> paramValues, String encoding, long readTimeoutMs) throws IOException {
        boolean isSSL;
        String port;
        long endTime;
        block15: {
            endTime = System.currentTimeMillis() + readTimeoutMs;
            port = "8080";
            isSSL = false;
            if (TlsUtil.tlsEnable()) {
                port = "443";
                isSSL = true;
            }
            if (this.currentServerIp != null) {
                try {
                    port = this.serverListMgr.getPortByIp(this.currentServerIp);
                    HttpSimpleClient.HttpResult result = HttpSimpleClient.httpGet(ServerHttpAgent.getUrl(this.currentServerIp, port, path, isSSL), headers, paramValues, encoding, readTimeoutMs, isSSL);
                    if (result.code == 500 || result.code == 502 || result.code == 503) {
                        DiamondEnv.log.error("Diamond ConnectException", "currentServerIp:{},port:{}. httpCode:", new Object[]{this.currentServerIp, port, result.code});
                        break block15;
                    }
                    return result;
                }
                catch (ConnectException ce) {
                    DiamondEnv.log.error("Diamond ConnectException", "currentServerIp:{},port:{}", new Object[]{this.currentServerIp, port});
                }
                catch (SocketTimeoutException stoe) {
                    DiamondEnv.log.error("Diamond  SocketTimeoutException", "currentServerIp:{},port:{}", new Object[]{this.currentServerIp, port});
                }
                catch (IOException ioe) {
                    DiamondEnv.log.error("Diamond  IOException", "currentServerIp:{},port:{}", new Object[]{this.currentServerIp, port});
                    throw ioe;
                }
            }
        }
        Iterator<String> serverIter = this.serverListMgr.iterator();
        while (serverIter.hasNext()) {
            long timeout = endTime - System.currentTimeMillis();
            if (timeout <= 0L) {
                if (this.currentServerIp != null) {
                    DiamondEnv.log.error("the currentServerIp  which happened IOException in get(timeout) is: ", this.currentServerIp);
                }
                this.currentServerIp = serverIter.next();
                throw new IOException("timeout");
            }
            String ip = serverIter.next();
            try {
                port = this.serverListMgr.getPortByIp(ip);
                HttpSimpleClient.HttpResult result = HttpSimpleClient.httpGet(ServerHttpAgent.getUrl(ip, port, path, isSSL), headers, paramValues, encoding, timeout, isSSL);
                if (result.code == 500 || result.code == 502 || result.code == 503) {
                    DiamondEnv.log.error("Diamond ConnectException", "currentServerIp:{},port:{}. httpCode:", new Object[]{this.currentServerIp, port, result.code});
                    continue;
                }
                this.currentServerIp = ip;
                return result;
            }
            catch (ConnectException ce) {
                DiamondEnv.log.error("Diamond ConnectException", "currentServerIp:{},port:{}", new Object[]{this.currentServerIp, port});
            }
            catch (SocketTimeoutException stoe) {
                DiamondEnv.log.error("Diamond  SocketTimeoutException", "currentServerIp:{},port:{}", new Object[]{this.currentServerIp, port});
            }
            catch (IOException ioe) {
                DiamondEnv.log.error("Diamond  IOException", "currentServerIp:{},port:{}", new Object[]{this.currentServerIp, port});
                throw ioe;
            }
        }
        DiamondEnv.log.error("Diamond-0002", LoggerHelper.getErrorCodeStr((String)"Diamond", (String)"Diamond-0002", (String)"\u73af\u5883\u95ee\u9898", (String)"no available server"));
        throw new ConnectException("no available server");
    }

    public HttpSimpleClient.HttpResult httpPost(String path, List<String> headers, List<String> paramValues, String encoding, long readTimeoutMs) throws IOException {
        boolean isSSL;
        String port;
        long endTime;
        block15: {
            endTime = System.currentTimeMillis() + readTimeoutMs;
            port = "8080";
            isSSL = false;
            if (TlsUtil.tlsEnable()) {
                port = "443";
                isSSL = true;
            }
            if (this.currentServerIp != null) {
                try {
                    port = this.serverListMgr.getPortByIp(this.currentServerIp);
                    HttpSimpleClient.HttpResult result = HttpSimpleClient.httpPost(ServerHttpAgent.getUrl(this.currentServerIp, port, path, isSSL), headers, paramValues, encoding, readTimeoutMs, isSSL);
                    if (result.code == 500 || result.code == 502 || result.code == 503) {
                        DiamondEnv.log.error("Diamond ConnectException", "currentServerIp:{},port:{}. httpCode:", new Object[]{this.currentServerIp, port, result.code});
                        break block15;
                    }
                    return result;
                }
                catch (ConnectException ce) {
                    DiamondEnv.log.error("Diamond ConnectException", "currentServerIp:{},port:{}", new Object[]{this.currentServerIp, port});
                }
                catch (SocketTimeoutException stoe) {
                    DiamondEnv.log.error("Diamond  SocketTimeoutException", "currentServerIp:{},port:{}", new Object[]{this.currentServerIp, port});
                }
                catch (IOException ioe) {
                    DiamondEnv.log.error("Diamond  IOException", "currentServerIp:{},port:{}", new Object[]{this.currentServerIp, port});
                    throw ioe;
                }
            }
        }
        Iterator<String> serverIter = this.serverListMgr.iterator();
        while (serverIter.hasNext()) {
            long timeout = endTime - System.currentTimeMillis();
            if (timeout <= 0L) {
                if (this.currentServerIp != null) {
                    DiamondEnv.log.error("the currentServerIp  which happened IOException(timeout) in post is: ", this.currentServerIp);
                }
                this.currentServerIp = serverIter.next();
                throw new IOException("timeout");
            }
            String ip = serverIter.next();
            try {
                port = this.serverListMgr.getPortByIp(ip);
                HttpSimpleClient.HttpResult result = HttpSimpleClient.httpPost(ServerHttpAgent.getUrl(ip, port, path, isSSL), headers, paramValues, encoding, timeout, isSSL);
                if (result.code == 500 || result.code == 502 || result.code == 503) {
                    DiamondEnv.log.error("Diamond ConnectException", "currentServerIp:{},port:{}. httpCode:", new Object[]{this.currentServerIp, port, result.code});
                    continue;
                }
                this.currentServerIp = ip;
                return result;
            }
            catch (ConnectException ce) {
                DiamondEnv.log.error("Diamond ConnectException", "currentServerIp:{},port:{}", new Object[]{this.currentServerIp, port});
            }
            catch (SocketTimeoutException stoe) {
                DiamondEnv.log.error("Diamond  SocketTimeoutException", "currentServerIp:{},port:{}", new Object[]{this.currentServerIp, port});
            }
            catch (IOException ioe) {
                DiamondEnv.log.error("Diamond  IOException", "currentServerIp:{},port:{}", new Object[]{this.currentServerIp, port});
                throw ioe;
            }
        }
        DiamondEnv.log.error("Diamond-0002", LoggerHelper.getErrorCodeStr((String)"Diamond", (String)"Diamond-0002", (String)"\u73af\u5883\u95ee\u9898", (String)"no available server"));
        throw new ConnectException("no available server");
    }

    static String getUrl(String ip, String port, String relativePath, boolean isSSL) {
        String httpPrefix = "http://";
        if (isSSL) {
            httpPrefix = "https://";
        }
        return String.valueOf(httpPrefix) + ip + ":" + port + "/diamond-server" + relativePath;
    }

    static String getUrl(String ip, String port, String relativePath) {
        return ServerHttpAgent.getUrl(ip, port, relativePath, false);
    }

    public void reSetCurrentServerIp() {
        if (this.currentServerIp != null) {
            this.currentServerIp = null;
        }
    }

    public String getCurrentServerIp() {
        return this.currentServerIp;
    }

    public static String getAppname() {
        return appName;
    }
}

