/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.diamond.client.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.RateLimiter;
import com.taobao.diamond.client.impl.LogUtils;
import com.taobao.middleware.logger.Logger;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public class Limiter {
    public static final Logger log = LogUtils.logger(Limiter.class);
    private static Cache<String, RateLimiter> cache = CacheBuilder.newBuilder().initialCapacity(1000).expireAfterAccess(1L, TimeUnit.MINUTES).build();
    private static final String DEFAULT_LIMIT = "5";
    private static double limit = 5.0;

    static {
        try {
            String limitTimeStr = System.getProperty("limitTime", DEFAULT_LIMIT);
            limit = Double.parseDouble(limitTimeStr);
            log.info("limitTime:{}", new Object[]{limit});
        }
        catch (Exception e) {
            log.error("Diamond-xxx", "init limitTime fail", (Throwable)e);
        }
    }

    public static boolean isLimit(String access_key_id) {
        RateLimiter rateLimiter = null;
        try {
            rateLimiter = (RateLimiter)cache.get((Object)access_key_id, (Callable)new Callable<RateLimiter>(){

                @Override
                public RateLimiter call() throws Exception {
                    return RateLimiter.create((double)limit);
                }
            });
        }
        catch (ExecutionException e) {
            log.error("Diamond-XXX", "create limit fail", (Throwable)e);
        }
        if (!rateLimiter.tryAcquire(1000L, TimeUnit.MILLISECONDS)) {
            log.error("Diamond-XXX", "access_key_id:{} limited", access_key_id);
            return true;
        }
        return false;
    }
}

