/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.diamond.client.impl;

import com.alibaba.metrics.Timer;
import com.alibaba.middleware.tls.JavaSSLSocketFactory;
import com.alibaba.middleware.tls.util.TlsUtil;
import com.taobao.diamond.client.impl.DiamondEnv;
import com.taobao.diamond.client.impl.IOUtils;
import com.taobao.diamond.client.impl.Limiter;
import com.taobao.diamond.client.impl.ServerHttpAgent;
import com.taobao.diamond.client.impl.SpasAdapter;
import com.taobao.diamond.maintenance.DiamondMetric;
import com.taobao.diamond.md5.MD5;
import com.taobao.diamond.utils.EnvUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public class HttpSimpleClient {
    static String DIAMOND_CLIENT_VERSION = "unknown";
    static final int DIAMOND_CONNECT_TIMEOUT;

    static {
        String tmp = "1000";
        try {
            tmp = System.getProperty("DIAMOND.CONNECT.TIMEOUT", "1000");
            DIAMOND_CONNECT_TIMEOUT = Integer.parseInt(tmp);
        }
        catch (NumberFormatException e) {
            String msg = "[http-client] invalid connect timeout:" + tmp;
            DiamondEnv.log.error("settings", "DIAMOND-XXXX", msg, (Throwable)e);
            throw new IllegalArgumentException(msg, e);
        }
        DiamondEnv.log.info("settings", "[http-client] connect timeout:{}", new Object[]{DIAMOND_CONNECT_TIMEOUT});
        try {
            InputStream in = HttpSimpleClient.class.getClassLoader().getResourceAsStream("application.properties");
            Properties props = new Properties();
            props.load(in);
            String val = null;
            val = props.getProperty("version");
            if (val != null) {
                DIAMOND_CLIENT_VERSION = val;
            }
            DiamondEnv.log.info("DIAMOND_CLIENT_VERSION:{}", DIAMOND_CLIENT_VERSION);
        }
        catch (Exception e) {
            DiamondEnv.log.error("500", "read application.properties", (Throwable)e);
        }
    }

    public static HttpResult httpGet(String url, List<String> headers, List<String> paramValues, String encoding, long readTimeoutMs, boolean isSSL) throws IOException {
        String encodedContent = HttpSimpleClient.encodingParams(paramValues, encoding);
        url = String.valueOf(url) + (encodedContent == null ? "" : "?" + encodedContent);
        if (Limiter.isLimit(MD5.getInstance().getMD5String(url + encodedContent))) {
            return new HttpResult(-503, "More than client-side current limit threshold");
        }
        Timer.Context context = DiamondMetric.getRequestTimer().time();
        HttpURLConnection conn = null;
        try {
            List<String> signHeaders;
            if (isSSL) {
                TlsUtil.replaceHostnameVerifier();
                SSLSocketFactory ssf = JavaSSLSocketFactory.createJavaSSLSocketFactory(null, null);
                HttpsURLConnection httpsConn = (HttpsURLConnection)new URL(url).openConnection();
                httpsConn.setSSLSocketFactory(ssf);
                conn = httpsConn;
            } else {
                conn = (HttpURLConnection)new URL(url).openConnection();
            }
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(DIAMOND_CONNECT_TIMEOUT > 100 ? DIAMOND_CONNECT_TIMEOUT : 100);
            conn.setReadTimeout((int)readTimeoutMs);
            ArrayList<String> newHeaders = new ArrayList<String>();
            newHeaders.add("Spas-AccessKey");
            newHeaders.add(SpasAdapter.getAk());
            if (headers != null) {
                newHeaders.addAll(headers);
            }
            if ((signHeaders = SpasAdapter.getSignHeaders(paramValues)) != null) {
                newHeaders.addAll(signHeaders);
            }
            newHeaders.add("exConfigInfo");
            newHeaders.add("true");
            HttpSimpleClient.setHeaders(conn, newHeaders, encoding);
            conn.connect();
            int respCode = conn.getResponseCode();
            String resp = null;
            resp = 200 == respCode ? IOUtils.toString(conn.getInputStream(), encoding) : IOUtils.toString(conn.getErrorStream(), encoding);
            HttpResult httpResult = new HttpResult(respCode, conn.getHeaderFields(), resp);
            return httpResult;
        }
        finally {
            context.stop();
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public static HttpResult httpGet(String url, List<String> headers, List<String> paramValues, String encoding, long readTimeoutMs) throws IOException {
        return HttpSimpleClient.httpGet(url, headers, paramValues, encoding, readTimeoutMs, false);
    }

    public static HttpResult httpPost(String url, List<String> headers, List<String> paramValues, String encoding, long readTimeoutMs, boolean isSSL) throws IOException {
        String encodedContent = HttpSimpleClient.encodingParams(paramValues, encoding);
        if (Limiter.isLimit(MD5.getInstance().getMD5String(url + encodedContent))) {
            return new HttpResult(-503, "More than client-side current limit threshold");
        }
        HttpURLConnection conn = null;
        try {
            List<String> signHeaders;
            if (isSSL) {
                TlsUtil.replaceHostnameVerifier();
                SSLSocketFactory ssf = JavaSSLSocketFactory.createJavaSSLSocketFactory(null, null);
                HttpsURLConnection httpsConn = (HttpsURLConnection)new URL(url).openConnection();
                httpsConn.setSSLSocketFactory(ssf);
                conn = httpsConn;
            } else {
                conn = (HttpURLConnection)new URL(url).openConnection();
            }
            conn.setRequestMethod("POST");
            conn.setConnectTimeout(DIAMOND_CONNECT_TIMEOUT > 3000 ? DIAMOND_CONNECT_TIMEOUT : 3000);
            conn.setReadTimeout((int)readTimeoutMs);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            ArrayList<String> newHeaders = new ArrayList<String>();
            newHeaders.add("Spas-AccessKey");
            newHeaders.add(SpasAdapter.getAk());
            if (headers != null) {
                newHeaders.addAll(headers);
            }
            if ((signHeaders = SpasAdapter.getSignHeaders(paramValues)) != null) {
                newHeaders.addAll(signHeaders);
            }
            newHeaders.add("exConfigInfo");
            newHeaders.add("true");
            HttpSimpleClient.setHeaders(conn, newHeaders, encoding);
            conn.getOutputStream().write(encodedContent.getBytes());
            int respCode = conn.getResponseCode();
            String resp = null;
            resp = 200 == respCode ? IOUtils.toString(conn.getInputStream(), encoding) : IOUtils.toString(conn.getErrorStream(), encoding);
            HttpResult httpResult = new HttpResult(respCode, conn.getHeaderFields(), resp);
            return httpResult;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public static HttpResult httpPost(String url, List<String> headers, List<String> paramValues, String encoding, long readTimeoutMs) throws IOException {
        return HttpSimpleClient.httpPost(url, headers, paramValues, encoding, readTimeoutMs, false);
    }

    private static void setHeaders(HttpURLConnection conn, List<String> headers, String encoding) {
        if (headers != null) {
            Iterator<String> iter = headers.iterator();
            while (iter.hasNext()) {
                conn.addRequestProperty(iter.next(), iter.next());
            }
        }
        conn.addRequestProperty("Client-Version", DIAMOND_CLIENT_VERSION);
        conn.addRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=" + encoding);
        String ts = String.valueOf(System.currentTimeMillis());
        String token = MD5.getInstance().getMD5String(String.valueOf(ts) + ServerHttpAgent.appKey);
        conn.addRequestProperty("Diamond-Client-AppName", ServerHttpAgent.appName);
        conn.addRequestProperty("Diamond-Client-RequestTS", ts);
        conn.addRequestProperty("Diamond-Client-RequestToken", token);
        conn.addRequestProperty("Amory-Tag", EnvUtil.getSelfAmorayTag());
        conn.addRequestProperty("Vipserver-Tag", EnvUtil.getSelfVipserverTag());
        conn.addRequestProperty("Location-Tag", EnvUtil.getSelfLocationTag());
    }

    private static String encodingParams(List<String> paramValues, String encoding) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        if (paramValues == null) {
            return null;
        }
        Iterator<String> iter = paramValues.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next()).append("=");
            sb.append(URLEncoder.encode(iter.next(), encoding));
            if (!iter.hasNext()) continue;
            sb.append("&");
        }
        return sb.toString();
    }

    public static String getDIAMOND_CLIENT_VERSION() {
        return DIAMOND_CLIENT_VERSION;
    }

    public static class HttpResult {
        public final int code;
        public final Map<String, List<String>> headers;
        public final String content;

        public HttpResult(int code, String content) {
            this.code = code;
            this.headers = null;
            this.content = content;
        }

        public HttpResult(int code, Map<String, List<String>> headers, String content) {
            this.code = code;
            this.headers = headers;
            this.content = content;
        }
    }
}

