/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.diamond.client.impl;

import com.alibaba.metrics.Gauge;
import com.alibaba.metrics.Metric;
import com.taobao.diamond.client.impl.DiamondEnv;
import com.taobao.diamond.client.impl.ServerListManager;
import com.taobao.diamond.client.impl.ServerManager_unitSite;
import com.taobao.diamond.maintenance.DiamondMetric;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DiamondEnvRepo {
    public static final DiamondEnv defaultEnv = new DiamondEnv(new ServerListManager());
    private static final Map<String, DiamondEnv> diamondEnvs = new HashMap<String, DiamondEnv>();

    static {
        Gauge<Integer> envSizeGauge = new Gauge<Integer>(){

            public Integer getValue() {
                return diamondEnvs.size() + 1;
            }
        };
        DiamondMetric.getMetricRegistry().register("middleware.diamond.envSize", (Metric)envSizeGauge);
        Gauge<Integer> defaultEnvListenerSizeGauge = new Gauge<Integer>(){

            public Integer getValue() {
                return defaultEnv.getAllListeners().size();
            }
        };
        DiamondMetric.getMetricRegistry().register("middleware.diamond.defaultEnv.listenerSize", (Metric)defaultEnvListenerSizeGauge);
    }

    public static synchronized List<DiamondEnv> allDiamondEnvs() {
        ArrayList<DiamondEnv> envs = new ArrayList<DiamondEnv>(diamondEnvs.values());
        envs.add(defaultEnv);
        return envs;
    }

    public static synchronized DiamondEnv getTargetEnv(String host, int port) {
        try {
            InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
        String name = String.format("%s-%d", host, port);
        DiamondEnv env = diamondEnvs.get(name);
        if (env != null) {
            return env;
        }
        env = new DiamondEnv(new ServerListManager(host, port));
        diamondEnvs.put(name, env);
        return env;
    }

    public static synchronized DiamondEnv getTargetEnv(String ... serverIps) {
        int i = 0;
        while (i < serverIps.length) {
            serverIps[i] = serverIps[i].trim();
            String ip = serverIps[i];
            try {
                InetAddress.getByName(ip);
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
            ++i;
        }
        String name = DiamondEnvRepo.getWorkerName(serverIps);
        DiamondEnv env = diamondEnvs.get(name);
        if (env == null) {
            env = new DiamondEnv(serverIps);
            diamondEnvs.put(name, env);
        }
        return env;
    }

    protected static synchronized DiamondEnv getUnitEnv(String unitName) {
        DiamondEnv env = diamondEnvs.get(unitName);
        if (env != null) {
            return env;
        }
        env = new DiamondEnv(new ServerManager_unitSite(unitName));
        diamondEnvs.put(unitName, env);
        return env;
    }

    protected static String getWorkerName(String ... serverIps) {
        StringBuilder sb = new StringBuilder("com.taobao.diamond.client.worker-");
        String split = "";
        String[] stringArray = serverIps;
        int n = serverIps.length;
        int n2 = 0;
        while (n2 < n) {
            String serverIp = stringArray[n2];
            sb.append(split);
            sb.append(serverIp);
            split = "-";
            ++n2;
        }
        return sb.toString();
    }
}

