/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.diamond.client.impl;

import com.taobao.diamond.client.BatchHttpResult;
import com.taobao.diamond.client.impl.CacheData;
import com.taobao.diamond.client.impl.ClientWorker;
import com.taobao.diamond.client.impl.HttpSimpleClient;
import com.taobao.diamond.client.impl.LocalConfigInfoProcessor;
import com.taobao.diamond.client.impl.LogUtils;
import com.taobao.diamond.client.impl.ServerHttpAgent;
import com.taobao.diamond.client.impl.ServerListManager;
import com.taobao.diamond.client.impl.TenantUtil;
import com.taobao.diamond.common.Constants;
import com.taobao.diamond.common.GroupKey;
import com.taobao.diamond.domain.ConfigInfo4Beta;
import com.taobao.diamond.domain.ConfigInfoEx;
import com.taobao.diamond.domain.RestResult;
import com.taobao.diamond.exception.DiamondException;
import com.taobao.diamond.manager.ManagerListener;
import com.taobao.diamond.mockserver.MockServer;
import com.taobao.diamond.utils.ContentUtils;
import com.taobao.diamond.utils.JSONUtils;
import com.taobao.diamond.utils.ParamUtils;
import com.taobao.diamond.utils.StringUtils;
import com.taobao.middleware.logger.Logger;
import com.taobao.middleware.logger.support.LoggerHelper;
import java.io.IOException;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.codehaus.jackson.type.TypeReference;

public class DiamondEnv {
    public static final Logger log = LogUtils.logger(DiamondEnv.class);
    public static final long POST_TIMEOUT = 3000L;
    protected ServerListManager serverMgr;
    protected ServerHttpAgent agent;
    protected ClientWorker worker;
    private final AtomicReference<Map<String, CacheData>> cacheMap;
    private double PER_TASK_CONFIG_SIZE = 3000.0;

    public void addListeners(String dataId, String group, List<? extends ManagerListener> listeners) {
        group = this.null2defaultGroup(group);
        CacheData cache = this.addCacheDataIfAbsent(dataId, group);
        for (ManagerListener managerListener : listeners) {
            cache.addListener(managerListener);
        }
    }

    public void addListeners(String dataId, List<? extends ManagerListener> listeners) {
        String group = this.null2defaultGroup(null);
        String tenant = TenantUtil.getUserTenant();
        CacheData cache = this.addCacheDataIfAbsent(dataId, group, tenant);
        for (ManagerListener managerListener : listeners) {
            cache.addListener(managerListener);
        }
    }

    public void addListeners(String tenant, String dataId, String group, List<? extends ManagerListener> listeners) throws DiamondException {
        group = this.null2defaultGroup(group);
        ParamUtils.checkTDG((String)tenant, (String)dataId, (String)group);
        CacheData cache = this.addCacheDataIfAbsent(dataId, group, tenant);
        for (ManagerListener managerListener : listeners) {
            cache.addListener(managerListener);
        }
    }

    public void addTenantListeners(String dataId, String group, List<? extends ManagerListener> listeners) {
        group = this.null2defaultGroup(group);
        String tenant = TenantUtil.getUserTenant();
        CacheData cache = this.addCacheDataIfAbsent(dataId, group, tenant);
        for (ManagerListener managerListener : listeners) {
            cache.addListener(managerListener);
        }
    }

    public void removeListener(String dataId, String group, ManagerListener listener) {
        CacheData cache = this.getCache(dataId, group = this.null2defaultGroup(group));
        if (cache != null) {
            cache.removeListener(listener);
            if (cache.getListeners().isEmpty()) {
                this.removeCache(dataId, group);
            }
        }
    }

    public void removeListener(String dataId, ManagerListener listener) {
        String group = this.null2defaultGroup(null);
        String tenant = TenantUtil.getUserTenant();
        CacheData cache = this.getCache(tenant, dataId, group);
        if (cache != null) {
            cache.removeListener(listener);
            if (cache.getListeners().isEmpty()) {
                this.removeCache(tenant, dataId, group);
            }
        }
    }

    public void removeListener(String tenant, String dataId, String group, ManagerListener listener) throws DiamondException {
        group = this.null2defaultGroup(group);
        ParamUtils.checkTDG((String)tenant, (String)dataId, (String)group);
        CacheData cache = this.getCache(dataId, group, tenant);
        if (cache != null) {
            cache.removeListener(listener);
            if (cache.getListeners().isEmpty()) {
                this.removeCache(dataId, group, tenant);
            }
        }
    }

    public List<ManagerListener> getListeners(String dataId, String group) {
        CacheData cache = this.getCache(dataId, group = this.null2defaultGroup(group));
        if (cache == null) {
            return Collections.emptyList();
        }
        return cache.getListeners();
    }

    public List<ManagerListener> getListeners(String tenant, String dataId, String group) throws DiamondException {
        group = this.null2defaultGroup(group);
        ParamUtils.checkTDG((String)tenant, (String)dataId, (String)group);
        CacheData cache = this.getCache(dataId, group, tenant);
        if (cache == null) {
            return Collections.emptyList();
        }
        return cache.getListeners();
    }

    public String getTenantConfig(String dataId, String group, long timeoutMs) throws DiamondException {
        return this.getConfigInner(TenantUtil.getUserTenant(), dataId, group, timeoutMs);
    }

    public String getConfig(String dataId, String group, long timeoutMs) throws IOException {
        try {
            return this.getConfigInner(TenantUtil.getDefaultTenant(), dataId, group, timeoutMs);
        }
        catch (DiamondException e) {
            throw new IOException(e.toString());
        }
    }

    public String getGlobalConfig(String dataId, String group, long timeoutMs) throws DiamondException {
        return this.getConfigInner(TenantUtil.getDefaultTenant(), dataId, group, timeoutMs);
    }

    public String getConfig(String dataId, long timeoutMs) throws IOException {
        try {
            return this.getConfigInner(TenantUtil.getUserTenant(), dataId, null, timeoutMs);
        }
        catch (DiamondException e) {
            throw new IOException(e.toString());
        }
    }

    public String getConfigTag(String dataId, String group, String tag, long timeoutMs) throws DiamondException {
        return this.getConfigTagInner(TenantUtil.getDefaultTenant(), dataId, group, tag, timeoutMs);
    }

    public String getConfig(String tenant, String dataId, String group, long timeoutMs) throws DiamondException {
        ParamUtils.checkTenant((String)tenant);
        return this.getConfigInner(tenant, dataId, group, timeoutMs);
    }

    public String getConfigTag(String tenant, String dataId, String group, String tag, long timeoutMs) throws DiamondException {
        ParamUtils.checkTenant((String)tenant);
        return this.getConfigTagInner(tenant, dataId, group, tag, timeoutMs);
    }

    private String getConfigInner(String tenant, String dataId, String group, long timeoutMs) throws DiamondException {
        group = this.null2defaultGroup(group);
        ParamUtils.checkKeyParam((String)dataId, (String)group);
        if (MockServer.isTestMode()) {
            return MockServer.getConfigInfo(dataId, group, this);
        }
        String content = LocalConfigInfoProcessor.getFailover(this, dataId, group, tenant);
        if (content != null) {
            log.warn(this.getName(), "[get-config] get failover ok, dataId={}, group={}, tenant={}, config={}", new Object[]{dataId, group, tenant, ContentUtils.truncateContent((String)content)});
            return content;
        }
        try {
            return ClientWorker.getServerConfig(this, dataId, group, tenant, timeoutMs);
        }
        catch (DiamondException ioe) {
            if (403 == ioe.getErrCode()) {
                throw ioe;
            }
            log.warn("Diamond-0003", LoggerHelper.getErrorCodeStr((String)"Diamond", (String)"Diamond-0003", (String)"\u73af\u5883\u95ee\u9898", (String)"get from server error"));
            log.warn(this.getName(), "[get-config] get from server error, dataId={}, group={}, tenant={}, msg={}", new Object[]{dataId, group, tenant, ioe.toString()});
            log.warn(this.getName(), "[get-config] get snapshot ok, dataId={}, group={}, tenant={}, config={}", new Object[]{dataId, group, tenant, ContentUtils.truncateContent((String)content)});
            return LocalConfigInfoProcessor.getSnapshot(this, dataId, group, tenant);
        }
    }

    private String getConfigTagInner(String tenant, String dataId, String group, String tag, long readTimeout) throws DiamondException {
        if (StringUtils.isBlank((String)group)) {
            group = "DEFAULT_GROUP";
        }
        if (MockServer.isTestMode()) {
            return MockServer.getConfigInfo(dataId, group, this);
        }
        HttpSimpleClient.HttpResult result = null;
        try {
            ArrayList<String> params = new ArrayList<String>();
            params.add("dataId");
            params.add(dataId);
            params.add("group");
            params.add(group);
            if (StringUtils.isNotEmpty((String)tenant)) {
                params.add("tenant");
                params.add(tenant);
            }
            if (StringUtils.isNotEmpty((String)tag)) {
                params.add("tag");
                params.add(tag);
            }
            result = this.agent.httpGet("/config.co", null, params, "GBK", readTimeout);
        }
        catch (IOException e) {
            log.error(this.getName(), "DIAMOND-XXXX", "[sub-server] get server config exception, dataId={}, group={}, tenant={}, msg={}", new Object[]{dataId, group, tenant, e.toString()});
            throw new DiamondException(500, e.getMessage());
        }
        switch (result.code) {
            case 200: {
                return result.content;
            }
            case 404: {
                return null;
            }
            case 409: {
                log.error(this.getName(), "DIAMOND-XXXX", "[sub-server-error] get server config being modified concurrently, dataId={}, group={}, tenant={}", new Object[]{dataId, group, tenant});
                throw new DiamondException(409, "data being modified, dataId=" + dataId + ",group=" + group + ",tenant=" + tenant);
            }
            case 403: {
                log.error(this.getName(), "DIAMOND-XXXX", "[sub-server-error] no right, dataId={}, group={}, tenant={}", new Object[]{dataId, group, tenant});
                throw new DiamondException(result.code, result.content);
            }
        }
        log.error(this.getName(), "DIAMOND-XXXX", "[sub-server-error]  dataId={}, group={}, tenant={}, code={}", new Object[]{dataId, group, tenant, result.code});
        throw new DiamondException(result.code, "http error, code=" + result.code + ",dataId=" + dataId + ",group=" + group + ",tenant=" + tenant);
    }

    public String getConfig(String dataId, String group, int feature, long timeoutMs) throws IOException {
        group = this.null2defaultGroup(group);
        if (feature == 1) {
            return this.getConfig(dataId, group, timeoutMs);
        }
        if (MockServer.isTestMode()) {
            return MockServer.getConfigInfo(dataId, group, this);
        }
        String content = LocalConfigInfoProcessor.getFailover(this, dataId, group, TenantUtil.getDefaultTenant());
        if (content != null) {
            log.warn(this.getName(), "[get-config] get failover ok, dataId={}, group={}, tenant={}, config={}", new Object[]{dataId, group, TenantUtil.getDefaultTenant(), ContentUtils.truncateContent((String)content)});
            return content;
        }
        content = LocalConfigInfoProcessor.getSnapshot(this, dataId, group, TenantUtil.getDefaultTenant());
        if (StringUtils.isNotEmpty((String)content)) {
            log.warn(this.getName(), "[get-config] get snapshot ok, dataId={}, group={}, tenant={}, config={}", new Object[]{dataId, group, TenantUtil.getDefaultTenant(), ContentUtils.truncateContent((String)content)});
            return content;
        }
        try {
            return ClientWorker.getServerConfig(this, dataId, group, timeoutMs);
        }
        catch (DiamondException e) {
            throw new IOException(e.toString());
        }
    }

    public String getConfigFromSnapshot(String tenant, String dataId, String group) {
        return LocalConfigInfoProcessor.getSnapshot(this, dataId, group, tenant);
    }

    public boolean publishSingle(String dataId, String group, String content) {
        return this.publishSingle(dataId, group, null, content);
    }

    public boolean publishSingle(String dataId, String group, String appName, String content) {
        try {
            return this.publishSingleInner(TenantUtil.getDefaultTenant(), dataId, group, null, appName, null, content);
        }
        catch (DiamondException e) {
            if (e.getErrCode() == -400) {
                throw new IllegalArgumentException(e.toString());
            }
            if (e.getErrCode() == 403) {
                throw new AccessControlException(e.toString());
            }
            return false;
        }
    }

    public boolean publishBeta(String dataId, String group, String betaIps, String content) throws DiamondException {
        ParamUtils.checkBetaIps((String)betaIps);
        return this.publishBeta(dataId, group, null, betaIps, content);
    }

    public boolean publishBeta(String dataId, String group, String appName, String betaIps, String content) throws DiamondException {
        ParamUtils.checkBetaIps((String)betaIps);
        return this.publishSingleInner(TenantUtil.getDefaultTenant(), dataId, group, null, appName, betaIps, content);
    }

    public boolean publishSingle(String tenant, String dataId, String group, String appName, String content) throws DiamondException {
        ParamUtils.checkTenant((String)tenant);
        return this.publishSingleInner(tenant, dataId, group, null, appName, null, content);
    }

    public boolean publishSingleTag(String tenant, String dataId, String group, String tag, String appName, String content) throws DiamondException {
        ParamUtils.checkTenant((String)tenant);
        return this.publishSingleInner(tenant, dataId, group, tag, appName, null, content);
    }

    public boolean publishSingleTag(String dataId, String group, String tag, String appName, String content) throws DiamondException {
        return this.publishSingleInner(TenantUtil.getDefaultTenant(), dataId, group, tag, appName, null, content);
    }

    public boolean publishSingleTag(String dataId, String group, String tag, String content) throws DiamondException {
        return this.publishSingleInner(TenantUtil.getDefaultTenant(), dataId, group, tag, null, null, content);
    }

    private boolean publishSingleInner(String tenant, String dataId, String group, String tag, String appName, String betaIps, String content) throws DiamondException {
        group = this.null2defaultGroup(group);
        ParamUtils.checkParam((String)dataId, (String)group, (String)content);
        if (MockServer.isTestMode()) {
            MockServer.setConfigInfo(dataId, group, content, this);
            return true;
        }
        String url = "/basestone.do?method=syncUpdateAll";
        ArrayList<String> params = new ArrayList<String>();
        params.add("dataId");
        params.add(dataId);
        params.add("group");
        params.add(group);
        params.add("content");
        params.add(content);
        if (StringUtils.isNotEmpty((String)tenant)) {
            params.add("tenant");
            params.add(tenant);
        }
        if (StringUtils.isNotEmpty((String)appName)) {
            params.add("appName");
            params.add(appName);
        }
        if (StringUtils.isNotEmpty((String)tag)) {
            params.add("tag");
            params.add(tag);
        }
        ArrayList<String> headers = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)betaIps)) {
            headers.add("betaIps");
            headers.add(betaIps);
        }
        HttpSimpleClient.HttpResult result = null;
        try {
            result = this.agent.httpPost(url, headers, params, "GBK", 3000L);
        }
        catch (IOException ioe) {
            log.warn("Diamond-0006", LoggerHelper.getErrorCodeStr((String)"Diamond", (String)"Diamond-0006", (String)"\u73af\u5883\u95ee\u9898", (String)"[publish-single] exception"));
            log.warn(this.getName(), "[publish-single] exception, dataId={}, group={}, msg={}", new Object[]{dataId, group, ioe.toString()});
            return false;
        }
        if (200 == result.code) {
            log.info(this.getName(), "[publish-single] ok, dataId={}, group={}, tenant={}, config={}", new Object[]{dataId, group, tenant, ContentUtils.truncateContent((String)content)});
            return true;
        }
        if (403 == result.code) {
            log.warn(this.getName(), "[publish-single] error, dataId={}, group={}, tenant={}, code={}, msg={}", new Object[]{dataId, group, tenant, result.code, result.content});
            throw new DiamondException(result.code, result.content);
        }
        log.warn(this.getName(), "[publish-single] error, dataId={}, group={}, tenant={}, code={}, msg={}", new Object[]{dataId, group, tenant, result.code, result.content});
        return false;
    }

    public boolean publishAggr(String dataId, String group, String datumId, String content) {
        return this.publishAggr(dataId, group, datumId, null, content);
    }

    public boolean publishAggr(String dataId, String group, String datumId, String appName, String content) {
        try {
            return this.publishAggrInner(TenantUtil.defaultTenant, dataId, group, datumId, appName, content);
        }
        catch (DiamondException e) {
            if (e.getErrCode() == -400) {
                throw new IllegalArgumentException(e.toString());
            }
            if (e.getErrCode() == 403) {
                throw new AccessControlException(e.toString());
            }
            return false;
        }
    }

    public boolean publishAggr(String tenant, String dataId, String group, String datumId, String appName, String content) throws DiamondException {
        ParamUtils.checkTenant((String)tenant);
        return this.publishAggrInner(tenant, dataId, group, datumId, appName, content);
    }

    private boolean publishAggrInner(String tenant, String dataId, String group, String datumId, String appName, String content) throws DiamondException {
        group = this.null2defaultGroup(group);
        ParamUtils.checkParam((String)dataId, (String)group, (String)datumId, (String)content);
        String url = "/datum.do?method=addDatum";
        ArrayList<String> params = new ArrayList<String>();
        params.add("dataId");
        params.add(dataId);
        params.add("group");
        params.add(group);
        if (StringUtils.isNotEmpty((String)tenant)) {
            params.add("tenant");
            params.add(tenant);
        }
        params.add("datumId");
        params.add(datumId);
        params.add("content");
        params.add(content);
        if (StringUtils.isNotEmpty((String)appName)) {
            params.add("appName");
            params.add(appName);
        }
        HttpSimpleClient.HttpResult result = null;
        try {
            result = this.agent.httpPost(url, null, params, "GBK", 3000L);
        }
        catch (IOException ioe) {
            log.warn(this.getName(), "[publish-aggr] exception, dataId={}, group={}, tenant={}, datumId={}, msg={}", new Object[]{dataId, group, tenant, datumId, ioe.toString()});
            return false;
        }
        if (200 == result.code) {
            log.info(this.getName(), "[publish-aggr] ok, dataId={}, group={}, tenant={}, datumId={}, config={}", new Object[]{dataId, group, tenant, datumId, ContentUtils.truncateContent((String)content)});
            return true;
        }
        if (403 == result.code) {
            log.error(this.getName(), "[publish-aggr] error, dataId={}, group={}, tenant={}, code={}, msg={}", dataId, new Object[]{group, tenant, result.code, result.content});
            throw new DiamondException(result.code, result.content);
        }
        log.error(this.getName(), "[publish-aggr] error, dataId={}, group={}, tenant={}, code={}, msg={}", dataId, new Object[]{group, tenant, result.code, result.content});
        return false;
    }

    public boolean removeAggr(String dataId, String group, String datumId) {
        try {
            return this.removeAggrInner(TenantUtil.getDefaultTenant(), dataId, group, datumId);
        }
        catch (DiamondException e) {
            if (e.getErrCode() == -400) {
                throw new IllegalArgumentException(e.toString());
            }
            if (e.getErrCode() == 403) {
                throw new AccessControlException(e.toString());
            }
            return false;
        }
    }

    public boolean removeAggr(String tenant, String dataId, String group, String datumId) throws DiamondException {
        ParamUtils.checkTenant((String)tenant);
        return this.removeAggrInner(tenant, dataId, group, datumId);
    }

    private boolean removeAggrInner(String tenant, String dataId, String group, String datumId) throws DiamondException {
        DiamondEnv.checkNotNull(dataId, datumId);
        group = this.null2defaultGroup(group);
        ParamUtils.checkKeyParam((String)dataId, (String)group, (String)datumId);
        group = this.null2defaultGroup(group);
        String url = "/datum.do?method=deleteDatum";
        ArrayList<String> params = new ArrayList<String>();
        params.add("dataId");
        params.add(dataId);
        params.add("group");
        params.add(group);
        if (StringUtils.isNotEmpty((String)tenant)) {
            params.add("tenant");
            params.add(tenant);
        }
        params.add("datumId");
        params.add(datumId);
        HttpSimpleClient.HttpResult result = null;
        try {
            result = this.agent.httpPost(url, null, params, "GBK", 3000L);
        }
        catch (IOException ioe) {
            log.warn(this.getName(), "[remove-aggr] exception, dataId={}, group={}, tenant={}, datumId={}, msg={}", new Object[]{dataId, group, tenant, datumId, ioe.toString()});
            return false;
        }
        if (200 == result.code) {
            log.info(this.getName(), "[remove-aggr] ok, dataId={}, group={}, tenant={}, datumId={}", new Object[]{dataId, group, tenant, datumId});
            return true;
        }
        if (403 == result.code) {
            log.error(this.getName(), "[remove-aggr] error, dataId={}, group={}, tenant={}, datumId={}, code={}, msg={}", dataId, new Object[]{group, tenant, datumId, result.code, result.content});
            throw new DiamondException(result.code, result.content);
        }
        log.error(this.getName(), "[remove-aggr] error, dataId={}, group={}, tenant={}, datumId={}, code={}, msg={}", dataId, new Object[]{group, tenant, datumId, result.code, result.content});
        return false;
    }

    public boolean remove(String dataId, String group) {
        try {
            return this.removeInner(TenantUtil.getDefaultTenant(), dataId, group, null);
        }
        catch (DiamondException e) {
            if (e.getErrCode() == -400) {
                throw new IllegalArgumentException(e.toString());
            }
            if (e.getErrCode() == 403) {
                throw new AccessControlException(e.toString());
            }
            return false;
        }
    }

    public boolean remove(String tenant, String dataId, String group) throws DiamondException {
        ParamUtils.checkTenant((String)tenant);
        return this.removeInner(tenant, dataId, group, null);
    }

    public boolean removeTag(String dataId, String group, String tag) {
        try {
            return this.removeInner(TenantUtil.getDefaultTenant(), dataId, group, tag);
        }
        catch (DiamondException e) {
            if (e.getErrCode() == -400) {
                throw new IllegalArgumentException(e.toString());
            }
            if (e.getErrCode() == 403) {
                throw new AccessControlException(e.toString());
            }
            return false;
        }
    }

    public boolean remove(String tenant, String dataId, String group, String tag) throws DiamondException {
        ParamUtils.checkTenant((String)tenant);
        return this.removeInner(tenant, dataId, group, tag);
    }

    private boolean removeInner(String tenant, String dataId, String group, String tag) throws DiamondException {
        group = this.null2defaultGroup(group);
        ParamUtils.checkKeyParam((String)dataId, (String)group);
        if (MockServer.isTestMode()) {
            MockServer.removeConfigInfo(dataId, group, this);
            return true;
        }
        String url = "/datum.do?method=deleteAllDatums";
        ArrayList<String> params = new ArrayList<String>();
        params.add("dataId");
        params.add(dataId);
        params.add("group");
        params.add(group);
        if (StringUtils.isNotEmpty((String)tenant)) {
            params.add("tenant");
            params.add(tenant);
        }
        if (StringUtils.isNotEmpty((String)tag)) {
            params.add("tag");
            params.add(tag);
        }
        HttpSimpleClient.HttpResult result = null;
        try {
            result = this.agent.httpPost(url, null, params, "GBK", 3000L);
        }
        catch (IOException ioe) {
            log.warn("[remove] error, " + dataId + ", " + group + ", " + tenant + ", msg: " + ioe.toString());
            return false;
        }
        if (200 == result.code) {
            log.info(this.getName(), "[remove] ok, dataId={}, group={}, tenant={}", new Object[]{dataId, group, tenant});
            return true;
        }
        if (403 == result.code) {
            log.warn(this.getName(), "[remove] error, dataId={}, group={}, tenant={}, code={}, msg={}", new Object[]{dataId, group, tenant, result.code, result.content});
            throw new DiamondException(result.code, result.content);
        }
        log.warn(this.getName(), "[remove] error, dataId={}, group={}, tenant={}, code={}, msg={}", new Object[]{dataId, group, tenant, result.code, result.content});
        return false;
    }

    public List<String> getServerUrls() {
        return new ArrayList<String>(this.serverMgr.serverUrls);
    }

    private static void checkNotNull(String ... params) {
        String[] stringArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            if (StringUtils.isBlank((String)param)) {
                throw new IllegalArgumentException("param cannot be blank");
            }
            ++n2;
        }
    }

    private String null2defaultGroup(String group) {
        return group == null ? "DEFAULT_GROUP" : group.trim();
    }

    public BatchHttpResult<ConfigInfoEx> batchGetConfig(List<String> dataIds, String group, long timeoutMs) {
        if (dataIds == null) {
            throw new IllegalArgumentException("dataId list is null when batch get config");
        }
        group = this.null2defaultGroup(group);
        try {
            return this.batchGetConfigInner(TenantUtil.getDefaultTenant(), dataIds, group, timeoutMs);
        }
        catch (DiamondException e) {
            if (e.getErrCode() == -400) {
                throw new IllegalArgumentException(e.toString());
            }
            if (e.getErrCode() == 403) {
                throw new AccessControlException(e.toString());
            }
            return new BatchHttpResult<ConfigInfoEx>(false, -1, "batch get config exception:" + e.toString(), "");
        }
    }

    public BatchHttpResult<ConfigInfoEx> batchGetConfig(String tenant, List<String> dataIds, String group, long timeoutMs) throws DiamondException {
        ParamUtils.checkTenant((String)tenant);
        return this.batchGetConfigInner(tenant, dataIds, group, timeoutMs);
    }

    private BatchHttpResult<ConfigInfoEx> batchGetConfigInner(String tenant, List<String> dataIds, String group, long timeoutMs) throws DiamondException {
        group = this.null2defaultGroup(group);
        ParamUtils.checkKeyParam(dataIds, (String)group);
        if (dataIds == null) {
            throw new DiamondException(-400, "dataId list is null when batch get config");
        }
        if (MockServer.isTestMode()) {
            List<ConfigInfoEx> result = MockServer.batchQuery(dataIds, group, this);
            BatchHttpResult<ConfigInfoEx> response = new BatchHttpResult<ConfigInfoEx>(true, 200, "", "mock server");
            response.getResult().addAll(result);
            return response;
        }
        StringBuilder dataIdstr = new StringBuilder();
        String split = "";
        for (String dataId : dataIds) {
            dataIdstr.append(split);
            dataIdstr.append(dataId);
            split = Constants.WORD_SEPARATOR;
        }
        String url = "/config.co?method=batchGetConfig";
        ArrayList<String> params = new ArrayList<String>();
        params.add("dataIds");
        params.add(dataIdstr.toString());
        params.add("group");
        params.add(group);
        if (StringUtils.isNotEmpty((String)tenant)) {
            params.add("tenant");
            params.add(tenant);
        }
        HttpSimpleClient.HttpResult result = null;
        try {
            result = this.agent.httpPost(url, null, params, "GBK", timeoutMs);
        }
        catch (IOException ioe) {
            log.warn(this.getName(), "[batch-get] exception, dataIds={}, group={}, tenant={}, msg={}", new Object[]{dataIds, group, tenant, ioe});
            return new BatchHttpResult<ConfigInfoEx>(false, -1, "batch get config io exception:" + ioe.getMessage(), "");
        }
        BatchHttpResult<ConfigInfoEx> response = new BatchHttpResult<ConfigInfoEx>(true, result.code, "", result.content);
        if (result.code == 200) {
            response.setSuccess(true);
            response.setStatusMsg("batch get config success");
            log.info(this.getName(), "[batch-get] ok, dataIds={}, group={}, tenant={}", new Object[]{dataIds, group, tenant});
        } else {
            if (403 == result.code) {
                log.warn(this.getName(), "[batch-get] error, dataIds={}, group={}, tenant={}, code={}, msg={}", new Object[]{dataIds, group, tenant, result.code, result.content});
                throw new DiamondException(result.code, result.content);
            }
            response.setSuccess(false);
            response.setStatusMsg("batch get config fail, status:" + result.code);
            log.warn(this.getName(), "[batch-get] error, dataIds={}, group={}, tenant={}, code={}, msg={}", new Object[]{dataIds, group, tenant, result.code, result.content});
        }
        if (200 == result.code || 412 == result.code) {
            try {
                String json = result.content;
                Object resultObj = JSONUtils.deserializeObject((String)json, (TypeReference)new TypeReference<List<ConfigInfoEx>>(){});
                response.getResult().addAll((List)resultObj);
                LocalConfigInfoProcessor.batchSaveSnapshot(this, (List)resultObj);
            }
            catch (Exception e) {
                response.setSuccess(false);
                response.setStatusMsg("batch get config deserialize error");
                log.warn(this.getName(), "[batch-get] deserialize error, dataIds={}, group={}, tenant={}, msg={}", new Object[]{dataIds, group, tenant, e.toString()});
            }
        }
        return response;
    }

    public BatchHttpResult<ConfigInfoEx> batchQuery(List<String> dataIds, String group, long timeoutMs) {
        BatchHttpResult<ConfigInfoEx> response = new BatchHttpResult<ConfigInfoEx>();
        if (dataIds == null) {
            throw new IllegalArgumentException("dataId list is null when batch query");
        }
        group = this.null2defaultGroup(group);
        if (MockServer.isTestMode()) {
            List<ConfigInfoEx> result = MockServer.batchQuery(dataIds, group, this);
            response.setStatusCode(200);
            response.setResponseMsg("mock server");
            response.setSuccess(true);
            response.getResult().addAll(result);
            return response;
        }
        StringBuilder dataIdstr = new StringBuilder();
        String split = "";
        for (String dataId : dataIds) {
            dataIdstr.append(split);
            dataIdstr.append(dataId);
            split = Constants.WORD_SEPARATOR;
        }
        String url = "/admin.do?method=batchQuery";
        List<String> params = Arrays.asList("dataIds", dataIdstr.toString(), "group", group);
        HttpSimpleClient.HttpResult result = null;
        try {
            result = this.agent.httpPost(url, null, params, "GBK", timeoutMs);
        }
        catch (IOException ioe) {
            log.warn(this.getName(), "[batch-query] exception, dataIds={}, group={}, msg={}", new Object[]{dataIds, group, ioe});
            response.setSuccess(false);
            response.setStatusMsg("batch query io exception\uff1a" + ioe.getMessage());
            return response;
        }
        response.setStatusCode(result.code);
        response.setResponseMsg(result.content);
        if (200 == result.code || 412 == result.code) {
            try {
                String json = result.content;
                Object resultObj = JSONUtils.deserializeObject((String)json, (TypeReference)new TypeReference<List<ConfigInfoEx>>(){});
                response.setSuccess(true);
                response.getResult().addAll((List)resultObj);
                log.info(this.getName(), "[batch-query] ok, dataIds={}, group={}", new Object[]{dataIds, group});
            }
            catch (Exception e) {
                response.setSuccess(false);
                response.setStatusMsg("batch query deserialize error");
                log.warn(this.getName(), "[batch-query] deserialize error, dataIds={}, group={}, msg={}", new Object[]{dataIds, group, e.toString()});
            }
        } else {
            response.setSuccess(false);
            response.setStatusMsg("batch query fail, status:" + result.code);
            log.warn(this.getName(), "[batch-query] error, dataIds={}, group={}, code={}, msg={}", new Object[]{dataIds, group, result.code, result.content});
            return response;
        }
        return response;
    }

    public boolean stopBeta(String dataId, String group) throws DiamondException {
        return this.stopBetaInner(TenantUtil.getDefaultTenant(), dataId, group);
    }

    public boolean stopBeta(String tenant, String dataId, String group) throws DiamondException {
        ParamUtils.checkTenant((String)tenant);
        return this.stopBetaInner(tenant, dataId, group);
    }

    private boolean stopBetaInner(String tenant, String dataId, String group) throws DiamondException {
        boolean response = false;
        group = this.null2defaultGroup(group);
        ParamUtils.checkKeyParam((String)dataId, (String)group);
        String url = "/admin.do";
        List<String> params = null;
        params = StringUtils.isBlank((String)tenant) ? Arrays.asList("method", "stopBeta", "dataId", dataId, "group", group) : Arrays.asList("method", "stopBeta", "tenant", tenant, "dataId", dataId, "group", group);
        HttpSimpleClient.HttpResult result = null;
        try {
            result = this.agent.httpGet(url, null, params, "GBK", 3000L);
        }
        catch (IOException ioe) {
            log.warn(this.getName(), "[stopBeta] exception, tenant={}, dataId={}, group={}, msg={}", new Object[]{tenant, dataId, group, ioe});
            throw new DiamondException(500, ioe.getMessage());
        }
        if (200 == result.code) {
            try {
                String json = result.content;
                Object resultObj = JSONUtils.deserializeObject((String)json, (TypeReference)new TypeReference<RestResult<Boolean>>(){});
                RestResult tmp = (RestResult)resultObj;
                if (200 != tmp.getCode()) {
                    log.warn(this.getName(), "[stopBeta] error, tenant={}, dataId={}, group={}, code={}, msg={}", new Object[]{tenant, dataId, group, result.code, result.content});
                    throw new DiamondException(tmp.getCode(), tmp.getMessage());
                }
                response = (Boolean)tmp.getData();
                log.info(this.getName(), "[stopBeta] ok, tenant={}, dataId={}, group={}", new Object[]{tenant, dataId, group});
            }
            catch (Exception e) {
                log.warn(this.getName(), "[stopBeta] deserialize error, tenant={}, dataId={} group={}, msg={}", new Object[]{tenant, dataId, group, e.toString()});
                throw new DiamondException(500, e.getMessage());
            }
        } else {
            log.warn(this.getName(), "[stopBeta] error, tenant={}, dataId={}, group={}, code={}, msg={}", new Object[]{tenant, dataId, group, result.code, result.content});
            throw new DiamondException(result.code, result.content);
        }
        return response;
    }

    public ConfigInfo4Beta getBeta(String dataId, String group) throws DiamondException {
        return this.getBetaInner(TenantUtil.getDefaultTenant(), dataId, group);
    }

    public ConfigInfo4Beta getBeta(String tenant, String dataId, String group) throws DiamondException {
        ParamUtils.checkTenant((String)tenant);
        return this.getBetaInner(tenant, dataId, group);
    }

    private ConfigInfo4Beta getBetaInner(String tenant, String dataId, String group) throws DiamondException {
        ConfigInfo4Beta response = null;
        group = this.null2defaultGroup(group);
        ParamUtils.checkKeyParam((String)dataId, (String)group);
        String url = "/admin.do";
        List<String> params = null;
        params = StringUtils.isBlank((String)tenant) ? Arrays.asList("method", "queryBeta", "dataId", dataId, "group", group) : Arrays.asList("method", "queryBeta", "tenant", tenant, "dataId", dataId, "group", group);
        HttpSimpleClient.HttpResult result = null;
        try {
            result = this.agent.httpGet(url, null, params, "GBK", 3000L);
        }
        catch (IOException ioe) {
            throw new DiamondException(500, ioe.getMessage());
        }
        if (200 == result.code) {
            try {
                String json = result.content;
                Object resultObj = JSONUtils.deserializeObject((String)json, (TypeReference)new TypeReference<RestResult<ConfigInfo4Beta>>(){});
                RestResult tmp = (RestResult)resultObj;
                if (200 != tmp.getCode()) {
                    log.warn(this.getName(), "[getBeta] error, tenant={}, dataId={}, group={}, code={}, msg={}", new Object[]{tenant, dataId, group, result.code, result.content});
                    throw new DiamondException(tmp.getCode(), tmp.getMessage());
                }
                response = (ConfigInfo4Beta)tmp.getData();
                log.info(this.getName(), "[getBeta] ok, tenant={}, dataId={}, group={}", new Object[]{tenant, dataId, group});
            }
            catch (IOException e) {
                log.warn(this.getName(), "[getBeta] deserialize error, tenant={}, dataId={} group={}, msg={}", new Object[]{tenant, dataId, group, e.toString()});
                throw new DiamondException(500, e.getMessage());
            }
        } else {
            log.warn(this.getName(), "[getBeta] error, tenant={}, dataId={}, group={}, code={}, msg={}", new Object[]{tenant, dataId, group, result.code, result.content});
            throw new DiamondException(result.code, result.content);
        }
        return response;
    }

    public boolean batchRemoveAggr(String dataId, String group, List<String> datumIdList, long timeoutMs) {
        HttpSimpleClient.HttpResult result;
        block5: {
            DiamondEnv.checkNotNull(dataId, group);
            if (datumIdList == null || datumIdList.isEmpty()) {
                throw new IllegalArgumentException("datumIdList cannot be blank");
            }
            StringBuilder datumStr = new StringBuilder();
            for (String datum : datumIdList) {
                datumStr.append(datum).append(Constants.WORD_SEPARATOR);
            }
            String url = "/datum.do?method=batchDeleteAggrs";
            List<String> params = Arrays.asList("dataId", dataId, "group", group, "datumList", datumStr.toString());
            result = null;
            result = this.agent.httpPost(url, null, params, "GBK", timeoutMs);
            if (result.code != 200) break block5;
            return true;
        }
        try {
            log.warn("response code :" + result.code + ", error message :" + result.content);
        }
        catch (IOException ioe) {
            log.warn(this.getName(), "[batchRemoveAggr] exception, dataId{}, group={}, msg={}", new Object[]{dataId, group, ioe});
        }
        return false;
    }

    public boolean batchPublishAggr(String dataId, String group, Map<String, String> datumMap, long timeoutMs) {
        return this.batchPublishAggr(dataId, group, datumMap, null, timeoutMs);
    }

    public boolean batchPublishAggr(String dataId, String group, Map<String, String> datumMap, String appName, long timeoutMs) {
        HttpSimpleClient.HttpResult result;
        block5: {
            DiamondEnv.checkNotNull(dataId, group);
            if (datumMap == null || datumMap.isEmpty()) {
                throw new IllegalArgumentException("datumMap cannot be blank");
            }
            StringBuilder datumStr = new StringBuilder();
            for (Map.Entry<String, String> datumEntry : datumMap.entrySet()) {
                datumStr.append(datumEntry.getKey()).append(Constants.WORD_SEPARATOR).append(datumEntry.getValue()).append(Constants.LINE_SEPARATOR);
            }
            String url = "/datum.do?method=batchAddAggrs";
            List<String> params = null;
            params = appName == null ? Arrays.asList("dataId", dataId, "group", group, "datas", datumStr.toString()) : Arrays.asList("dataId", dataId, "group", group, "datas", datumStr.toString(), "appName", appName);
            result = null;
            result = this.agent.httpPost(url, null, params, "GBK", timeoutMs);
            if (result.code != 200) break block5;
            log.info(this.getName(), "[batchPublishAggr] ok, dataId={}, group={}", new Object[]{dataId, group});
            return true;
        }
        try {
            log.warn("response code :" + result.code + ", error message :" + result.content);
        }
        catch (IOException ioe) {
            log.warn(this.getName(), "[batchPublishAggr] exception, dataId{}, group={}, msg={}", new Object[]{dataId, group, ioe});
        }
        return false;
    }

    public boolean replaceAggr(String dataId, String group, Map<String, String> datumMap, long timeoutMs) {
        return this.replaceAggr(dataId, group, datumMap, null, timeoutMs);
    }

    public boolean replaceAggr(String dataId, String group, Map<String, String> datumMap, String appName, long timeoutMs) {
        HttpSimpleClient.HttpResult result;
        block5: {
            DiamondEnv.checkNotNull(dataId, group);
            if (datumMap == null || datumMap.isEmpty()) {
                throw new IllegalArgumentException("datumMap cannot be blank");
            }
            StringBuilder datumStr = new StringBuilder();
            for (Map.Entry<String, String> datumEntry : datumMap.entrySet()) {
                datumStr.append(datumEntry.getKey()).append(Constants.WORD_SEPARATOR).append(datumEntry.getValue()).append(Constants.LINE_SEPARATOR);
            }
            String url = "/datum.do?method=replaceAggr";
            List<String> params = null;
            params = appName == null ? Arrays.asList("dataId", dataId, "group", group, "datas", datumStr.toString()) : Arrays.asList("dataId", dataId, "group", group, "datas", datumStr.toString(), "appName", appName);
            result = null;
            result = this.agent.httpPost(url, null, params, "GBK", timeoutMs);
            if (result.code != 200) break block5;
            return true;
        }
        try {
            log.warn("response code :" + result.code + ", error message :" + result.content);
        }
        catch (IOException ioe) {
            log.warn(this.getName(), "[replaceAggr] exception, dataId{}, group={}, msg={}", new Object[]{dataId, group, ioe});
        }
        return false;
    }

    public CacheData getCache(String dataId, String group) {
        return this.getCache(dataId, group, TenantUtil.getDefaultTenant());
    }

    public CacheData getCache(String dataId, String group, String tenant) {
        if (dataId == null || group == null) {
            throw new IllegalArgumentException();
        }
        return this.cacheMap.get().get(GroupKey.getKeyTenant((String)dataId, (String)group, (String)tenant));
    }

    List<CacheData> getAllCacheDataSnapshot() {
        return new ArrayList<CacheData>(this.cacheMap.get().values());
    }

    public int getAllCacheDataSize() {
        return this.cacheMap.get().size();
    }

    public List<String> getAllListeners() {
        return new ArrayList<String>(this.cacheMap.get().keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCache(String dataId, String group) {
        String groupKey = GroupKey.getKey((String)dataId, (String)group);
        AtomicReference<Map<String, CacheData>> atomicReference = this.cacheMap;
        synchronized (atomicReference) {
            HashMap<String, CacheData> copy = new HashMap<String, CacheData>(this.cacheMap.get());
            copy.remove(groupKey);
            this.cacheMap.set(copy);
        }
        log.info(this.getName(), "[unsubscribe] {}", new Object[]{groupKey});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCache(String dataId, String group, String tenant) {
        String groupKey = GroupKey.getKeyTenant((String)dataId, (String)group, (String)tenant);
        AtomicReference<Map<String, CacheData>> atomicReference = this.cacheMap;
        synchronized (atomicReference) {
            HashMap<String, CacheData> copy = new HashMap<String, CacheData>(this.cacheMap.get());
            copy.remove(groupKey);
            this.cacheMap.set(copy);
        }
        log.info(this.getName(), "[unsubscribe] {}", new Object[]{groupKey});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheData addCacheDataIfAbsent(String dataId, String group) {
        CacheData cache = this.getCache(dataId, group);
        if (cache != null) {
            return cache;
        }
        String key = GroupKey.getKey((String)dataId, (String)group);
        cache = new CacheData(this, dataId, group);
        AtomicReference<Map<String, CacheData>> atomicReference = this.cacheMap;
        synchronized (atomicReference) {
            CacheData cacheFromMap = this.getCache(dataId, group);
            if (cacheFromMap != null) {
                cache = cacheFromMap;
                cache.setInitializing(true);
            } else {
                int taskId = this.getAllCacheDataSize() / (int)this.getPER_TASK_CONFIG_SIZE();
                cache.setTaskId(taskId);
            }
            HashMap<String, CacheData> copy = new HashMap<String, CacheData>(this.cacheMap.get());
            copy.put(key, cache);
            this.cacheMap.set(copy);
        }
        log.info(this.getName(), "[subscribe] {}", new Object[]{key});
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheData addCacheDataIfAbsent(String dataId, String group, String tenant) {
        CacheData cache = this.getCache(dataId, group, tenant);
        if (cache != null) {
            return cache;
        }
        String key = GroupKey.getKeyTenant((String)dataId, (String)group, (String)tenant);
        cache = new CacheData(this, dataId, group, tenant);
        AtomicReference<Map<String, CacheData>> atomicReference = this.cacheMap;
        synchronized (atomicReference) {
            CacheData cacheFromMap = this.getCache(dataId, group, tenant);
            if (cacheFromMap != null) {
                cache = cacheFromMap;
                cache.setInitializing(true);
            }
            HashMap<String, CacheData> copy = new HashMap<String, CacheData>(this.cacheMap.get());
            copy.put(key, cache);
            this.cacheMap.set(copy);
        }
        log.info(this.getName(), "[subscribe] {}", new Object[]{key});
        return cache;
    }

    public Set<String> getSubscribeDataIds() {
        Map<String, CacheData> cacheMapSnapshot = this.cacheMap.get();
        HashSet<String> dataIds = new HashSet<String>(cacheMapSnapshot.size());
        for (CacheData cache : cacheMapSnapshot.values()) {
            dataIds.add(cache.dataId);
        }
        return dataIds;
    }

    public String toString() {
        return "DiamondEnv-" + this.serverMgr.toString();
    }

    public ServerListManager getServerMgr() {
        return this.serverMgr;
    }

    public String getName() {
        return this.serverMgr.name;
    }

    public ServerHttpAgent getAgent() {
        return this.agent;
    }

    public ClientWorker getWorker() {
        return this.worker;
    }

    public void initServerManager(ServerListManager _serverMgr) {
        _serverMgr.setEnv(this);
        this.serverMgr = _serverMgr;
        this.serverMgr.start();
        this.agent = new ServerHttpAgent(this.serverMgr);
    }

    public double getPER_TASK_CONFIG_SIZE() {
        return this.PER_TASK_CONFIG_SIZE;
    }

    public void setPER_TASK_CONFIG_SIZE(double pER_TASK_CONFIG_SIZE) {
        this.PER_TASK_CONFIG_SIZE = pER_TASK_CONFIG_SIZE;
    }

    public DiamondEnv(String ... serverIps) {
        this(new ServerListManager(Arrays.asList(serverIps)));
    }

    protected DiamondEnv(ServerListManager serverListMgr) {
        serverListMgr.setEnv(this);
        try {
            this.PER_TASK_CONFIG_SIZE = Double.valueOf(System.getProperty("PER_TASK_CONFIG_SIZE", "3000"));
            log.warn("PER_TASK_CONFIG_SIZE:", new Object[]{this.PER_TASK_CONFIG_SIZE});
        }
        catch (Throwable t) {
            log.error("PER_TASK_CONFIG_SIZE", "PER_TASK_CONFIG_SIZE invalid", t);
        }
        this.initServerManager(serverListMgr);
        this.cacheMap = new AtomicReference(new HashMap());
        this.worker = new ClientWorker(this);
    }
}

