/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.diamond.client.impl;

import com.taobao.diamond.client.impl.LogUtils;
import com.taobao.middleware.logger.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;

public class ConcurrentDiskUtil {
    public static final Logger log = LogUtils.logger(ConcurrentDiskUtil.class);
    static final int RETRY_COUNT = 10;
    static final int SLEEP_BASETIME = 10;

    public static String getFileContent(String path, String charsetName) throws IOException {
        File file = new File(path);
        return ConcurrentDiskUtil.getFileContent(file, charsetName);
    }

    public static String getFileContent(File file, String charsetName) throws IOException {
        RandomAccessFile fis = null;
        FileLock rlock = null;
        try {
            fis = new RandomAccessFile(file, "r");
            FileChannel fcin = fis.getChannel();
            int i = 0;
            do {
                try {
                    rlock = fcin.tryLock(0L, Long.MAX_VALUE, true);
                }
                catch (Exception e) {
                    if (++i > 10) {
                        log.error("read {} fail;retryed time:{}", file.getName(), new Object[]{i});
                        throw new IOException("read " + file.getAbsolutePath() + " conflict");
                    }
                    ConcurrentDiskUtil.sleep(10 * i);
                    log.warn("read {} conflict;retry time:{}", file.getName(), new Object[]{i});
                }
            } while (rlock == null);
            int fileSize = (int)fcin.size();
            ByteBuffer byteBuffer = ByteBuffer.allocate(fileSize);
            fcin.read(byteBuffer);
            byteBuffer.flip();
            String string = ConcurrentDiskUtil.byteBufferToString(byteBuffer, charsetName);
            return string;
        }
        finally {
            if (rlock != null) {
                rlock.release();
                rlock = null;
            }
            if (fis != null) {
                fis.close();
                fis = null;
            }
        }
    }

    public static Boolean writeFileContent(String path, String content, String charsetName) throws IOException {
        File file = new File(path);
        return ConcurrentDiskUtil.writeFileContent(file, content, charsetName);
    }

    public static Boolean writeFileContent(File file, String content, String charsetName) throws IOException {
        if (!file.exists()) {
            file.createNewFile();
        }
        AbstractInterruptibleChannel channel = null;
        FileLock lock = null;
        RandomAccessFile raf = null;
        try {
            try {
                raf = new RandomAccessFile(file, "rw");
                channel = raf.getChannel();
                int i = 0;
                do {
                    try {
                        lock = ((FileChannel)channel).tryLock();
                    }
                    catch (Exception e) {
                        if (++i > 10) {
                            log.error("write {} fail;retryed time:{}", file.getName(), new Object[]{i});
                            throw new IOException("write " + file.getAbsolutePath() + " conflict");
                        }
                        ConcurrentDiskUtil.sleep(10 * i);
                        log.warn("write {} conflict;retry time:{}", file.getName(), new Object[]{i});
                    }
                } while (lock == null);
                ByteBuffer sendBuffer = ByteBuffer.wrap(content.getBytes(charsetName));
                while (sendBuffer.hasRemaining()) {
                    ((FileChannel)channel).write(sendBuffer);
                }
                ((FileChannel)channel).truncate(content.length());
            }
            catch (FileNotFoundException e) {
                throw new IOException("file not exist");
            }
        }
        finally {
            if (lock != null) {
                try {
                    lock.release();
                    lock = null;
                }
                catch (IOException e) {
                    log.warn("close wrong", (Throwable)e);
                }
            }
            if (channel != null) {
                try {
                    channel.close();
                    channel = null;
                }
                catch (IOException e) {
                    log.warn("close wrong", (Throwable)e);
                }
            }
            if (raf != null) {
                try {
                    raf.close();
                    raf = null;
                }
                catch (IOException e) {
                    log.warn("close wrong", (Throwable)e);
                }
            }
        }
        return true;
    }

    public static String byteBufferToString(ByteBuffer buffer, String charsetName) throws IOException {
        Charset charset = null;
        CharsetDecoder decoder = null;
        CharBuffer charBuffer = null;
        charset = Charset.forName(charsetName);
        decoder = charset.newDecoder();
        charBuffer = decoder.decode(buffer.asReadOnlyBuffer());
        return charBuffer.toString();
    }

    private static void sleep(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            log.warn("sleep wrong", (Throwable)e);
        }
    }

    public static void main(String[] args) {
        try {
            int i = 0;
            while (i < 10000) {
                ConcurrentDiskUtil.writeFileContent("D:/test.txt", "test\r\ntest1", "GBK");
                String abc = ConcurrentDiskUtil.getFileContent("D:/test.txt", "GBK");
                if (!"test\r\ntest1".equals(abc)) {
                    System.out.println(abc);
                    System.out.println("diff");
                }
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

