/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.diamond.client.impl;

import com.taobao.diamond.client.impl.CacheData;
import com.taobao.diamond.client.impl.DiamondEnv;
import com.taobao.diamond.client.impl.HttpSimpleClient;
import com.taobao.diamond.client.impl.LocalConfigInfoProcessor;
import com.taobao.diamond.client.impl.TenantUtil;
import com.taobao.diamond.common.Constants;
import com.taobao.diamond.common.GroupKey;
import com.taobao.diamond.exception.DiamondException;
import com.taobao.diamond.md5.MD5;
import com.taobao.diamond.mockserver.MockServer;
import com.taobao.diamond.utils.ContentUtils;
import com.taobao.diamond.utils.StringUtils;
import com.taobao.middleware.logger.support.LoggerHelper;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class ClientWorker {
    final ScheduledExecutorService executor;
    final ExecutorService executorService;
    final DiamondEnv env;
    private boolean isHealthServer = true;
    private double currentLongingTaskCount = 0.0;

    static String getServerConfig(DiamondEnv env, String dataId, String group, long readTimeout) throws DiamondException {
        return ClientWorker.getServerConfig(env, dataId, group, TenantUtil.getDefaultTenant(), readTimeout);
    }

    static String getServerConfig(DiamondEnv env, String dataId, String group, String tenant, long readTimeout) throws DiamondException {
        if (StringUtils.isBlank((String)group)) {
            group = "DEFAULT_GROUP";
        }
        if (MockServer.isTestMode()) {
            return MockServer.getConfigInfo(dataId, group, env);
        }
        HttpSimpleClient.HttpResult result = null;
        try {
            List<String> params = null;
            params = StringUtils.isBlank((String)tenant) ? Arrays.asList("dataId", dataId, "group", group) : Arrays.asList("dataId", dataId, "group", group, "tenant", tenant);
            result = env.agent.httpGet("/config.co", null, params, "GBK", readTimeout);
        }
        catch (IOException e) {
            DiamondEnv.log.error(env.getName(), "DIAMOND-XXXX", "[sub-server] get server config exception, dataId={}, group={}, tenant={}, msg={}", new Object[]{dataId, group, tenant, e.toString()});
            throw new DiamondException(500, e.getMessage());
        }
        switch (result.code) {
            case 200: {
                LocalConfigInfoProcessor.saveSnapshot(env, dataId, group, tenant, result.content);
                return result.content;
            }
            case 404: {
                LocalConfigInfoProcessor.saveSnapshot(env, dataId, group, tenant, null);
                return null;
            }
            case 409: {
                DiamondEnv.log.error(env.getName(), "DIAMOND-XXXX", "[sub-server-error] get server config being modified concurrently, dataId={}, group={}, tenant={}", new Object[]{dataId, group, tenant});
                throw new DiamondException(409, "data being modified, dataId=" + dataId + ",group=" + group + ",tenant=" + tenant);
            }
            case 403: {
                DiamondEnv.log.error(env.getName(), "DIAMOND-XXXX", "[sub-server-error] no right, dataId={}, group={}, tenant={}", new Object[]{dataId, group, tenant});
                throw new DiamondException(result.code, result.content);
            }
        }
        DiamondEnv.log.error(env.getName(), "DIAMOND-XXXX", "[sub-server-error]  dataId={}, group={}, tenant={}, code={}", new Object[]{dataId, group, tenant, result.code});
        throw new DiamondException(result.code, "http error, code=" + result.code + ",dataId=" + dataId + ",group=" + group + ",tenant=" + tenant);
    }

    static void checkLocalConfig(DiamondEnv env, CacheData cacheData) {
        String dataId = cacheData.dataId;
        String group = cacheData.group;
        String tenant = cacheData.tenant;
        File path = LocalConfigInfoProcessor.getFailoverFile(env, dataId, group, tenant);
        if (!cacheData.isUseLocalConfigInfo() && path.exists()) {
            String content = LocalConfigInfoProcessor.getFailover(env, dataId, group, tenant);
            String md5 = MD5.getInstance().getMD5String(content);
            cacheData.setUseLocalConfigInfo(true);
            cacheData.setLocalConfigInfoVersion(path.lastModified());
            cacheData.setContent(content);
            DiamondEnv.log.warn(env.getName(), "[failover-change] failover file created. dataId={}, group={}, tenant={}, md5={}, content={}", new Object[]{dataId, group, tenant, md5, ContentUtils.truncateContent((String)content)});
            return;
        }
        if (cacheData.isUseLocalConfigInfo() && !path.exists()) {
            cacheData.setUseLocalConfigInfo(false);
            DiamondEnv.log.warn(env.getName(), "[failover-change] failover file deleted. dataId={}, group={}, tenant={}", new Object[]{dataId, group, tenant});
            return;
        }
        if (cacheData.isUseLocalConfigInfo() && path.exists() && cacheData.getLocalConfigInfoVersion() != path.lastModified()) {
            String content = LocalConfigInfoProcessor.getFailover(env, dataId, group, tenant);
            String md5 = MD5.getInstance().getMD5String(content);
            cacheData.setUseLocalConfigInfo(true);
            cacheData.setLocalConfigInfoVersion(path.lastModified());
            cacheData.setContent(content);
            DiamondEnv.log.warn(env.getName(), "[failover-change] failover file changed. dataId={}, group={}, tenant={}, md5={}, content={}", new Object[]{dataId, group, tenant, md5, ContentUtils.truncateContent((String)content)});
            return;
        }
    }

    public void checkConfigInfo() {
        this.checkConfigInfo(this.env);
    }

    public void checkConfigInfo(DiamondEnv env) {
        int listenerSize = env.getAllCacheDataSize();
        int longingTaskCount = (int)Math.ceil((double)listenerSize / env.getPER_TASK_CONFIG_SIZE());
        if ((double)longingTaskCount > this.currentLongingTaskCount) {
            int i = (int)this.currentLongingTaskCount;
            while (i < longingTaskCount) {
                this.executorService.execute(new LongPullingRunnable(i));
                ++i;
            }
            this.currentLongingTaskCount = longingTaskCount;
        }
    }

    List<String> checkUpdateDataIds(List<CacheData> cacheDatas, List<String> inInitializingCacheList) {
        if (MockServer.isTestMode()) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ArrayList<String> updateList = new ArrayList<String>();
            for (CacheData cacheData : cacheDatas) {
                if (cacheData.isInitializing()) {
                    inInitializingCacheList.add(GroupKey.getKeyTenant((String)cacheData.dataId, (String)cacheData.group, (String)cacheData.tenant));
                }
                if (CacheData.getMd5String(MockServer.getConfigInfo(cacheData.dataId, cacheData.group, cacheData.tenant, this.env)).equals(cacheData.getMd5())) continue;
                updateList.add(GroupKey.getKeyTenant((String)cacheData.dataId, (String)cacheData.group, (String)cacheData.tenant));
            }
            return updateList;
        }
        StringBuilder sb = new StringBuilder();
        for (CacheData cacheData : cacheDatas) {
            if (cacheData.isUseLocalConfigInfo()) continue;
            sb.append(cacheData.dataId).append(Constants.WORD_SEPARATOR);
            sb.append(cacheData.group).append(Constants.WORD_SEPARATOR);
            if (StringUtils.isBlank((String)cacheData.tenant)) {
                sb.append(cacheData.getMd5()).append(Constants.LINE_SEPARATOR);
            } else {
                sb.append(cacheData.getMd5()).append(Constants.WORD_SEPARATOR);
                sb.append(cacheData.getTenant()).append(Constants.LINE_SEPARATOR);
            }
            if (!cacheData.isInitializing()) continue;
            inInitializingCacheList.add(GroupKey.getKeyTenant((String)cacheData.dataId, (String)cacheData.group, (String)cacheData.tenant));
        }
        boolean isInitializingCacheList = !inInitializingCacheList.isEmpty();
        return this.checkUpdateConfigStr(sb.toString(), isInitializingCacheList);
    }

    List<String> checkUpdateConfigStr(String probeUpdateString, boolean isInitializingCacheList) {
        List<String> params = Arrays.asList("Probe-Modify-Request", probeUpdateString);
        long timeout = TimeUnit.SECONDS.toMillis(30L);
        ArrayList<String> headers = new ArrayList<String>(2);
        headers.add("longPullingTimeout");
        headers.add("" + timeout);
        if (isInitializingCacheList) {
            headers.add("longPullingNoHangUp");
            headers.add("true");
        }
        if (StringUtils.isBlank((String)probeUpdateString)) {
            return Collections.emptyList();
        }
        try {
            HttpSimpleClient.HttpResult result = this.env.agent.httpPost("/config.co", headers, params, "GBK", timeout);
            if (200 == result.code) {
                this.setHealthServer(true);
                return this.parseUpdateDataIdResponse(this.env, result.content);
            }
            this.setHealthServer(false);
            if (result.code == 500) {
                DiamondEnv.log.error("Diamond-0007", LoggerHelper.getErrorCodeStr((String)"Diamond", (String)"Diamond-0007", (String)"\u73af\u5883\u95ee\u9898", (String)"[check-update] get changed dataId error"));
            }
            DiamondEnv.log.error(this.env.getName(), "DIAMOND-XXXX", "[check-update] get changed dataId error, code={}", new Object[]{result.code});
        }
        catch (IOException e) {
            this.setHealthServer(false);
            DiamondEnv.log.error(this.env.getName(), "DIAMOND-XXXX", "[check-update] get changed dataId exception, msg={}", new Object[]{e.toString()});
        }
        return Collections.emptyList();
    }

    private List<String> parseUpdateDataIdResponse(DiamondEnv env, String response) {
        if (StringUtils.isBlank((String)response)) {
            return Collections.emptyList();
        }
        try {
            response = URLDecoder.decode(response, "UTF-8");
        }
        catch (Exception e) {
            DiamondEnv.log.error(env.getName(), "DIAMOND-XXXX", "[polling-resp] decode modifiedDataIdsString error", (Throwable)e);
        }
        LinkedList<String> updateList = new LinkedList<String>();
        String[] stringArray = response.split(Constants.LINE_SEPARATOR);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String dataIdAndGroup = stringArray[n2];
            if (!StringUtils.isBlank((String)dataIdAndGroup)) {
                String[] keyArr = dataIdAndGroup.split(Constants.WORD_SEPARATOR);
                String dataId = keyArr[0];
                String group = keyArr[1];
                if (keyArr.length == 2) {
                    updateList.add(GroupKey.getKey((String)dataId, (String)group));
                    DiamondEnv.log.info(env.getName(), "[polling-resp] config changed. dataId={}, group={}", new Object[]{dataId, group});
                } else if (keyArr.length == 3) {
                    String tenant = keyArr[2];
                    updateList.add(GroupKey.getKeyTenant((String)dataId, (String)group, (String)tenant));
                    DiamondEnv.log.info(env.getName(), "[polling-resp] config changed. dataId={}, group={}, tenant={}", new Object[]{dataId, group, tenant});
                } else {
                    DiamondEnv.log.error(env.getName(), "DIAMOND-XXXX", "[polling-resp] invalid dataIdAndGroup error", new Object[]{dataIdAndGroup});
                }
            }
            ++n2;
        }
        return updateList;
    }

    ClientWorker(final DiamondEnv env) {
        this.env = env;
        this.executor = Executors.newScheduledThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("com.taobao.diamond.client.Worker." + env.serverMgr.name);
                t.setDaemon(true);
                return t;
            }
        });
        this.executorService = Executors.newCachedThreadPool(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("com.taobao.diamond.client.Worker.longPulling" + env.serverMgr.name);
                t.setDaemon(true);
                return t;
            }
        });
        this.executor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientWorker.this.checkConfigInfo();
                }
                catch (Throwable e) {
                    DiamondEnv.log.error(env.getName(), "DIAMOND-XXXX", "[sub-check] rotate check error", e);
                }
            }
        }, 1L, 10L, TimeUnit.MILLISECONDS);
    }

    public boolean isHealthServer() {
        return this.isHealthServer;
    }

    private void setHealthServer(boolean isHealthServer) {
        this.isHealthServer = isHealthServer;
    }

    class LongPullingRunnable
    implements Runnable {
        private int taskId;

        public LongPullingRunnable(int taskId) {
            this.taskId = taskId;
        }

        @Override
        public void run() {
            try {
                try {
                    ArrayList<CacheData> cacheDatas = new ArrayList<CacheData>();
                    for (CacheData cacheData : ClientWorker.this.env.getAllCacheDataSnapshot()) {
                        if (cacheData.getTaskId() != this.taskId) continue;
                        cacheDatas.add(cacheData);
                        try {
                            ClientWorker.checkLocalConfig(ClientWorker.this.env, cacheData);
                            if (!cacheData.isUseLocalConfigInfo()) continue;
                            cacheData.checkListenerMd5();
                        }
                        catch (Exception e) {
                            DiamondEnv.log.error("DIAMOND-CLIENT", "get local config info error", (Throwable)e);
                        }
                    }
                    ArrayList<String> inInitializingCacheList = new ArrayList<String>();
                    List<String> changedGroupKeys = ClientWorker.this.checkUpdateDataIds(cacheDatas, inInitializingCacheList);
                    for (String groupKey : changedGroupKeys) {
                        String[] key = GroupKey.parseKey((String)groupKey);
                        String dataId = key[0];
                        String group = key[1];
                        String tenant = null;
                        if (key.length == 3) {
                            tenant = key[2];
                        }
                        try {
                            String content = ClientWorker.getServerConfig(ClientWorker.this.env, dataId, group, tenant, 3000L);
                            CacheData cache = ClientWorker.this.env.getCache(dataId, group, tenant);
                            cache.setContent(content);
                            DiamondEnv.log.info(ClientWorker.this.env.getName(), "[data-received] dataId={}, group={}, tenant={}, md5={}, content={}", new Object[]{dataId, group, tenant, cache.getMd5(), ContentUtils.truncateContent((String)content)});
                        }
                        catch (DiamondException ioe) {
                            DiamondEnv.log.error(ClientWorker.this.env.getName(), "DIAMOND-XXXX", "[get-update] get changed config exception. dataId={}, group={}, tenant={}, msg={}", new Object[]{dataId, group, tenant, ioe.toString()});
                        }
                    }
                    for (CacheData cacheData : cacheDatas) {
                        if (cacheData.isInitializing() && !inInitializingCacheList.contains(GroupKey.getKeyTenant((String)cacheData.dataId, (String)cacheData.group, (String)cacheData.tenant))) continue;
                        cacheData.checkListenerMd5();
                        cacheData.setInitializing(false);
                    }
                    inInitializingCacheList.clear();
                }
                catch (Throwable e) {
                    DiamondEnv.log.error("500", "longPulling error", e);
                    ClientWorker.this.executorService.execute(this);
                }
            }
            finally {
                ClientWorker.this.executorService.execute(this);
            }
        }
    }
}

