/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.diamond.client;

import com.taobao.diamond.client.BatchHttpResult;
import com.taobao.diamond.client.impl.DiamondEnv;
import com.taobao.diamond.client.impl.DiamondEnvRepo;
import com.taobao.diamond.client.impl.TenantUtil;
import com.taobao.diamond.domain.ConfigInfo4Beta;
import com.taobao.diamond.domain.ConfigInfoEx;
import com.taobao.diamond.exception.DiamondException;
import com.taobao.diamond.manager.ManagerListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class Diamond {
    public static void addListener(String dataId, String group, ManagerListener listener) {
        DiamondEnvRepo.defaultEnv.addListeners(dataId, group, Arrays.asList(listener));
    }

    public static void addListeners(String dataId, String group, List<ManagerListener> listeners) {
        DiamondEnvRepo.defaultEnv.addListeners(dataId, group, listeners);
    }

    public static void removeListener(String dataId, String group, ManagerListener listener) {
        DiamondEnvRepo.defaultEnv.removeListener(dataId, group, listener);
    }

    public static List<ManagerListener> getListeners(String dataId, String group) {
        return DiamondEnvRepo.defaultEnv.getListeners(dataId, group);
    }

    public static String getConfig(String dataId, String group, long timeoutMs) throws IOException {
        return DiamondEnvRepo.defaultEnv.getConfig(dataId, group, timeoutMs);
    }

    public static String getConfig(String dataId, String group, int feature, long timeoutMs) throws IOException {
        return DiamondEnvRepo.defaultEnv.getConfig(dataId, group, feature, timeoutMs);
    }

    public static String getConfigFromSnapShot(String dataId, String group) {
        return DiamondEnvRepo.defaultEnv.getConfigFromSnapshot(TenantUtil.getDefaultTenant(), dataId, group);
    }

    public static boolean publishSingle(String dataId, String group, String content) {
        return DiamondEnvRepo.defaultEnv.publishSingle(dataId, group, content);
    }

    public static boolean publishSingle(String dataId, String group, String appName, String content) {
        return DiamondEnvRepo.defaultEnv.publishSingle(dataId, group, appName, content);
    }

    public static boolean publishAggr(String dataId, String group, String datumId, String content) {
        return DiamondEnvRepo.defaultEnv.publishAggr(dataId, group, datumId, content);
    }

    public static boolean publishAggr(String dataId, String group, String datumId, String appName, String content) {
        return DiamondEnvRepo.defaultEnv.publishAggr(dataId, group, datumId, appName, content);
    }

    public static boolean remove(String dataId, String group) {
        return DiamondEnvRepo.defaultEnv.remove(dataId, group);
    }

    public static boolean removeAggr(String dataId, String group, String datumId) {
        return DiamondEnvRepo.defaultEnv.removeAggr(dataId, group, datumId);
    }

    public static DiamondEnv getTargetEnv(String ... serverIps) {
        return DiamondEnvRepo.getTargetEnv(serverIps);
    }

    public static DiamondEnv getTargetEnv(String host, int port) {
        return DiamondEnvRepo.getTargetEnv(host, port);
    }

    public static List<DiamondEnv> allDiamondEnvs() {
        return DiamondEnvRepo.allDiamondEnvs();
    }

    public static BatchHttpResult<ConfigInfoEx> batchQuery(List<String> dataIds, String group, long timeoutMs) {
        return DiamondEnvRepo.defaultEnv.batchQuery(dataIds, group, timeoutMs);
    }

    public static BatchHttpResult<ConfigInfoEx> batchGetConfig(List<String> dataIds, String group, long timeoutMs) {
        return DiamondEnvRepo.defaultEnv.batchGetConfig(dataIds, group, timeoutMs);
    }

    public static boolean batchRemoveAggr(String dataId, String group, List<String> datumIdList, long timeoutMs) throws IOException {
        return DiamondEnvRepo.defaultEnv.batchRemoveAggr(dataId, group, datumIdList, timeoutMs);
    }

    public static boolean batchPublishAggr(String dataId, String group, Map<String, String> datumMap, long timeoutMs) throws IOException {
        return DiamondEnvRepo.defaultEnv.batchPublishAggr(dataId, group, datumMap, timeoutMs);
    }

    public static boolean batchPublishAggr(String dataId, String group, Map<String, String> datumMap, String appName, long timeoutMs) throws IOException {
        return DiamondEnvRepo.defaultEnv.batchPublishAggr(dataId, group, datumMap, appName, timeoutMs);
    }

    public static boolean replaceAggr(String dataId, String group, Map<String, String> datumMap, long timeoutMs) throws IOException {
        return DiamondEnvRepo.defaultEnv.replaceAggr(dataId, group, datumMap, timeoutMs);
    }

    public static boolean replaceAggr(String dataId, String group, Map<String, String> datumMap, String appName, long timeoutMs) throws IOException {
        return DiamondEnvRepo.defaultEnv.replaceAggr(dataId, group, datumMap, appName, timeoutMs);
    }

    public static boolean publishBeta(String dataId, String group, String appName, String betaIps, String content) throws DiamondException {
        return DiamondEnvRepo.defaultEnv.publishBeta(dataId, group, appName, betaIps, content);
    }

    public static boolean publishBeta(String dataId, String group, String betaIps, String content) throws DiamondException {
        return DiamondEnvRepo.defaultEnv.publishBeta(dataId, group, betaIps, content);
    }

    public static ConfigInfo4Beta getBeta(String dataId, String group) throws DiamondException {
        return DiamondEnvRepo.defaultEnv.getBeta(dataId, group);
    }

    public static boolean stopBeta(String dataId, String group) throws DiamondException {
        return DiamondEnvRepo.defaultEnv.stopBeta(dataId, group);
    }

    public static boolean publishSingleTag(String dataId, String group, String tag, String content) throws DiamondException {
        return DiamondEnvRepo.defaultEnv.publishSingleTag(dataId, group, tag, content);
    }

    public static boolean removeTag(String dataId, String group, String tag) throws DiamondException {
        return DiamondEnvRepo.defaultEnv.removeTag(dataId, group, tag);
    }

    public static String getConfigTag(String dataId, String group, String tag, long timeoutMs) throws DiamondException {
        return DiamondEnvRepo.defaultEnv.getConfigTag(dataId, group, tag, timeoutMs);
    }
}

