/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.diamond.client.impl;

import com.taobao.diamond.client.impl.HttpSimpleClient;
import com.taobao.diamond.client.impl.ServerListManager;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.Iterator;
import java.util.List;

class ServerHttpAgent {
    public static final String appKey = System.getProperty("diamond.client.appKey", "");
    public static final String appName = System.getProperty("diamond.client.appName", "");
    final ServerListManager serverListMgr;
    volatile String currentServerIp;

    ServerHttpAgent(ServerListManager mgr) {
        this.serverListMgr = mgr;
    }

    public HttpSimpleClient.HttpResult httpGet(String path, List<String> headers, List<String> paramValues, String encoding, long readTimeoutMs) throws IOException {
        long endTime = System.currentTimeMillis() + readTimeoutMs;
        if (null != this.currentServerIp) {
            try {
                HttpSimpleClient.HttpResult result = HttpSimpleClient.httpGet(ServerHttpAgent.getUrl(this.currentServerIp, path), headers, paramValues, encoding, readTimeoutMs);
                return result;
            }
            catch (ConnectException ce) {
            }
            catch (SocketTimeoutException stoe) {
            }
            catch (IOException ioe) {
                throw ioe;
            }
        }
        Iterator<String> serverIter = this.serverListMgr.iterator();
        while (serverIter.hasNext()) {
            long timeout = endTime - System.currentTimeMillis();
            if (timeout <= 0L) {
                this.currentServerIp = serverIter.next();
                throw new IOException("timeout");
            }
            String ip = serverIter.next();
            try {
                HttpSimpleClient.HttpResult result = HttpSimpleClient.httpGet(ServerHttpAgent.getUrl(ip, path), headers, paramValues, encoding, timeout);
                this.currentServerIp = ip;
                return result;
            }
            catch (ConnectException ce) {
            }
            catch (SocketTimeoutException stoe) {
            }
            catch (IOException ioe) {
                throw ioe;
            }
        }
        throw new ConnectException("no available server");
    }

    public HttpSimpleClient.HttpResult httpPost(String path, List<String> headers, List<String> paramValues, String encoding, long readTimeoutMs) throws IOException {
        long endTime = System.currentTimeMillis() + readTimeoutMs;
        if (null != this.currentServerIp) {
            try {
                HttpSimpleClient.HttpResult result = HttpSimpleClient.httpPost(ServerHttpAgent.getUrl(this.currentServerIp, path), headers, paramValues, encoding, readTimeoutMs);
                return result;
            }
            catch (ConnectException ce) {
            }
            catch (SocketTimeoutException stoe) {
            }
            catch (IOException ioe) {
                throw ioe;
            }
        }
        Iterator<String> serverIter = this.serverListMgr.iterator();
        while (serverIter.hasNext()) {
            long timeout = endTime - System.currentTimeMillis();
            if (timeout <= 0L) {
                this.currentServerIp = serverIter.next();
                throw new IOException("timeout");
            }
            String ip = serverIter.next();
            try {
                HttpSimpleClient.HttpResult result = HttpSimpleClient.httpPost(ServerHttpAgent.getUrl(ip, path), headers, paramValues, encoding, timeout);
                this.currentServerIp = ip;
                return result;
            }
            catch (ConnectException ce) {
            }
            catch (SocketTimeoutException stoe) {
            }
            catch (IOException ioe) {
                throw ioe;
            }
        }
        throw new ConnectException("no available server");
    }

    static String getUrl(String ip, String relativePath) {
        return "http://" + ip + ":8080/diamond-server" + relativePath;
    }

    public void reSetCurrentServerIp() {
        if (this.currentServerIp != null) {
            this.currentServerIp = null;
        }
    }
}

