/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.diamond.client.impl;

import com.taobao.diamond.client.impl.IOUtils;
import com.taobao.diamond.client.impl.ServerHttpAgent;
import com.taobao.diamond.md5.MD5;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.List;

public class HttpSimpleClient {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResult httpGet(String url, List<String> headers, List<String> paramValues, String encoding, long readTimeoutMs) throws IOException {
        String encodedContent = HttpSimpleClient.encodingParams(paramValues, encoding);
        url = url + (null == encodedContent ? "" : "?" + encodedContent);
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(100);
            conn.setReadTimeout((int)readTimeoutMs);
            HttpSimpleClient.setHeaders(conn, headers, encoding);
            conn.connect();
            int respCode = conn.getResponseCode();
            String resp = null;
            resp = 200 == respCode ? IOUtils.toString(conn.getInputStream(), encoding) : IOUtils.toString(conn.getErrorStream(), encoding);
            HttpResult httpResult = new HttpResult(respCode, resp);
            return httpResult;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResult httpPost(String url, List<String> headers, List<String> paramValues, String encoding, long readTimeoutMs) throws IOException {
        String encodedContent = HttpSimpleClient.encodingParams(paramValues, encoding);
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setRequestMethod("POST");
            conn.setConnectTimeout(3000);
            conn.setReadTimeout((int)readTimeoutMs);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            HttpSimpleClient.setHeaders(conn, headers, encoding);
            conn.getOutputStream().write(encodedContent.getBytes());
            int respCode = conn.getResponseCode();
            String resp = null;
            resp = 200 == respCode ? IOUtils.toString(conn.getInputStream(), encoding) : IOUtils.toString(conn.getErrorStream(), encoding);
            HttpResult httpResult = new HttpResult(respCode, resp);
            return httpResult;
        }
        finally {
            if (null != conn) {
                conn.disconnect();
            }
        }
    }

    private static void setHeaders(HttpURLConnection conn, List<String> headers, String encoding) {
        if (null != headers) {
            Iterator<String> iter = headers.iterator();
            while (iter.hasNext()) {
                conn.addRequestProperty(iter.next(), iter.next());
            }
        }
        conn.addRequestProperty("Client-Version", "3.6.8");
        conn.addRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=" + encoding);
        String ts = String.valueOf(System.currentTimeMillis());
        String token = MD5.getInstance().getMD5String(ts + ServerHttpAgent.appKey);
        conn.addRequestProperty("Diamond-Client-AppName", ServerHttpAgent.appName);
        conn.addRequestProperty("Diamond-Client-RequestTS", ts);
        conn.addRequestProperty("Diamond-Client-RequestToken", token);
    }

    private static String encodingParams(List<String> paramValues, String encoding) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        if (null == paramValues) {
            return null;
        }
        Iterator<String> iter = paramValues.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next()).append("=");
            sb.append(URLEncoder.encode(iter.next(), encoding));
            if (!iter.hasNext()) continue;
            sb.append("&");
        }
        return sb.toString();
    }

    public static class HttpResult {
        public final int code;
        public final String content;

        public HttpResult(int code, String content) {
            this.code = code;
            this.content = content;
        }
    }
}

