/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.diamond.client.impl;

import com.taobao.diamond.client.BatchHttpResult;
import com.taobao.diamond.client.impl.CacheData;
import com.taobao.diamond.client.impl.ClientWorker;
import com.taobao.diamond.client.impl.HttpSimpleClient;
import com.taobao.diamond.client.impl.LocalConfigInfoProcessor;
import com.taobao.diamond.client.impl.ServerHttpAgent;
import com.taobao.diamond.client.impl.ServerListManager;
import com.taobao.diamond.common.Constants;
import com.taobao.diamond.common.GroupKey;
import com.taobao.diamond.domain.ConfigInfoEx;
import com.taobao.diamond.manager.ManagerListener;
import com.taobao.diamond.mockserver.MockServer;
import com.taobao.diamond.utils.ContentUtils;
import com.taobao.diamond.utils.JSONUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.codehaus.jackson.type.TypeReference;

public class DiamondEnv {
    public static final Logger log = Logger.getLogger(DiamondEnv.class);
    public static final long POST_TIMEOUT = 3000L;
    static final String selfIp;
    protected ServerListManager serverMgr;
    protected ServerHttpAgent agent;
    protected ClientWorker worker;
    private final AtomicReference<Map<String, CacheData>> cacheMap;

    public void addListeners(String dataId, String group, List<? extends ManagerListener> listeners) {
        group = this.null2defaultGroup(group);
        CacheData cache = this.addCacheDataIfAbsent(dataId, group);
        for (ManagerListener managerListener : listeners) {
            cache.addListener(managerListener);
        }
    }

    public void removeListener(String dataId, String group, ManagerListener listener) {
        CacheData cache = this.getCache(dataId, group = this.null2defaultGroup(group));
        if (null != cache) {
            cache.removeListener(listener);
            if (cache.getListeners().isEmpty()) {
                this.removeCache(dataId, group);
            }
        }
    }

    public List<ManagerListener> getListeners(String dataId, String group) {
        CacheData cache = this.getCache(dataId, group = this.null2defaultGroup(group));
        if (null == cache) {
            return Collections.emptyList();
        }
        return cache.getListeners();
    }

    public String getConfig(String dataId, String group, long timeoutMs) throws IOException {
        group = this.null2defaultGroup(group);
        if (MockServer.isTestMode()) {
            return MockServer.getConfigInfo(dataId, group, this);
        }
        String content = LocalConfigInfoProcessor.getFailover(this, dataId, group);
        if (content != null) {
            log.warn((Object)("[get-config] get failover ok, dataId=" + dataId + ", group=" + group + ", config=" + ContentUtils.truncateContent((String)content)));
            return content;
        }
        try {
            return ClientWorker.getServerConfig(this, dataId, group, timeoutMs);
        }
        catch (IOException ioe) {
            log.warn((Object)("[get-config] get server error, dataId:" + dataId + ", group\uff1a" + group + ", " + ioe.toString()));
            log.warn((Object)("[get-config] get snapshot, dataId:" + dataId + ", group\uff1a" + group));
            return LocalConfigInfoProcessor.getSnapshot(this, dataId, group);
        }
    }

    public String getConfig(String dataId, String group, int feature, long timeoutMs) throws IOException {
        if (feature == 1) {
            return this.getConfig(dataId, group, timeoutMs);
        }
        group = this.null2defaultGroup(group);
        if (MockServer.isTestMode()) {
            return MockServer.getConfigInfo(dataId, group, this);
        }
        String content = LocalConfigInfoProcessor.getFailover(this, dataId, group);
        if (content != null) {
            log.warn((Object)("[get-config] get failover ok, dataId=" + dataId + ", group=" + group + ", config=" + ContentUtils.truncateContent((String)content)));
            return content;
        }
        content = LocalConfigInfoProcessor.getSnapshot(this, dataId, group);
        if (StringUtils.isNotEmpty((String)content)) {
            log.warn((Object)("[get-config] get snapshot, dataId:" + dataId + ", group\uff1a" + group));
            return content;
        }
        return ClientWorker.getServerConfig(this, dataId, group, timeoutMs);
    }

    public boolean publishSingle(String dataId, String group, String content) {
        this.checkNotNull(dataId, content);
        group = this.null2defaultGroup(group);
        if (MockServer.isTestMode()) {
            MockServer.setConfigInfo(dataId, group, content, this);
            return true;
        }
        String url = "/basestone.do?method=syncUpdateAll";
        List<String> params = Arrays.asList("dataId", dataId, "group", group, "content", content);
        HttpSimpleClient.HttpResult result = null;
        try {
            result = this.agent.httpPost(url, null, params, "GBK", 3000L);
        }
        catch (IOException ioe) {
            log.warn((Object)("[publish-single] error, " + dataId + ", " + group + ", msg: " + ioe.toString()));
            return false;
        }
        if (200 == result.code) {
            log.info((Object)("[publish-single] ok. " + dataId + ", " + group));
            return true;
        }
        log.warn((Object)("[publish-single] error, " + dataId + ", " + group + ", error code: " + result.code + ", " + result.content));
        return false;
    }

    public boolean publishAggr(String dataId, String group, String datumId, String content) {
        this.checkNotNull(dataId, datumId, content);
        group = this.null2defaultGroup(group);
        String url = "/datum.do?method=addDatum";
        List<String> params = Arrays.asList("dataId", dataId, "group", group, "datumId", datumId, "content", content);
        HttpSimpleClient.HttpResult result = null;
        try {
            result = this.agent.httpPost(url, null, params, "GBK", 3000L);
        }
        catch (IOException ioe) {
            log.warn((Object)("[publish-aggr] error, " + dataId + ", " + group + ", " + datumId + ", msg: " + ioe.toString()));
            return false;
        }
        if (200 == result.code) {
            log.info((Object)("[publish-aggr] ok. " + dataId + ", " + group + ", " + datumId));
            return true;
        }
        log.warn((Object)("[publish-aggr] error, " + dataId + ", " + group + ", " + datumId + ", error code: " + result.code + ", " + result.content));
        return false;
    }

    public boolean removeAggr(String dataId, String group, String datumId) {
        this.checkNotNull(dataId, datumId);
        group = this.null2defaultGroup(group);
        String url = "/datum.do?method=deleteDatum";
        List<String> params = Arrays.asList("dataId", dataId, "group", group, "datumId", datumId);
        HttpSimpleClient.HttpResult result = null;
        try {
            result = this.agent.httpPost(url, null, params, "GBK", 3000L);
        }
        catch (IOException ioe) {
            log.warn((Object)("[remove-aggr] error, " + dataId + ", " + group + ", " + datumId + ", msg: " + ioe.toString()));
            return false;
        }
        if (200 == result.code) {
            log.info((Object)("[remove-aggr] ok. " + dataId + ", " + group + ", " + datumId));
            return true;
        }
        log.warn((Object)("[remove-aggr] error, " + dataId + ", " + group + ", " + datumId + ", error code: " + result.code + ", " + result.content));
        return false;
    }

    public boolean remove(String dataId, String group) {
        this.checkNotNull(dataId);
        group = this.null2defaultGroup(group);
        if (MockServer.isTestMode()) {
            MockServer.removeConfigInfo(dataId, group, this);
            return true;
        }
        String url = "/datum.do?method=deleteAllDatums";
        List<String> params = Arrays.asList("dataId", dataId, "group", group);
        HttpSimpleClient.HttpResult result = null;
        try {
            result = this.agent.httpPost(url, null, params, "GBK", 3000L);
        }
        catch (IOException ioe) {
            log.warn((Object)("[remove] error, " + dataId + ", " + group + ", msg: " + ioe.toString()));
            return false;
        }
        if (200 == result.code) {
            log.info((Object)("[remove] ok. " + dataId + ", " + group));
            return true;
        }
        log.warn((Object)("[remove] error, " + dataId + ", " + group + ", error code: " + result.code + ", " + result.content));
        return false;
    }

    public List<String> getServerUrls() {
        return new ArrayList<String>(this.serverMgr.serverUrls);
    }

    private void checkNotNull(String ... params) {
        for (String param : params) {
            if (!StringUtils.isBlank((String)param)) continue;
            throw new IllegalArgumentException("param cannot be blank");
        }
    }

    private String null2defaultGroup(String group) {
        return null == group ? "DEFAULT_GROUP" : group.trim();
    }

    public BatchHttpResult<ConfigInfoEx> batchGetConfig(List<String> dataIds, String group, long timeoutMs) {
        if (dataIds == null) {
            throw new IllegalArgumentException("dataId list is null when batch get config");
        }
        group = this.null2defaultGroup(group);
        if (MockServer.isTestMode()) {
            List<ConfigInfoEx> result = MockServer.batchQuery(dataIds, group, this);
            BatchHttpResult<ConfigInfoEx> response = new BatchHttpResult<ConfigInfoEx>(true, 200, "", "mock server");
            response.getResult().addAll(result);
            return response;
        }
        StringBuilder dataIdstr = new StringBuilder();
        String split = "";
        for (String dataId : dataIds) {
            dataIdstr.append(split);
            dataIdstr.append(dataId);
            split = Constants.WORD_SEPARATOR;
        }
        String url = "/config.co?method=batchGetConfig";
        List<String> params = Arrays.asList("dataIds", dataIdstr.toString(), "group", group);
        HttpSimpleClient.HttpResult result = null;
        try {
            result = this.agent.httpPost(url, null, params, "GBK", timeoutMs);
        }
        catch (IOException ioe) {
            log.warn((Object)("[batch-get-config] error, " + dataIds + ", " + group), (Throwable)ioe);
            return new BatchHttpResult<ConfigInfoEx>(false, -1, "batch get config io exception:" + ioe.getMessage(), "");
        }
        BatchHttpResult<ConfigInfoEx> response = new BatchHttpResult<ConfigInfoEx>(true, result.code, "", result.content);
        if (result.code == 200) {
            response.setSuccess(true);
            response.setStatusMsg("batch get config success");
            log.info((Object)("[batch-get-config] success, ,dataIds=" + dataIds + ",group=" + group));
        } else {
            response.setSuccess(false);
            response.setStatusMsg("batch get config fail, status:" + result.code);
            log.error((Object)("[batch-get-config] fail, status:" + result.code + ",dataIds=" + dataIds + ",group=" + group));
        }
        if (200 == result.code || 412 == result.code) {
            try {
                String json = result.content;
                Object resultObj = JSONUtils.deserializeObject((String)json, (TypeReference)new TypeReference<List<ConfigInfoEx>>(){});
                response.getResult().addAll((List)resultObj);
            }
            catch (Exception e) {
                response.setSuccess(false);
                response.setStatusMsg("batch get config deserialize error");
                log.error((Object)("[batch-get-config] deserialize error, ,dataIds=" + dataIds + ",group=" + group), (Throwable)e);
            }
        }
        return response;
    }

    public BatchHttpResult<ConfigInfoEx> batchQuery(List<String> dataIds, String group, long timeoutMs) {
        BatchHttpResult<ConfigInfoEx> response = new BatchHttpResult<ConfigInfoEx>();
        if (dataIds == null) {
            throw new IllegalArgumentException("dataId list is null when batch query");
        }
        group = this.null2defaultGroup(group);
        if (MockServer.isTestMode()) {
            List<ConfigInfoEx> result = MockServer.batchQuery(dataIds, group, this);
            response.setStatusCode(200);
            response.setResponseMsg("mock server");
            response.setSuccess(true);
            response.getResult().addAll(result);
            return response;
        }
        StringBuilder dataIdstr = new StringBuilder();
        String split = "";
        for (String dataId : dataIds) {
            dataIdstr.append(split);
            dataIdstr.append(dataId);
            split = Constants.WORD_SEPARATOR;
        }
        String url = "/admin.do?method=batchQuery";
        List<String> params = Arrays.asList("dataIds", dataIdstr.toString(), "group", group);
        HttpSimpleClient.HttpResult result = null;
        try {
            result = this.agent.httpPost(url, null, params, "GBK", timeoutMs);
        }
        catch (IOException ioe) {
            log.warn((Object)("[batch-query] error, " + dataIds + ", " + group), (Throwable)ioe);
            response.setSuccess(false);
            response.setStatusMsg("batch query io exception\uff1a" + ioe.getMessage());
            return response;
        }
        response.setStatusCode(result.code);
        response.setResponseMsg(result.content);
        if (200 == result.code || 412 == result.code) {
            try {
                String json = result.content;
                Object resultObj = JSONUtils.deserializeObject((String)json, (TypeReference)new TypeReference<List<ConfigInfoEx>>(){});
                response.setSuccess(true);
                response.getResult().addAll((List)resultObj);
                log.info((Object)("batch query success, ,dataIds=" + dataIds + ",group=" + group));
            }
            catch (Exception e) {
                response.setSuccess(false);
                response.setStatusMsg("batch query deserialize error");
                log.error((Object)("batch query deserialize error, ,dataIds=" + dataIds + ",group=" + group), (Throwable)e);
            }
        } else {
            response.setSuccess(false);
            response.setStatusMsg("batch query fail, status:" + result.code);
            log.error((Object)("batch query fail, status:" + result.code + ",dataIds=" + dataIds + ",group=" + group));
            return response;
        }
        return response;
    }

    CacheData getCache(String dataId, String group) {
        if (null == dataId || null == group) {
            throw new IllegalArgumentException();
        }
        return this.cacheMap.get().get(GroupKey.getKey((String)dataId, (String)group));
    }

    List<CacheData> getAllCacheDataSnapshot() {
        return new ArrayList<CacheData>(this.cacheMap.get().values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCache(String dataId, String group) {
        String groupKey = GroupKey.getKey((String)dataId, (String)group);
        AtomicReference<Map<String, CacheData>> atomicReference = this.cacheMap;
        synchronized (atomicReference) {
            HashMap<String, CacheData> copy = new HashMap<String, CacheData>(this.cacheMap.get());
            copy.remove(groupKey);
            this.cacheMap.set(copy);
        }
        log.info((Object)("[unsubscribe] " + groupKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheData addCacheDataIfAbsent(String dataId, String group) {
        CacheData cache = this.getCache(dataId, group);
        if (null != cache) {
            return cache;
        }
        AtomicReference<Map<String, CacheData>> atomicReference = this.cacheMap;
        synchronized (atomicReference) {
            String key = GroupKey.getKey((String)dataId, (String)group);
            cache = new CacheData(dataId, group);
            HashMap<String, CacheData> copy = new HashMap<String, CacheData>(this.cacheMap.get());
            copy.put(key, cache);
            this.cacheMap.set(copy);
            log.info((Object)("[subscribe] " + key));
        }
        String content = LocalConfigInfoProcessor.getFailover(this, dataId, group);
        content = null != content ? content : LocalConfigInfoProcessor.getSnapshot(this, dataId, group);
        cache.setContent(content);
        return cache;
    }

    public Set<String> getSubscribeDataIds() {
        Map<String, CacheData> cacheMapSnapshot = this.cacheMap.get();
        HashSet<String> dataIds = new HashSet<String>(cacheMapSnapshot.size());
        for (CacheData cache : cacheMapSnapshot.values()) {
            dataIds.add(cache.dataId);
        }
        return dataIds;
    }

    public String toString() {
        return "DiamondEnv-" + this.serverMgr.toString();
    }

    public ServerListManager getServerMgr() {
        return this.serverMgr;
    }

    public void initServerManager(ServerListManager _serverMgr) {
        _serverMgr.setEnv(this);
        this.serverMgr = _serverMgr;
        this.serverMgr.start();
        this.agent = new ServerHttpAgent(this.serverMgr);
    }

    public DiamondEnv(String ... serverIps) {
        this(new ServerListManager(Arrays.asList(serverIps)));
    }

    protected DiamondEnv(ServerListManager serverListMgr) {
        this.initServerManager(serverListMgr);
        this.cacheMap = new AtomicReference(new HashMap());
        this.worker = new ClientWorker(this);
    }

    static {
        String tmp = null;
        try {
            tmp = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        selfIp = tmp;
    }
}

