/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.diamond.client;

import com.taobao.diamond.client.BatchHttpResult;
import com.taobao.diamond.client.impl.DiamondEnv;
import com.taobao.diamond.client.impl.DiamondEnvRepo;
import com.taobao.diamond.client.impl.LocalConfigInfoProcessor;
import com.taobao.diamond.domain.ConfigInfoEx;
import com.taobao.diamond.manager.ManagerListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.DailyRollingFileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;

public class Diamond {
    public static void addListener(String dataId, String group, ManagerListener listener) {
        DiamondEnvRepo.defaultEnv.addListeners(dataId, group, Arrays.asList(listener));
    }

    public static void addListeners(String dataId, String group, List<ManagerListener> listeners) {
        DiamondEnvRepo.defaultEnv.addListeners(dataId, group, listeners);
    }

    public static void removeListener(String dataId, String group, ManagerListener listener) {
        DiamondEnvRepo.defaultEnv.removeListener(dataId, group, listener);
    }

    public static List<ManagerListener> getListeners(String dataId, String group) {
        return DiamondEnvRepo.defaultEnv.getListeners(dataId, group);
    }

    public static String getConfig(String dataId, String group, long timeoutMs) throws IOException {
        return DiamondEnvRepo.defaultEnv.getConfig(dataId, group, timeoutMs);
    }

    public static String getConfig(String dataId, String group, int feature, long timeoutMs) throws IOException {
        return DiamondEnvRepo.defaultEnv.getConfig(dataId, group, feature, timeoutMs);
    }

    public static boolean publishSingle(String dataId, String group, String content) {
        return DiamondEnvRepo.defaultEnv.publishSingle(dataId, group, content);
    }

    public static boolean publishAggr(String dataId, String group, String datumId, String content) {
        return DiamondEnvRepo.defaultEnv.publishAggr(dataId, group, datumId, content);
    }

    public static boolean remove(String dataId, String group) {
        return DiamondEnvRepo.defaultEnv.remove(dataId, group);
    }

    public static boolean removeAggr(String dataId, String group, String datumId) {
        return DiamondEnvRepo.defaultEnv.removeAggr(dataId, group, datumId);
    }

    public static DiamondEnv getTargetEnv(String ... serverIps) {
        return DiamondEnvRepo.getTargetEnv(serverIps);
    }

    public static List<DiamondEnv> allDiamondEnvs() {
        return DiamondEnvRepo.allDiamondEnvs();
    }

    public static BatchHttpResult<ConfigInfoEx> batchQuery(List<String> dataIds, String group, long timeoutMs) {
        return DiamondEnvRepo.defaultEnv.batchQuery(dataIds, group, timeoutMs);
    }

    public static BatchHttpResult<ConfigInfoEx> batchGetConfig(List<String> dataIds, String group, long timeoutMs) {
        return DiamondEnvRepo.defaultEnv.batchGetConfig(dataIds, group, timeoutMs);
    }

    private static void initLog() throws Exception {
        String logPath = LocalConfigInfoProcessor.getLogFile();
        System.out.println("diamond client log path : " + new File(logPath).getAbsolutePath());
        DailyRollingFileAppender appender = new DailyRollingFileAppender();
        appender.setAppend(true);
        appender.setEncoding("GBK");
        appender.setFile(logPath);
        appender.setLayout((Layout)new PatternLayout("%d %-5p - %m%n%n"));
        appender.activateOptions();
        DiamondEnv.log.setLevel(Level.INFO);
        DiamondEnv.log.setAdditivity(false);
        DiamondEnv.log.addAppender((Appender)appender);
    }

    private static void checkSnapshotValidity() {
        List<String> localServerlist = LocalConfigInfoProcessor.readServerlist(DiamondEnvRepo.defaultEnv);
        List<String> apacheServerlist = DiamondEnvRepo.defaultEnv.getServerUrls();
        DiamondEnv.log.info((Object)("[apache-urls] " + apacheServerlist));
        DiamondEnv.log.info((Object)("[cache-urls] " + localServerlist));
        boolean isNotChange = ((Object)apacheServerlist).equals(localServerlist);
        if (isNotChange) {
            DiamondEnv.log.info((Object)"########## environment ok.");
        } else {
            DiamondEnv.log.warn((Object)"########## environment changed. clear cache.");
            LocalConfigInfoProcessor.cleanAllSnapshot();
            LocalConfigInfoProcessor.saveServerlist(DiamondEnvRepo.defaultEnv, apacheServerlist);
        }
    }

    static {
        try {
            Diamond.initLog();
            Diamond.checkSnapshotValidity();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

