/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.common;

import com.taobao.arthas.common.ExecutingCommand;
import com.taobao.arthas.common.OSUtils;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.List;
import javax.net.ServerSocketFactory;

public class SocketUtils {
    public static int findTcpListenProcess(int port) {
        try {
            String pid;
            if (OSUtils.isWindows()) {
                String[] command = new String[]{"netstat", "-ano", "-p", "TCP"};
                List<String> lines = ExecutingCommand.runNative(command);
                for (String line : lines) {
                    String[] strings;
                    if (!line.contains("LISTENING") || (strings = line.trim().split("\\s+")).length != 5 || !strings[1].endsWith(":" + port)) continue;
                    return Integer.parseInt(strings[4]);
                }
            }
            if ((OSUtils.isLinux() || OSUtils.isMac()) && !(pid = ExecutingCommand.getFirstAnswer("lsof -t -s TCP:LISTEN -i TCP:" + port)).trim().isEmpty()) {
                return Integer.parseInt(pid);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return -1;
    }

    public static boolean isTcpPortAvailable(int port) {
        try {
            ServerSocket serverSocket = ServerSocketFactory.getDefault().createServerSocket(port, 1, InetAddress.getByName("localhost"));
            serverSocket.close();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

