/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.boot;

import com.taobao.arthas.common.AnsiLog;
import com.taobao.arthas.common.ExecutingCommand;
import com.taobao.arthas.common.IOUtils;
import com.taobao.arthas.common.JavaVersionUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;

public class ProcessUtils {
    private static String PID = "-1";

    public static String getPid() {
        return PID;
    }

    public static int select(boolean v) {
        Map<Integer, String> processMap = ProcessUtils.listProcessByJps(v);
        if (processMap.isEmpty()) {
            AnsiLog.info((String)"Can not find java process. Try to pass pid in command line.");
            return -1;
        }
        int count = 1;
        for (String process : processMap.values()) {
            if (count == 1) {
                System.out.println("* [" + count + "]: " + process);
            } else {
                System.out.println("  [" + count + "]: " + process);
            }
            ++count;
        }
        String line = new Scanner(System.in).nextLine();
        if (line.trim().isEmpty()) {
            return processMap.keySet().iterator().next();
        }
        int choice = new Scanner(line).nextInt();
        if (choice <= 0 || choice > processMap.size()) {
            return -1;
        }
        Iterator<Integer> idIter = processMap.keySet().iterator();
        for (int i = 1; i <= choice; ++i) {
            if (i == choice) {
                return idIter.next();
            }
            idIter.next();
        }
        return -1;
    }

    private static Map<Integer, String> listProcessByJps(boolean v) {
        LinkedHashMap<Integer, String> result = new LinkedHashMap<Integer, String>();
        String jps = "jps";
        File jpsFile = ProcessUtils.findJps();
        if (jpsFile != null) {
            jps = jpsFile.getAbsolutePath();
        }
        String[] command = null;
        command = v ? new String[]{jps, "-v"} : new String[]{jps};
        List lines = ExecutingCommand.runNative((String[])command);
        int currentPid = Integer.parseInt(ProcessUtils.getPid());
        for (String line : lines) {
            int pid;
            String[] strings = line.trim().split("\\s+");
            if (strings.length < 1 || (pid = Integer.parseInt(strings[0])) == currentPid || strings.length >= 2 && strings[1].equals("Jps")) continue;
            result.put(pid, line);
        }
        return result;
    }

    public static void startArthasCore(int targetPid, List<String> attachArgs) {
        String javaHome = System.getProperty("java.home");
        File javaPath = ProcessUtils.findJava();
        if (javaPath == null) {
            throw new IllegalArgumentException("Can not find java/java.exe executable file under java home: " + javaHome);
        }
        File toolsJar = new File(javaHome, "../lib/tools.jar");
        if (!toolsJar.exists()) {
            toolsJar = new File(javaHome, "../../lib/tools.jar");
        }
        if (JavaVersionUtils.isLessThanJava9() && !toolsJar.exists()) {
            throw new IllegalArgumentException("Can not find tools.jar under java home: " + javaHome);
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(javaPath.getAbsolutePath());
        if (toolsJar.exists()) {
            command.add("-Xbootclasspath/a:" + toolsJar.getAbsolutePath());
        }
        command.addAll(attachArgs);
        ProcessBuilder pb = new ProcessBuilder(command);
        try {
            final Process proc = pb.start();
            Thread redirectStdout = new Thread(new Runnable(){

                @Override
                public void run() {
                    InputStream inputStream = proc.getInputStream();
                    try {
                        IOUtils.copy((InputStream)inputStream, (OutputStream)System.out);
                    }
                    catch (IOException e) {
                        IOUtils.close((InputStream)inputStream);
                    }
                }
            });
            Thread redirectStderr = new Thread(new Runnable(){

                @Override
                public void run() {
                    InputStream inputStream = proc.getErrorStream();
                    try {
                        IOUtils.copy((InputStream)inputStream, (OutputStream)System.err);
                    }
                    catch (IOException e) {
                        IOUtils.close((InputStream)inputStream);
                    }
                }
            });
            redirectStdout.start();
            redirectStderr.start();
            redirectStdout.join();
            redirectStderr.join();
            int exitValue = proc.exitValue();
            if (exitValue != 0) {
                AnsiLog.error((String)("attach fail, targetPid: " + targetPid));
                System.exit(1);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static File findJava() {
        String[] paths;
        String javaHome = System.getProperty("java.home");
        for (String path : paths = new String[]{"bin/java", "bin/java.exe", "../bin/java", "../bin/java.exe"}) {
            File jpsFile = new File(javaHome, path);
            if (!jpsFile.exists()) continue;
            return jpsFile;
        }
        AnsiLog.debug((String)("can not find java under current java home: " + javaHome));
        return null;
    }

    private static File findJps() {
        String[] paths;
        String javaHome = System.getProperty("java.home");
        for (String path : paths = new String[]{"bin/jps", "bin/jps.exe", "../bin/jps", "../bin/jps.exe"}) {
            File jpsFile = new File(javaHome, path);
            if (!jpsFile.exists()) continue;
            return jpsFile;
        }
        AnsiLog.debug((String)("can not find jps under current java home: " + javaHome));
        return null;
    }

    static {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        int index = jvmName.indexOf(64);
        if (index > 0) {
            try {
                PID = Long.toString(Long.parseLong(jvmName.substring(0, index)));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

