/*
 * Decompiled with CFR 0.152.
 */
package com.swoval.files;

import com.swoval.files.DirectoryDataView;
import com.swoval.files.DirectoryRegistry;
import com.swoval.files.DirectoryRegistryImpl;
import com.swoval.files.Entries;
import com.swoval.files.FileTreeDataViews;
import com.swoval.files.FileTreeViews;
import com.swoval.files.MapOps;
import com.swoval.files.Observers;
import com.swoval.files.PathWatcher;
import com.swoval.files.PathWatchers;
import com.swoval.files.PeriodicTask;
import com.swoval.files.TypedPath;
import com.swoval.files.TypedPaths;
import com.swoval.functional.Either;
import com.swoval.functional.Filters;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

class PollingPathWatcher
implements PathWatcher<PathWatchers.Event> {
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final boolean followLinks;
    private final DirectoryRegistry registry = new DirectoryRegistryImpl();
    private final Observers<PathWatchers.Event> observers = new Observers();
    private Map<Path, FileTreeDataViews.Entry<Long>> oldEntries;
    private final PeriodicTask periodicTask;
    private final FileTreeDataViews.Converter<Long> converter;

    PollingPathWatcher(FileTreeDataViews.Converter<Long> converter, boolean bl, long l, TimeUnit timeUnit) throws InterruptedException {
        this.converter = converter;
        this.followLinks = bl;
        this.oldEntries = this.getEntries();
        this.periodicTask = new PeriodicTask(new PollingRunnable(), timeUnit.toMillis(l));
    }

    PollingPathWatcher(boolean bl, long l, TimeUnit timeUnit) throws InterruptedException {
        this(new FileTreeDataViews.Converter<Long>(){

            @Override
            public Long apply(TypedPath typedPath) {
                try {
                    return Files.getLastModifiedTime(typedPath.getPath(), new LinkOption[0]).toMillis();
                }
                catch (Exception exception) {
                    return 0L;
                }
            }
        }, bl, l, timeUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Either<IOException, Boolean> register(Path path, int n) {
        boolean bl;
        Path path2 = path.isAbsolute() ? path : path.toAbsolutePath();
        List<FileTreeDataViews.Entry<Long>> list = this.getEntries(path2, n);
        PollingPathWatcher pollingPathWatcher = this;
        synchronized (pollingPathWatcher) {
            this.addAll(this.oldEntries, list);
            bl = this.registry.addDirectory(path2, n);
        }
        return Either.right(bl);
    }

    @Override
    public void unregister(Path path) {
        Path path2 = path.isAbsolute() ? path : path.toAbsolutePath();
        this.registry.removeDirectory(path2);
    }

    @Override
    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            this.registry.close();
            try {
                this.periodicTask.close();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace(System.err);
            }
        }
    }

    @Override
    public int addObserver(FileTreeViews.Observer<? super PathWatchers.Event> observer) {
        return this.observers.addObserver(observer);
    }

    @Override
    public void removeObserver(int n) {
        this.observers.removeObserver(n);
    }

    private void addAll(Map<Path, FileTreeDataViews.Entry<Long>> map, List<FileTreeDataViews.Entry<Long>> list) {
        for (FileTreeDataViews.Entry<Long> entry : list) {
            map.put(entry.getTypedPath().getPath(), entry);
        }
    }

    private List<FileTreeDataViews.Entry<Long>> getEntries(Path path, int n) {
        try {
            DirectoryDataView<Long> directoryDataView = FileTreeDataViews.cached(path, this.converter, n, this.followLinks);
            List<FileTreeDataViews.Entry<Long>> list = directoryDataView.listEntries(n, Filters.AllPass);
            List<FileTreeDataViews.Entry<Long>> list2 = directoryDataView.listEntries(-1, Filters.AllPass);
            if (list2.size() == 1) {
                list.add(list2.get(0));
            }
            return list;
        }
        catch (NotDirectoryException notDirectoryException) {
            ArrayList<FileTreeDataViews.Entry<Long>> arrayList = new ArrayList<FileTreeDataViews.Entry<Long>>();
            TypedPath typedPath = TypedPaths.get(path);
            arrayList.add(Entries.get(typedPath, this.converter, typedPath));
            return arrayList;
        }
        catch (IOException iOException) {
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Path, FileTreeDataViews.Entry<Long>> getEntries() {
        ConcurrentHashMap<Path, Integer> concurrentHashMap = new ConcurrentHashMap<Path, Integer>();
        Object object = this;
        synchronized (object) {
            concurrentHashMap.putAll(this.registry.registered());
        }
        object = concurrentHashMap.entrySet().iterator();
        ConcurrentHashMap<Path, FileTreeDataViews.Entry<Long>> concurrentHashMap2 = new ConcurrentHashMap<Path, FileTreeDataViews.Entry<Long>>();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            List<FileTreeDataViews.Entry<Long>> list = this.getEntries((Path)entry.getKey(), (Integer)entry.getValue());
            this.addAll(concurrentHashMap2, list);
        }
        return concurrentHashMap2;
    }

    private class PollingRunnable
    implements Runnable {
        final FileTreeDataViews.CacheObserver<Long> cacheObserver = new FileTreeDataViews.CacheObserver<Long>(){

            @Override
            public void onCreate(FileTreeDataViews.Entry<Long> entry) {
                PollingPathWatcher.this.observers.onNext(new PathWatchers.Event(entry.getTypedPath(), PathWatchers.Event.Kind.Create));
            }

            @Override
            public void onDelete(FileTreeDataViews.Entry<Long> entry) {
                PollingPathWatcher.this.observers.onNext(new PathWatchers.Event(entry.getTypedPath(), PathWatchers.Event.Kind.Delete));
            }

            @Override
            public void onUpdate(FileTreeDataViews.Entry<Long> entry, FileTreeDataViews.Entry<Long> entry2) {
                if (!entry.getValue().equals(entry2.getValue())) {
                    PollingPathWatcher.this.observers.onNext(new PathWatchers.Event(entry2.getTypedPath(), PathWatchers.Event.Kind.Modify));
                }
            }

            @Override
            public void onError(IOException iOException) {
                PollingPathWatcher.this.observers.onError(iOException);
            }
        };

        private PollingRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Map map = PollingPathWatcher.this.getEntries();
            MapOps.diffDirectoryEntries(PollingPathWatcher.this.oldEntries, map, this.cacheObserver);
            PollingRunnable pollingRunnable = this;
            synchronized (pollingRunnable) {
                PollingPathWatcher.this.oldEntries = map;
            }
        }
    }
}

