/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IOUtil {
    public static int BUFFER_SIZE = 8192;

    public static void copy(InputStream in, OutputStream out) throws IOException {
        IOUtil.copy(in, out, -1L);
    }

    public static void copy(InputStream in, OutputStream out, long count) throws IOException {
        IOUtil.copy(in, out, count, BUFFER_SIZE);
    }

    public static void copy(InputStream in, OutputStream out, long count, int bufferSize) throws IOException {
        byte[] buffer = new byte[bufferSize];
        int i = bufferSize;
        if (count >= 0L) {
            while (count > 0L && (i = count < (long)bufferSize ? in.read(buffer, 0, (int)count) : in.read(buffer, 0, bufferSize)) != -1) {
                count -= (long)i;
                out.write(buffer, 0, i);
            }
        } else {
            while ((i = in.read(buffer, 0, bufferSize)) >= 0) {
                out.write(buffer, 0, i);
            }
        }
    }

    public static boolean closeStream(InputStream in) {
        try {
            if (in != null) {
                in.close();
            }
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public static boolean closeStream(OutputStream out) {
        try {
            if (out != null) {
                out.close();
            }
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public static boolean delTree(File file) {
        if (file.isFile()) {
            return file.delete();
        }
        String[] list = file.list();
        for (int i = 0; i < list.length; ++i) {
            if (IOUtil.delTree(new File(file, list[i]))) continue;
            return false;
        }
        return true;
    }

    public static void recurseDeleteDirectory(File dir) {
        String[] files = dir.list();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File f = new File(dir, files[i]);
            if (f.isDirectory()) {
                IOUtil.recurseDeleteDirectory(f);
            }
            f.delete();
        }
        dir.delete();
    }

    public static void copyFile(File from, File to) throws IOException {
        if (from.isDirectory()) {
            if (!to.exists()) {
                to.mkdir();
            }
            String[] children = from.list();
            for (int i = 0; i < children.length; ++i) {
                File f = new File(from, children[i]);
                if (f.getName().equals(".") || f.getName().equals("..")) continue;
                if (f.isDirectory()) {
                    File f2 = new File(to, f.getName());
                    IOUtil.copyFile(f, f2);
                    continue;
                }
                IOUtil.copyFile(f, to);
            }
        } else if (from.isFile() && (to.isDirectory() || to.isFile())) {
            int read;
            if (to.isDirectory()) {
                to = new File(to, from.getName());
            }
            FileInputStream in = new FileInputStream(from);
            FileOutputStream out = new FileOutputStream(to);
            byte[] buf = new byte[32678];
            while ((read = in.read(buf)) > -1) {
                out.write(buf, 0, read);
            }
            IOUtil.closeStream(in);
            IOUtil.closeStream(out);
        }
    }
}

