/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.ssh2;

import com.sshtools.events.Event;
import com.sshtools.events.EventServiceImplementation;
import com.sshtools.logging.Log;
import com.sshtools.ssh.ChannelAdapter;
import com.sshtools.ssh.PseudoTerminalModes;
import com.sshtools.ssh.SshChannel;
import com.sshtools.ssh.SshClient;
import com.sshtools.ssh.SshException;
import com.sshtools.ssh.SshSession;
import com.sshtools.ssh.message.SshChannelMessage;
import com.sshtools.ssh.message.SshMessage;
import com.sshtools.ssh2.Ssh2Channel;
import com.sshtools.ssh2.Ssh2Client;
import com.sshtools.util.ByteArrayReader;
import com.sshtools.util.ByteArrayWriter;
import java.io.IOException;
import java.io.InputStream;

public class Ssh2Session
extends Ssh2Channel
implements SshSession {
    static final int SSH_EXTENDED_DATA_STDERR = 1;
    Ssh2Channel.ChannelInputStream stderr;
    boolean flowControlEnabled = false;
    int exitcode = Integer.MIN_VALUE;
    String exitsignalinfo = "";
    Ssh2Client client;

    public Ssh2Session(int windowsize, int packetsize, Ssh2Client client) {
        super("session", windowsize, packetsize);
        this.client = client;
        this.stderr = this.createExtendedDataStream();
    }

    public SshClient getClient() {
        return this.client;
    }

    protected void processExtendedData(int typecode, int length, SshChannelMessage msg) throws SshException {
        super.processExtendedData(typecode, length, msg);
        if (typecode == 1) {
            this.stderr.addMessage(length, msg);
        }
    }

    public InputStream getStderrInputStream() {
        return this.stderr;
    }

    public boolean requestPseudoTerminal(String term, int cols, int rows, int width, int height) throws SshException {
        return this.requestPseudoTerminal(term, cols, rows, width, height, new byte[]{0});
    }

    public boolean requestPseudoTerminal(String term, int cols, int rows, int width, int height, PseudoTerminalModes terminalModes) throws SshException {
        return this.requestPseudoTerminal(term, cols, rows, width, height, terminalModes.toByteArray());
    }

    public boolean requestPseudoTerminal(String term, int cols, int rows, int width, int height, byte[] modes) throws SshException {
        ByteArrayWriter request = new ByteArrayWriter();
        try {
            request.writeString(term);
            request.writeInt(cols);
            request.writeInt(rows);
            request.writeInt(width);
            request.writeInt(height);
            request.writeBinaryString(modes);
            boolean bl = this.sendRequest("pty-req", true, request.toByteArray());
            return bl;
        }
        catch (IOException ex) {
            throw new SshException(ex, 5);
        }
        finally {
            try {
                request.close();
            }
            catch (IOException iOException) {}
        }
    }

    public boolean startShell() throws SshException {
        boolean success;
        if (Log.isDebugEnabled()) {
            this.addChannelEventListener(new CommandLogger());
        }
        if (success = this.sendRequest("shell", true, null)) {
            EventServiceImplementation.getInstance().fireEvent(new Event(this, 23, true));
        } else {
            EventServiceImplementation.getInstance().fireEvent(new Event(this, 24, false));
        }
        return success;
    }

    public boolean executeCommand(String cmd) throws SshException {
        if (Log.isDebugEnabled()) {
            this.addChannelEventListener(new CommandLogger());
        }
        ByteArrayWriter request = new ByteArrayWriter();
        try {
            request.writeString(cmd);
            boolean success = this.sendRequest("exec", true, request.toByteArray());
            if (success) {
                EventServiceImplementation.getInstance().fireEvent(new Event(this, 30, true).addAttribute("COMMAND", cmd));
            } else {
                EventServiceImplementation.getInstance().fireEvent(new Event(this, 30, false).addAttribute("COMMAND", cmd));
            }
            boolean bl = success;
            return bl;
        }
        catch (IOException ex) {
            throw new SshException(ex, 5);
        }
        finally {
            try {
                request.close();
            }
            catch (IOException iOException) {}
        }
    }

    public boolean executeCommand(String cmd, String charset) throws SshException {
        ByteArrayWriter request = new ByteArrayWriter();
        try {
            request.writeString(cmd, charset);
            boolean success = this.sendRequest("exec", true, request.toByteArray());
            if (success) {
                EventServiceImplementation.getInstance().fireEvent(new Event(this, 30, true).addAttribute("COMMAND", cmd));
            } else {
                EventServiceImplementation.getInstance().fireEvent(new Event(this, 30, false).addAttribute("COMMAND", cmd));
            }
            boolean bl = success;
            return bl;
        }
        catch (IOException ex) {
            throw new SshException(ex, 5);
        }
        finally {
            try {
                request.close();
            }
            catch (IOException iOException) {}
        }
    }

    public boolean startSubsystem(String subsystem) throws SshException {
        ByteArrayWriter request = new ByteArrayWriter();
        try {
            request.writeString(subsystem);
            boolean success = this.sendRequest("subsystem", true, request.toByteArray());
            if (success) {
                EventServiceImplementation.getInstance().fireEvent(new Event(this, 1001, true).addAttribute("COMMAND", subsystem));
            } else {
                EventServiceImplementation.getInstance().fireEvent(new Event(this, 1001, false).addAttribute("COMMAND", subsystem));
            }
            boolean bl = success;
            return bl;
        }
        catch (IOException ex) {
            throw new SshException(ex, 5);
        }
        finally {
            try {
                request.close();
            }
            catch (IOException iOException) {}
        }
    }

    boolean requestX11Forwarding(boolean singleconnection, String protocol, String cookie, int screen) throws SshException {
        ByteArrayWriter request = new ByteArrayWriter();
        try {
            request.writeBoolean(singleconnection);
            request.writeString(protocol);
            request.writeString(cookie);
            request.writeInt(screen);
            boolean bl = this.sendRequest("x11-req", true, request.toByteArray());
            return bl;
        }
        catch (IOException ex) {
            throw new SshException(ex, 5);
        }
        finally {
            try {
                request.close();
            }
            catch (IOException iOException) {}
        }
    }

    public boolean setEnvironmentVariable(String name, String value) throws SshException {
        ByteArrayWriter request = new ByteArrayWriter();
        try {
            request.writeString(name);
            request.writeString(value);
            boolean bl = this.sendRequest("env", true, request.toByteArray());
            return bl;
        }
        catch (IOException ex) {
            throw new SshException(ex, 5);
        }
        finally {
            try {
                request.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void changeTerminalDimensions(int cols, int rows, int width, int height) throws SshException {
        ByteArrayWriter request = new ByteArrayWriter();
        try {
            request.writeInt(cols);
            request.writeInt(rows);
            request.writeInt(height);
            request.writeInt(width);
            this.sendRequest("window-change", false, request.toByteArray());
        }
        catch (IOException ex) {
            throw new SshException(ex, 5);
        }
        finally {
            try {
                request.close();
            }
            catch (IOException iOException) {}
        }
    }

    public boolean isFlowControlEnabled() {
        return this.flowControlEnabled;
    }

    public void signal(String signal) throws SshException {
        ByteArrayWriter request = new ByteArrayWriter();
        try {
            request.writeString(signal);
            this.sendRequest("signal", false, request.toByteArray());
        }
        catch (IOException ex) {
            throw new SshException(ex, 5);
        }
        finally {
            try {
                request.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRequest(String requesttype, boolean wantreply, byte[] requestdata) throws SshException {
        try {
            if (requesttype.equals("exit-status") && requestdata != null) {
                this.exitcode = (int)ByteArrayReader.readInt(requestdata, 0);
            }
            if (requesttype.equals("exit-signal") && requestdata != null) {
                ByteArrayReader bar = new ByteArrayReader(requestdata, 0, requestdata.length);
                try {
                    this.exitsignalinfo = "Signal=" + bar.readString() + " CoreDump=" + String.valueOf(bar.read() != 0) + " Message=" + bar.readString();
                }
                finally {
                    try {
                        bar.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            if (requesttype.equals("xon-xoff")) {
                this.flowControlEnabled = requestdata != null && requestdata[0] != 0;
            }
            super.channelRequest(requesttype, wantreply, requestdata);
        }
        catch (IOException ex) {
            throw new SshException(ex, 5);
        }
    }

    public int exitCode() {
        return this.exitcode;
    }

    protected void checkCloseStatus(boolean remoteClosed) {
        if (!remoteClosed) {
            try {
                SshMessage message;
                if (Log.isDebugEnabled()) {
                    Log.debug(this, "Waiting for remote channel close id=" + this.channelid + " rid=" + this.remoteid);
                }
                if ((message = this.ms.nextMessage(this.CHANNEL_CLOSE_MESSAGES, Integer.parseInt(System.getProperty("maverick.remoteCloseTimeoutMs", "5000")))) != null) {
                    remoteClosed = true;
                    if (Log.isDebugEnabled()) {
                        Log.debug(this, "Remote channel is closed id=" + this.channelid + " rid=" + this.remoteid);
                    }
                } else if (Log.isDebugEnabled()) {
                    Log.debug(this, "Remote channel IS NOT closed id=" + this.channelid + " rid=" + this.remoteid);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.checkCloseStatus(remoteClosed);
    }

    public boolean hasExitSignal() {
        return !this.exitsignalinfo.equals("");
    }

    public String getExitSignalInfo() {
        return this.exitsignalinfo;
    }

    class CommandLogger
    extends ChannelAdapter {
        CommandLogger() {
        }

        public void dataReceived(SshChannel channel, byte[] buf, int off, int len) {
            Log.info(this, "Session IN: " + new String(buf, off, len));
        }

        public void dataSent(SshChannel channel, byte[] buf, int off, int len) {
            Log.info(this, "Session OUT: " + new String(buf, off, len));
        }
    }
}

