/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.ssh2;

import com.sshtools.logging.Log;
import com.sshtools.ssh.ChannelOpenException;
import com.sshtools.ssh.SshContext;
import com.sshtools.ssh.SshException;
import com.sshtools.ssh.message.Message;
import com.sshtools.ssh.message.MessageObserver;
import com.sshtools.ssh.message.SshAbstractChannel;
import com.sshtools.ssh.message.SshChannelMessage;
import com.sshtools.ssh.message.SshMessage;
import com.sshtools.ssh.message.SshMessageRouter;
import com.sshtools.ssh2.ChannelFactory;
import com.sshtools.ssh2.GlobalRequest;
import com.sshtools.ssh2.GlobalRequestHandler;
import com.sshtools.ssh2.Ssh2Channel;
import com.sshtools.ssh2.TransportProtocol;
import com.sshtools.ssh2.TransportProtocolListener;
import com.sshtools.util.ByteArrayWriter;
import java.io.IOException;
import java.util.Hashtable;

class ConnectionProtocol
extends SshMessageRouter
implements TransportProtocolListener {
    public static final String SERVICE_NAME = "ssh-connection";
    static final int SSH_MSG_CHANNEL_OPEN = 90;
    static final int SSH_MSG_CHANNEL_OPEN_CONFIRMATION = 91;
    static final int SSH_MSG_CHANNEL_OPEN_FAILURE = 92;
    static final int SSH_MSG_GLOBAL_REQUEST = 80;
    static final int SSH_MSG_REQUEST_SUCCESS = 81;
    static final int SSH_MSG_REQUEST_FAILURE = 82;
    Object channelOpenLock = new Object();
    static final MessageObserver CHANNEL_OPEN_RESPONSE_MESSAGES = new MessageObserver(){

        public boolean wantsNotification(Message msg) {
            switch (msg.getMessageId()) {
                case 91: 
                case 92: {
                    return true;
                }
            }
            return false;
        }
    };
    static final MessageObserver GLOBAL_REQUEST_MESSAGES = new MessageObserver(){

        public boolean wantsNotification(Message msg) {
            switch (msg.getMessageId()) {
                case 81: 
                case 82: {
                    return true;
                }
            }
            return false;
        }
    };
    TransportProtocol transport;
    Hashtable<String, ChannelFactory> channelfactories = new Hashtable();
    Hashtable<String, GlobalRequestHandler> requesthandlers = new Hashtable();

    public ConnectionProtocol(TransportProtocol transport, SshContext context, boolean buffered) {
        super(transport, context.getChannelLimit(), buffered);
        this.transport = transport;
        this.transport.addListener(this);
    }

    public void addChannelFactory(ChannelFactory factory) throws SshException {
        String[] types = factory.supportedChannelTypes();
        for (int i = 0; i < types.length; ++i) {
            if (this.channelfactories.containsKey(types[i])) {
                throw new SshException(types[i] + " channel is already registered!", 4);
            }
            this.channelfactories.put(types[i], factory);
        }
    }

    public void addRequestHandler(GlobalRequestHandler handler) throws SshException {
        String[] types = handler.supportedRequests();
        for (int i = 0; i < types.length; ++i) {
            if (this.requesthandlers.containsKey(types[i])) {
                throw new SshException(types[i] + " request is already registered!", 4);
            }
            this.requesthandlers.put(types[i], handler);
        }
    }

    public boolean sendGlobalRequest(GlobalRequest request, boolean wantreply) throws SshException {
        return this.sendGlobalRequest(request, wantreply, 0L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean sendGlobalRequest(GlobalRequest request, boolean wantreply, long timeout) throws SshException {
        ByteArrayWriter msg = new ByteArrayWriter();
        try {
            msg.write(80);
            msg.writeString(request.getName());
            msg.writeBoolean(wantreply);
            if (request.getData() != null) {
                msg.write(request.getData());
            }
            if (Log.isDebugEnabled()) {
                Log.debug(this, "Sending SSH_MSG_GLOBAL_REQUEST request=" + request.getName() + " wantreply=" + wantreply);
            }
            this.sendMessage(msg.toByteArray(), true);
            if (wantreply) {
                SshMessage reply = this.getGlobalMessages().nextMessage(GLOBAL_REQUEST_MESSAGES, timeout);
                if (reply.getMessageId() == 81) {
                    if (Log.isDebugEnabled()) {
                        Log.debug(this, "Received SSH_MSG_REQUEST_SUCCESS request=" + request.getName());
                    }
                    if (reply.available() > 0) {
                        byte[] tmp = new byte[reply.available()];
                        reply.read(tmp);
                        request.setData(tmp);
                    } else {
                        request.setData(null);
                    }
                    boolean bl = true;
                    return bl;
                }
                if (Log.isDebugEnabled()) {
                    Log.debug(this, "Received SSH_MSG_REQUEST_FAILURE request=" + request.getName());
                }
                boolean bl = false;
                return bl;
            }
            boolean reply = true;
            return reply;
        }
        catch (IOException ex) {
            throw new SshException(ex, 5);
        }
        finally {
            try {
                msg.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void closeChannel(Ssh2Channel channel) {
        this.freeChannel(channel);
    }

    public SshContext getContext() {
        return this.transport.transportContext;
    }

    public void openChannel(Ssh2Channel channel, byte[] requestdata) throws SshException, ChannelOpenException {
        this.openChannel(channel, requestdata, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openChannel(Ssh2Channel channel, byte[] requestdata, long timeout) throws SshException, ChannelOpenException {
        try {
            int channelid = this.allocateChannel(channel);
            if (channelid == -1) {
                if (Log.isDebugEnabled()) {
                    Log.debug(this, "Maximum number of channels exceeded! active=" + this.getChannelCount() + " channels=" + this.getMaxChannels());
                }
                throw new ChannelOpenException("Maximum number of channels exceeded", 4);
            }
            channel.init(this, channelid);
            ByteArrayWriter msg = new ByteArrayWriter();
            try {
                msg.write(90);
                msg.writeString(channel.getName());
                msg.writeInt(channel.getChannelId());
                msg.writeInt(channel.getWindowSize());
                msg.writeInt(channel.getPacketSize());
                if (requestdata != null) {
                    msg.write(requestdata);
                }
                if (Log.isDebugEnabled()) {
                    Log.debug(this, "Sending SSH_MSG_CHANNEL_OPEN type=" + channel.getName() + " id=" + channel.getChannelId() + " window=" + channel.getWindowSize() + " packet=" + channel.getPacketSize());
                }
                this.transport.sendMessage(msg.toByteArray(), true);
            }
            finally {
                try {
                    msg.close();
                }
                catch (IOException iOException) {}
            }
            SshMessage reply = channel.getMessageStore().nextMessage(CHANNEL_OPEN_RESPONSE_MESSAGES, timeout);
            if (reply.getMessageId() == 92) {
                if (Log.isDebugEnabled()) {
                    Log.debug(this, "Received SSH_MSG_CHANNEL_OPEN_FAILURE id=" + channel.getChannelId());
                }
                this.freeChannel(channel);
                int reason = (int)reply.readInt();
                throw new ChannelOpenException(reply.readString(), reason);
            }
            int remoteid = (int)reply.readInt();
            long remotewindow = reply.readInt();
            int remotepacket = (int)reply.readInt();
            byte[] responsedata = new byte[reply.available()];
            reply.read(responsedata);
            if (Log.isDebugEnabled()) {
                Log.debug(this, "Received SSH_MSG_CHANNEL_OPEN_CONFIRMATION id=" + channel.getChannelId() + " rid=" + remoteid + " window=" + remotewindow + " packet=" + remotepacket);
            }
            channel.open(remoteid, remotewindow, remotepacket, responsedata);
            return;
        }
        catch (IOException ex) {
            throw new SshException(ex, 5);
        }
    }

    protected void sendMessage(byte[] msg, boolean isActivity) throws SshException {
        this.transport.sendMessage(msg, isActivity);
    }

    protected SshMessage createMessage(byte[] msg) throws SshException {
        if (msg[0] >= 91 && msg[0] <= 100) {
            return new SshChannelMessage(msg);
        }
        return new SshMessage(msg);
    }

    protected boolean processGlobalMessage(SshMessage message) throws SshException {
        try {
            switch (message.getMessageId()) {
                case 90: {
                    String type = message.readString();
                    int remoteid = (int)message.readInt();
                    int remotewindow = (int)message.readInt();
                    int remotepacket = (int)message.readInt();
                    byte[] requestdata = message.available() > 0 ? new byte[message.available()] : null;
                    message.read(requestdata);
                    if (Log.isDebugEnabled()) {
                        Log.debug(this, "Received SSH_MSG_CHANNEL_OPEN rid=" + remoteid + " window=" + remotewindow + " packet=" + remotepacket);
                    }
                    this.processChannelOpenRequest(type, remoteid, remotewindow, remotepacket, requestdata);
                    return true;
                }
                case 80: {
                    String requestname = message.readString();
                    boolean wantreply = message.read() != 0;
                    byte[] requestdata = new byte[message.available()];
                    message.read(requestdata);
                    if (Log.isDebugEnabled()) {
                        Log.debug(this, "Received SSH_MSG_GLOBAL_REQUEST request=" + requestname + " wantreply=" + wantreply);
                    }
                    this.processGlobalRequest(requestname, wantreply, requestdata);
                    return true;
                }
            }
            return false;
        }
        catch (IOException ex) {
            throw new SshException(ex, 5);
        }
    }

    /*
     * Exception decompiling
     */
    void processChannelOpenRequest(String type, int remoteid, int remotewindow, int remotepacket, byte[] requestdata) throws SshException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 10[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void processGlobalRequest(String requestname, boolean wantreply, byte[] requestdata) throws SshException {
        ByteArrayWriter response = new ByteArrayWriter();
        try {
            boolean success = false;
            GlobalRequest request = new GlobalRequest(requestname, requestdata);
            if (this.requesthandlers.containsKey(requestname)) {
                success = this.requesthandlers.get(requestname).processGlobalRequest(request);
            }
            if (wantreply) {
                if (success) {
                    response.write(81);
                    if (request.getData() != null) {
                        response.write(request.getData());
                    }
                    if (Log.isDebugEnabled()) {
                        Log.debug(this, "Sending SSH_MSG_REQUEST_SUCCESS request=" + requestname);
                    }
                    this.transport.sendMessage(response.toByteArray(), true);
                } else {
                    this.transport.sendMessage(new byte[]{82}, true);
                }
            }
        }
        catch (IOException ex) {
            throw new SshException(ex, 5);
        }
        finally {
            try {
                response.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected void onThreadExit() {
        if (this.transport != null && this.transport.isConnected()) {
            this.transport.disconnect(10, "Exiting");
        }
        this.stop();
    }

    public void onDisconnect(String msg, int reason) {
    }

    public void onIdle(long lastActivity) {
        SshAbstractChannel[] channels = this.getActiveChannels();
        for (int i = 0; i < channels.length; ++i) {
            channels[i].idle();
        }
    }
}

