/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.ssh.message;

import com.sshtools.logging.Log;
import com.sshtools.ssh.SshException;
import com.sshtools.ssh.message.Message;
import com.sshtools.ssh.message.MessageObserver;
import com.sshtools.ssh.message.MessageStore;
import com.sshtools.ssh.message.SshAbstractChannel;
import com.sshtools.ssh.message.SshMessage;
import com.sshtools.ssh.message.SshMessageRouter;
import java.io.EOFException;

public class SshMessageStore
implements MessageStore {
    public static final int NO_MESSAGES = -1;
    SshAbstractChannel channel;
    SshMessageRouter manager;
    boolean closed = false;
    SshMessage header = new SshMessage();
    int size = 0;
    MessageObserver stickyMessageObserver;
    boolean verbose = Boolean.valueOf(System.getProperty("maverick.verbose", "false"));

    public SshMessageStore(SshMessageRouter manager, SshAbstractChannel channel, MessageObserver stickyMessageObserver) {
        this.manager = manager;
        this.channel = channel;
        this.stickyMessageObserver = stickyMessageObserver;
        this.header.next = this.header.previous = this.header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SshMessage nextMessage(MessageObserver observer, long timeout) throws SshException, EOFException {
        try {
            SshMessage msg = this.manager.nextMessage(this.channel, observer, timeout);
            if (Log.isDebugEnabled() && this.verbose) {
                Log.debug(this, "got managers next message");
            }
            if (msg != null) {
                SshMessage sshMessage = this.header;
                synchronized (sshMessage) {
                    if (this.stickyMessageObserver.wantsNotification(msg)) {
                        return msg;
                    }
                    this.remove(msg);
                    return msg;
                }
            }
        }
        catch (InterruptedException ex) {
            throw new SshException("The thread was interrupted", 5);
        }
        throw new EOFException("The required message could not be found in the message store");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        SshMessage sshMessage = this.header;
        synchronized (sshMessage) {
            return this.closed;
        }
    }

    private void remove(SshMessage e) {
        if (e == this.header) {
            throw new IndexOutOfBoundsException();
        }
        e.previous.next = e.next;
        e.next.previous = e.previous;
        --this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message hasMessage(MessageObserver observer) {
        if (Log.isDebugEnabled() && this.verbose) {
            Log.debug(this, "waiting for header lock");
        }
        SshMessage sshMessage = this.header;
        synchronized (sshMessage) {
            SshMessage e = this.header.next;
            if (e == null) {
                if (Log.isDebugEnabled() && this.verbose) {
                    Log.debug(this, "header.next is null");
                }
                return null;
            }
            while (e != this.header) {
                if (observer.wantsNotification(e)) {
                    if (Log.isDebugEnabled() && this.verbose) {
                        Log.debug(this, "found message");
                    }
                    return e;
                }
                e = e.next;
            }
            if (Log.isDebugEnabled() && this.verbose) {
                Log.debug(this, "no messages");
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        SshMessage sshMessage = this.header;
        synchronized (sshMessage) {
            this.closed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addMessage(SshMessage msg) {
        SshMessage sshMessage = this.header;
        synchronized (sshMessage) {
            msg.next = this.header;
            msg.previous = this.header.previous;
            msg.previous.next = msg;
            msg.next.previous = msg;
            ++this.size;
        }
    }
}

