/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.ssh.message;

import com.sshtools.ssh.SshChannel;
import com.sshtools.ssh.SshException;
import com.sshtools.ssh.message.MessageObserver;
import com.sshtools.ssh.message.SshChannelMessage;
import com.sshtools.ssh.message.SshMessageRouter;
import com.sshtools.ssh.message.SshMessageStore;

public abstract class SshAbstractChannel
implements SshChannel {
    public static final int CHANNEL_UNINITIALIZED = 1;
    public static final int CHANNEL_OPEN = 2;
    public static final int CHANNEL_CLOSED = 3;
    protected int channelid = -1;
    protected int state = 1;
    protected SshMessageRouter manager;
    protected SshMessageStore ms;

    protected SshMessageStore getMessageStore() throws SshException {
        if (this.ms == null) {
            throw new SshException("Channel is not initialized!", 5);
        }
        return this.ms;
    }

    public int getChannelId() {
        return this.channelid;
    }

    public SshMessageRouter getMessageRouter() {
        return this.manager;
    }

    protected void init(SshMessageRouter manager, int channelid) {
        this.channelid = channelid;
        this.manager = manager;
        this.ms = new SshMessageStore(manager, this, this.getStickyMessageIds());
    }

    protected abstract MessageObserver getStickyMessageIds();

    public boolean isClosed() {
        return this.state == 3;
    }

    public void idle() {
    }

    protected abstract boolean processChannelMessage(SshChannelMessage var1) throws SshException;
}

