/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.ssh.components.jce;

import com.sshtools.ssh.SshException;
import com.sshtools.ssh.SshKeyFingerprint;
import com.sshtools.ssh.components.SshDsaPublicKey;
import com.sshtools.ssh.components.SshPublicKey;
import com.sshtools.ssh.components.jce.JCEProvider;
import com.sshtools.util.ByteArrayReader;
import com.sshtools.util.ByteArrayWriter;
import com.sshtools.util.SimpleASNWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;

public class Ssh2DsaPublicKey
implements SshDsaPublicKey {
    protected DSAPublicKey pubkey;

    public Ssh2DsaPublicKey() {
    }

    public Ssh2DsaPublicKey(DSAPublicKey pub) {
        this.pubkey = pub;
    }

    public Ssh2DsaPublicKey(BigInteger p, BigInteger q, BigInteger g, BigInteger y) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = JCEProvider.getProviderForAlgorithm("DSA") == null ? KeyFactory.getInstance("DSA") : KeyFactory.getInstance("DSA", JCEProvider.getProviderForAlgorithm("DSA"));
        DSAPublicKeySpec publicKeySpec = new DSAPublicKeySpec(y, p, q, g);
        this.pubkey = (DSAPublicKey)keyFactory.generatePublic(publicKeySpec);
    }

    public String getAlgorithm() {
        return "ssh-dss";
    }

    public int getBitLength() {
        return this.pubkey.getParams().getP().bitLength();
    }

    public byte[] getEncoded() throws SshException {
        ByteArrayWriter baw = new ByteArrayWriter();
        try {
            baw.writeString(this.getAlgorithm());
            baw.writeBigInteger(this.pubkey.getParams().getP());
            baw.writeBigInteger(this.pubkey.getParams().getQ());
            baw.writeBigInteger(this.pubkey.getParams().getG());
            baw.writeBigInteger(this.pubkey.getY());
            byte[] byArray = baw.toByteArray();
            return byArray;
        }
        catch (IOException ioe) {
            throw new SshException("Failed to encoded DSA key", 5, ioe);
        }
        finally {
            try {
                baw.close();
            }
            catch (IOException iOException) {}
        }
    }

    public String getFingerprint() throws SshException {
        return SshKeyFingerprint.getFingerprint(this.getEncoded());
    }

    public void init(byte[] blob, int start, int len) throws SshException {
        ByteArrayReader bar = new ByteArrayReader(blob, start, len);
        try {
            String header = bar.readString();
            if (!header.equals(this.getAlgorithm())) {
                throw new SshException("The encoded key is not DSA", 5);
            }
            BigInteger p = bar.readBigInteger();
            BigInteger q = bar.readBigInteger();
            BigInteger g = bar.readBigInteger();
            BigInteger y = bar.readBigInteger();
            DSAPublicKeySpec dsaKey = new DSAPublicKeySpec(y, p, q, g);
            KeyFactory kf = JCEProvider.getProviderForAlgorithm("DSA") == null ? KeyFactory.getInstance("DSA") : KeyFactory.getInstance("DSA", JCEProvider.getProviderForAlgorithm("DSA"));
            this.pubkey = (DSAPublicKey)kf.generatePublic(dsaKey);
        }
        catch (Exception ex) {
            throw new SshException("Failed to obtain DSA key instance from JCE", 5, ex);
        }
        finally {
            try {
                bar.close();
            }
            catch (IOException iOException) {}
        }
    }

    public boolean verifySignature(byte[] signature, byte[] data) throws SshException {
        ByteArrayReader bar = new ByteArrayReader(signature);
        try {
            if (signature.length != 40 && signature.length != 56 && signature.length != 64) {
                byte[] sig = bar.readBinaryString();
                String header = new String(sig);
                if (!header.equals("ssh-dss")) {
                    throw new SshException("The encoded signature is not DSA", 5);
                }
                signature = bar.readBinaryString();
            }
            int numSize = signature.length / 2;
            ByteArrayOutputStream r = new ByteArrayOutputStream();
            ByteArrayOutputStream s = new ByteArrayOutputStream();
            SimpleASNWriter asn = new SimpleASNWriter();
            asn.writeByte(2);
            if ((signature[0] & 0x80) == 128 && signature[0] != 0) {
                r.write(0);
                r.write(signature, 0, numSize);
            } else {
                r.write(signature, 0, numSize);
            }
            asn.writeData(r.toByteArray());
            asn.writeByte(2);
            if ((signature[numSize] & 0x80) == 128 && signature[numSize] != 0) {
                s.write(0);
                s.write(signature, numSize, numSize);
            } else {
                s.write(signature, numSize, numSize);
            }
            asn.writeData(s.toByteArray());
            SimpleASNWriter asnEncoded = new SimpleASNWriter();
            asnEncoded.writeByte(48);
            asnEncoded.writeData(asn.toByteArray());
            byte[] encoded = asnEncoded.toByteArray();
            Signature sig = JCEProvider.getProviderForAlgorithm("SHA1WithDSA") == null ? Signature.getInstance("SHA1WithDSA") : Signature.getInstance("SHA1WithDSA", JCEProvider.getProviderForAlgorithm("SHA1WithDSA"));
            sig.initVerify(this.pubkey);
            sig.update(data);
            boolean bl = sig.verify(encoded);
            return bl;
        }
        catch (Exception ex) {
            throw new SshException(16, (Throwable)ex);
        }
        finally {
            try {
                bar.close();
            }
            catch (IOException iOException) {}
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof SshDsaPublicKey) {
            try {
                return ((SshPublicKey)obj).getFingerprint().equals(this.getFingerprint());
            }
            catch (SshException sshException) {
                // empty catch block
            }
        }
        return false;
    }

    public int hashCode() {
        try {
            return this.getFingerprint().hashCode();
        }
        catch (SshException ex) {
            return 0;
        }
    }

    public BigInteger getG() {
        return this.pubkey.getParams().getG();
    }

    public BigInteger getP() {
        return this.pubkey.getParams().getP();
    }

    public BigInteger getQ() {
        return this.pubkey.getParams().getQ();
    }

    public BigInteger getY() {
        return this.pubkey.getY();
    }
}

