/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.ssh.components.jce;

import com.sshtools.ssh.components.jce.JCEAlgorithms;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Hashtable;

public class JCEProvider
implements JCEAlgorithms {
    static Provider defaultProvider = null;
    static Hashtable<String, Provider> specficProviders = new Hashtable();
    static String secureRandomAlgorithm = "SHA1PRNG";
    static SecureRandom secureRandom;

    public static void initializeDefaultProvider(Provider provider) {
        defaultProvider = provider;
    }

    public static void initializeProviderForAlgorithm(String jceAlgorithm, Provider provider) {
        specficProviders.put(jceAlgorithm, provider);
    }

    public static String getSecureRandomAlgorithm() {
        return secureRandomAlgorithm;
    }

    public static void setSecureRandomAlgorithm(String secureRandomAlgorithm) {
        JCEProvider.secureRandomAlgorithm = secureRandomAlgorithm;
    }

    public static Provider getProviderForAlgorithm(String jceAlgorithm) {
        if (specficProviders.containsKey(jceAlgorithm)) {
            return specficProviders.get(jceAlgorithm);
        }
        return defaultProvider;
    }

    public static SecureRandom getSecureRandom() throws NoSuchAlgorithmException {
        if (secureRandom == null) {
            try {
                secureRandom = JCEProvider.getProviderForAlgorithm(JCEProvider.getSecureRandomAlgorithm()) == null ? SecureRandom.getInstance(JCEProvider.getSecureRandomAlgorithm()) : SecureRandom.getInstance(JCEProvider.getSecureRandomAlgorithm(), JCEProvider.getProviderForAlgorithm(JCEProvider.getSecureRandomAlgorithm()));
                return secureRandom;
            }
            catch (NoSuchAlgorithmException e) {
                secureRandom = SecureRandom.getInstance(JCEProvider.getSecureRandomAlgorithm());
                return secureRandom;
            }
        }
        return secureRandom;
    }
}

