/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.ssh.components.jce;

import com.sshtools.ssh.SshException;
import com.sshtools.ssh.components.ComponentManager;
import com.sshtools.ssh.components.Digest;
import com.sshtools.ssh.components.SshKeyExchangeClient;
import com.sshtools.ssh.components.jce.AbstractKeyExchange;
import com.sshtools.ssh.components.jce.JCEProvider;
import com.sshtools.util.ByteArrayReader;
import com.sshtools.util.ByteArrayWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import javax.crypto.KeyAgreement;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;

public class DiffieHellmanGroupExchangeSha1
extends SshKeyExchangeClient
implements AbstractKeyExchange {
    public static final String DIFFIE_HELLMAN_GROUP_EXCHANGE_SHA1 = "diffie-hellman-group-exchange-sha1";
    static final int SSH_MSG_KEXDH_GEX_REQUEST_OLD = 30;
    static final int SSH_MSG_KEXDH_GEX_GROUP = 31;
    static final int SSH_MSG_KEXDH_GEX_INIT = 32;
    static final int SSH_MSG_KEXDH_GEX_REPLY = 33;
    static final int SSH_MSG_KEXDH_GEX_REQUEST = 34;
    BigInteger g;
    BigInteger p;
    static BigInteger ONE = BigInteger.valueOf(1L);
    BigInteger e = null;
    BigInteger f = null;
    BigInteger y = null;
    String clientId;
    String serverId;
    byte[] clientKexInit;
    byte[] serverKexInit;
    KeyPairGenerator dhKeyPairGen;
    KeyAgreement dhKeyAgreement;
    KeyFactory dhKeyFactory;

    public DiffieHellmanGroupExchangeSha1() {
        this("SHA-1");
    }

    protected DiffieHellmanGroupExchangeSha1(String algorithm) {
        super(algorithm);
    }

    public boolean isKeyExchangeMessage(int messageid) {
        switch (messageid) {
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                return true;
            }
        }
        return false;
    }

    public String getAlgorithm() {
        return DIFFIE_HELLMAN_GROUP_EXCHANGE_SHA1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performClientExchange(String clientIdentification, String serverIdentification, byte[] clientKexInit, byte[] serverKexInit) throws SshException {
        try {
            this.clientId = clientIdentification;
            this.serverId = serverIdentification;
            this.clientKexInit = clientKexInit;
            this.serverKexInit = serverKexInit;
            try {
                this.dhKeyFactory = JCEProvider.getProviderForAlgorithm("DH") == null ? KeyFactory.getInstance("DH") : KeyFactory.getInstance("DH", JCEProvider.getProviderForAlgorithm("DH"));
                this.dhKeyPairGen = JCEProvider.getProviderForAlgorithm("DH") == null ? KeyPairGenerator.getInstance("DH") : KeyPairGenerator.getInstance("DH", JCEProvider.getProviderForAlgorithm("DH"));
                this.dhKeyAgreement = JCEProvider.getProviderForAlgorithm("DH") == null ? KeyAgreement.getInstance("DH") : KeyAgreement.getInstance("DH", JCEProvider.getProviderForAlgorithm("DH"));
            }
            catch (NoSuchAlgorithmException ex) {
                throw new SshException("JCE does not support Diffie Hellman key exchange", 16);
            }
            ByteArrayWriter msg = new ByteArrayWriter();
            boolean disableBackwardsCompatibility = !this.transport.getContext().isDHGroupExchangeBackwardsCompatible();
            int preferredKeySize = this.transport.getContext().getDHGroupExchangeKeySize();
            try {
                msg.write(disableBackwardsCompatibility ? 34 : 30);
                if (disableBackwardsCompatibility) {
                    msg.writeInt(1024);
                    msg.writeInt(preferredKeySize);
                    msg.writeInt(8192);
                } else {
                    msg.writeInt(preferredKeySize);
                }
                this.transport.sendMessage(msg.toByteArray(), true);
            }
            finally {
                try {
                    msg.close();
                }
                catch (IOException iOException) {}
            }
            byte[] tmp = this.transport.nextMessage();
            if (tmp[0] != 31) {
                this.transport.disconnect(3, "Expected SSH_MSG_KEX_GEX_GROUP");
                throw new SshException("Key exchange failed: Expected SSH_MSG_KEX_GEX_GROUP [id=" + tmp[0] + "]", 5);
            }
            ByteArrayReader bar = new ByteArrayReader(tmp, 1, tmp.length - 1);
            try {
                this.p = bar.readBigInteger();
                this.g = bar.readBigInteger();
                DHParameterSpec dhSkipParamSpec = new DHParameterSpec(this.p, this.g);
                this.dhKeyPairGen.initialize(dhSkipParamSpec);
                KeyPair dhKeyPair = this.dhKeyPairGen.generateKeyPair();
                this.dhKeyAgreement.init(dhKeyPair.getPrivate());
                this.e = ((DHPublicKey)dhKeyPair.getPublic()).getY();
            }
            catch (InvalidKeyException ex) {
                throw new SshException("Failed to generate DH value", 16);
            }
            catch (InvalidAlgorithmParameterException ex) {
                throw new SshException("Failed to generate DH value", 16);
            }
            finally {
                try {
                    bar.close();
                }
                catch (IOException iOException) {}
            }
            msg.reset();
            msg.write(32);
            msg.writeBigInteger(this.e);
            this.transport.sendMessage(msg.toByteArray(), true);
            tmp = this.transport.nextMessage();
            if (tmp[0] != 33) {
                this.transport.disconnect(3, "Expected SSH_MSG_KEXDH_GEX_REPLY");
                throw new SshException("Key exchange failed: Expected SSH_MSG_KEXDH_GEX_REPLY [id=" + tmp[0] + "]", 5);
            }
            bar = new ByteArrayReader(tmp, 1, tmp.length - 1);
            try {
                this.hostKey = bar.readBinaryString();
                this.f = bar.readBigInteger();
                this.signature = bar.readBinaryString();
                DHPublicKeySpec spec = new DHPublicKeySpec(this.f, this.p, this.g);
                DHPublicKey key = (DHPublicKey)this.dhKeyFactory.generatePublic(spec);
                this.dhKeyAgreement.doPhase(key, true);
                tmp = this.dhKeyAgreement.generateSecret();
                if ((tmp[0] & 0x80) == 128) {
                    byte[] tmp2 = new byte[tmp.length + 1];
                    System.arraycopy(tmp, 0, tmp2, 1, tmp.length);
                    tmp = tmp2;
                }
                this.secret = new BigInteger(tmp);
                this.calculateExchangeHash(disableBackwardsCompatibility, preferredKeySize);
            }
            finally {
                bar.close();
            }
        }
        catch (Exception ex) {
            throw new SshException(ex, 5);
        }
    }

    public String getProvider() {
        if (this.dhKeyAgreement != null) {
            return this.dhKeyAgreement.getProvider().getName();
        }
        return "";
    }

    protected void calculateExchangeHash(boolean disableBackwardsCompatibility, int preferredKeySize) throws SshException {
        Digest hash = (Digest)ComponentManager.getInstance().supportedDigests().getInstance(this.getHashAlgorithm());
        hash.putString(this.clientId);
        hash.putString(this.serverId);
        hash.putInt(this.clientKexInit.length);
        hash.putBytes(this.clientKexInit);
        hash.putInt(this.serverKexInit.length);
        hash.putBytes(this.serverKexInit);
        hash.putInt(this.hostKey.length);
        hash.putBytes(this.hostKey);
        if (disableBackwardsCompatibility) {
            hash.putInt(1024);
            hash.putInt(preferredKeySize);
            hash.putInt(8192);
        } else {
            hash.putInt(preferredKeySize);
        }
        hash.putBigInteger(this.p);
        hash.putBigInteger(this.g);
        hash.putBigInteger(this.e);
        hash.putBigInteger(this.f);
        hash.putBigInteger(this.secret);
        this.exchangeHash = hash.doFinal();
    }
}

