/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.ssh;

import com.sshtools.ssh.Packet;
import com.sshtools.ssh.SshChannel;
import com.sshtools.ssh.SshException;
import com.sshtools.ssh.SshIOException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Vector;

public class SubsystemChannel {
    DataInputStream in;
    DataOutputStream out;
    Vector<Packet> packets = new Vector();
    int maximumPacketSize = Integer.parseInt(System.getProperty("maverick.sftp.maxPacketSize", "1024000"));
    protected SshChannel channel;
    Reader reader = new Reader();
    Writer writer = new Writer();

    public SubsystemChannel(SshChannel channel) throws SshException {
        this.channel = channel;
        try {
            this.in = new DataInputStream(channel.getInputStream());
            this.out = new DataOutputStream(channel.getOutputStream());
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex) {
            throw new SshException(ex.getMessage(), 6);
        }
    }

    public boolean isClosed() {
        return this.channel.isClosed();
    }

    public void close() throws IOException {
        this.packets.removeAllElements();
        this.channel.close();
    }

    public byte[] nextMessage() throws SshException {
        return this.reader.readMessage(this.in);
    }

    protected void sendMessage(Packet msg) throws SshException {
        this.writer.sendMessage(msg);
    }

    protected void sendMessage(byte[] msg) throws SshException {
        try {
            Packet pkt = this.createPacket();
            pkt.write(msg);
            this.sendMessage(pkt);
        }
        catch (IOException ex) {
            throw new SshException(1, (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Packet createPacket() throws IOException {
        Vector<Packet> vector = this.packets;
        synchronized (vector) {
            if (this.packets.size() == 0) {
                return new Packet();
            }
            Packet p = this.packets.elementAt(0);
            this.packets.removeElementAt(0);
            return p;
        }
    }

    class Reader {
        Reader() {
        }

        synchronized byte[] readMessage(DataInputStream in) throws SshException {
            int len = -1;
            try {
                len = in.readInt();
                if (len < 0) {
                    throw new SshException("Negative message length in SFTP protocol.", 3);
                }
                if (len > SubsystemChannel.this.maximumPacketSize) {
                    throw new SshException("Invalid message length in SFTP protocol [" + len + "]", 3);
                }
                byte[] msg = new byte[len];
                in.readFully(msg);
                return msg;
            }
            catch (OutOfMemoryError ex) {
                throw new SshException("Invalid message length in SFTP protocol [" + len + "]", 3);
            }
            catch (EOFException ex) {
                try {
                    SubsystemChannel.this.close();
                }
                catch (SshIOException ex1) {
                    throw ex1.getRealException();
                }
                catch (IOException ex1) {
                    throw new SshException(ex1.getMessage(), 6);
                }
                throw new SshException("The channel unexpectedly terminated", 6);
            }
            catch (IOException ex) {
                if (ex instanceof SshIOException) {
                    throw ((SshIOException)ex).getRealException();
                }
                try {
                    SubsystemChannel.this.close();
                }
                catch (SshIOException ex2) {
                    throw ex2.getRealException();
                }
                catch (IOException ex1) {
                    throw new SshException(ex1.getMessage(), 6);
                }
                throw new SshException(6, (Throwable)ex);
            }
        }
    }

    class Writer {
        Writer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void sendMessage(Packet msg) throws SshException {
            try {
                msg.finish();
                SubsystemChannel.this.out.write(msg.array(), 0, msg.size());
            }
            catch (SshIOException ex) {
                throw ex.getRealException();
            }
            catch (EOFException ex) {
                try {
                    SubsystemChannel.this.close();
                }
                catch (SshIOException ex1) {
                    throw ex1.getRealException();
                }
                catch (IOException ex1) {
                    throw new SshException(ex1.getMessage(), 6);
                }
                throw new SshException("The channel unexpectedly terminated", 6);
            }
            catch (IOException ex) {
                try {
                    SubsystemChannel.this.close();
                }
                catch (SshIOException ex2) {
                    throw ex2.getRealException();
                }
                catch (IOException ex1) {
                    throw new SshException(ex1.getMessage(), 6);
                }
                throw new SshException("Unknown channel IO failure: " + ex.getMessage(), 6);
            }
            finally {
                msg.reset();
                Vector<Packet> vector = SubsystemChannel.this.packets;
                synchronized (vector) {
                    SubsystemChannel.this.packets.addElement(msg);
                }
            }
        }
    }
}

