/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.ssh;

import com.sshtools.ssh.SshException;
import com.sshtools.ssh.components.ComponentManager;
import com.sshtools.ssh.components.Digest;

public class SshKeyFingerprint {
    public static final String MD5_FINGERPRINT = "MD5";
    public static final String SHA1_FINGERPRINT = "SHA-1";
    public static final String SHA256_FINGERPRINT = "SHA-256";
    private static String defaultHashAlgoritm = "MD5";
    static char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String getFingerprint(byte[] encoded) throws SshException {
        return SshKeyFingerprint.getFingerprint(encoded, defaultHashAlgoritm);
    }

    public static void setDefaultHashAlgorithm(String defaultHashAlgorithm) {
        defaultHashAlgoritm = defaultHashAlgorithm;
    }

    public static String getFingerprint(byte[] encoded, String algorithm) throws SshException {
        Digest md5 = (Digest)ComponentManager.getInstance().supportedDigests().getInstance(algorithm);
        md5.putBytes(encoded);
        byte[] digest = md5.doFinal();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < digest.length; ++i) {
            int ch = digest[i] & 0xFF;
            if (i > 0) {
                buf.append(':');
            }
            buf.append(HEX[ch >>> 4 & 0xF]);
            buf.append(HEX[ch & 0xF]);
        }
        return buf.toString();
    }
}

